package org.gcube.data.spd.specieslink;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.gcube.data.spd.plugin.fwk.Coordinate;
import org.gcube.data.spd.plugin.fwk.Property;

public class Utils {

	public static String credits;

	//create filters
	static String elaborateProps(Property[] properties) throws Exception{
        StringBuilder props =new StringBuilder(); 
        for (Property prop: properties){
        	switch (prop.getProp()) {
                case CoordinateFrom:
                	Coordinate coordFrom = (Coordinate)prop.getValue();
                	props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLatitude%20greaterThanOrEquals%20%22"+coordFrom.getLatitude()+"%22");
                	props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLongitude%20greaterThanOrEquals%20%22"+coordFrom.getLongitude()+"%22");
                	break;
                case CoordinateTo:
                	Coordinate coordTo = (Coordinate)prop.getValue();
                	props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLatitude%20lessThanOrEqual%20%22"+coordTo.getLatitude()+"%22");
                	props.append("%20and%20http://rs.tdwg.org/dwc/geospatial/DecimalLongitude%20lessThanOrEqual%20%22"+coordTo.getLongitude()+"%22");
                	break;        
                case DateFrom:
                	Calendar dateFrom = (Calendar) prop.getValue();
                	DateFormat dfFrom = new  SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                 	props.append("%20and%20http://rs.tdwg.org/dwc/dwcore/DateLastModified%20greaterThanOrEquals%20%22"+dfFrom.format(dateFrom.getTime())+"%22");
                 	break;
                case DateTo:
                	Calendar dateTo = (Calendar) prop.getValue();
                  	DateFormat dfTo = new  SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                  	props.append("%20and%20http://rs.tdwg.org/dwc/dwcore/DateLastModified%20lessThanOrEquals%20%22"+dfTo.format(dateTo.getTime())+"%22");
                  	break;        
                default:
                	break;
                }
        }
        return props.toString();
	}

	public static String credits() {
		Calendar now = Calendar.getInstance();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		String credits = SpeciesLinkPlugin.credits.replace("XDATEX", format.format(now.getTime()));
		return credits;
	}

	public static String citation() {
		Calendar now = Calendar.getInstance();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		String citation = SpeciesLinkPlugin.citation.replace("XDATEX", format.format(now.getTime()));
		return citation;
	}
}
