/**
 * 
 */
package org.gcube.dataaccess.spql.stmt;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public class QueryStatement extends AbstractStatement {

	protected boolean first;

	public QueryStatement(StringBuilder query) {
		super(query);
		first = true;
	}

	protected void checkFirst()
	{
		if (!first) query.append(", ");
		first = false;
	}

	public QueryStatement asScientificName(String ... scientificNames)
	{
		if (scientificNames!=null && scientificNames.length!=0) {
			checkFirst();
			appendNames(scientificNames);
			query.append(" as ScientificName");
		}
		return this;
	}

	public QueryStatement asCommonName(String ... commonNames)
	{

		if (commonNames!=null && commonNames.length!=0) {
			checkFirst();
			appendNames(commonNames);
			query.append(" as CommonName");
		}
		return this;
	}

	public InStatement in(String ... datasources)
	{
		return new InStatement(query, datasources);
	}

	public WhereStatement where()
	{
		return new WhereStatement(query);
	}
}
