package org.gcube.datatransfer.agent.library.outcome;

import org.gcube.datatransfer.agent.library.grs.FileOutcomeRecord.Outcome;

/**
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class FileTransferOutcome {
	
	public String getFilename() {
		return filename;
	}


	public void setFilename(String filename) {
		this.filename = filename;
	}


	public String getException() {
		return exception;
	}


	public void setException(String exception) {
		this.exception = exception;
	}

	private String filename;
	private String exception;
	
	/**
	 * Creates an instance with successfully added tree.
	 * @param tree the tree
	 */
	public FileTransferOutcome(String fileName) {
		this.filename=fileName;
	}
	
	
	/**
	 * 
	 * @return <code>true</code> if the outcome indicates success, <code>false</code> otherwise
	 */
	public boolean isSuccess() {
		return exception.compareTo(Outcome.N_A.name()) == 0;
	}

	/**
	 * 
	 * @return <code>true</code> if the outcome indicates a failure, <code>false</code> otherwise
	 */
	public boolean isFailure() {
		return !(isSuccess());
	}
	
	/**
	 * Returns the successfully transfer a file.
	 * @return the tree, or <code>null</code> if the outcome indicates a failure
	 */
	public String fileName() {
		return filename;
	}
	
	/**
	 * Returns the exception raised when unsuccessfully transfer a file.
	 * @return the exception, or <code>null</code> if the outcome indicates a success
	 */
	public String failure() {
		return exception;
	}
	
	@Override
	public String toString() {
		return isSuccess() ? fileName() : failure();
	}

}
