package org.gcube.datatransfer.agent.impl.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;

import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.impl.utils.Constants.TransferStatus;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

/**
 * 
 * 
 * @author andrea
 *
 */
public class StorageManagerAsyncHandler extends TransferHandler{

	GCUBELog logger = new GCUBELog (this.getClass());
	IClient client = null;

	
	public StorageManagerAsyncHandler (FileObject inputFile, int timeout,
			String outPath,String transferId, TransferType type,IClient client, DestData data){
		this.inputFile = inputFile;
		this.timeout = timeout;
		this.outPath = outPath;
		this.transferId = transferId;
		this.transferType = type;
		this.destData = data;
		this.client = client;

	}


	@Override
	public void run() {


		long startTime = 0;
		File tmpFile = null;
		
		try {
			URLConnection connection = inputFile.getURL().openConnection();
			connection.setConnectTimeout(timeout);
			InputStream streamIn = connection.getInputStream();

			try {
				tmpFile = File.createTempFile("data-transfer", ".tmp");
			} catch (IOException e1) {
				e1.printStackTrace();
				throw e1;
			}

			FileOutputStream streamOut;
			try {
				streamOut = new FileOutputStream(tmpFile);
			} catch (FileNotFoundException e1) {
				e1.printStackTrace();
				throw e1;
			}


			//getting outfile info	
			String outputFile = inputFile.getName().getBaseName();
			String absoluteOutputFile = outPath+File.separator+outputFile;


			transferObj =TransferUtils.createTransferObjectJDO(transferId,transferType);
			transferObj.setSourceURI(inputFile.getURL().toString());

			startTime= System.currentTimeMillis();

			IOUtils.copy(streamIn, streamOut);
			streamIn.close();
			streamOut.close();
			
			client.put(true).LFile(tmpFile.getAbsolutePath()).RFile(absoluteOutputFile);	
			String outURL = client.getUrl().RFile(absoluteOutputFile);
			
			transferObj.setDestURI(outURL);
			transferObj.setSize(tmpFile.getTotalSpace());
			transferObj.setStatus(TransferStatus.DONE.name());
			
			transferObj.setOutcome("File succesfully copied to "+ outURL);
			
			logger.debug("File succesfully copied to "+ outURL);

		}catch (Exception e){
			transferObj.setStatus(TransferStatus.FAILED.name());
			transferObj.setOutcome(e.getMessage());
			e.printStackTrace();
		}
		finally {
			long endTime = System.currentTimeMillis();
			transferObj.setTransferTime(endTime - startTime);
			tmpFile.delete();
			
		}
	}

}


