package org.gcube.datatransfer.agent.impl.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;


import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.jdo.Transfer;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.Constants.TransferStatus;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;

public class TransferUtils {
	
	static GCUBELog logger = new GCUBELog(TransferUtils.class);
	
	final static int BUFFER = 2048;
	/** The UUIDGen */
	protected static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();

	
	public static Transfer createTransferJDO(String transferId){
		Transfer t = new Transfer();
		t.setId(transferId);
		t.setStatus(TransferStatus.STARTED.name());
		t.setSubmitter("N/A");
		return t;
	}
	
	public static TransferObject createTransferObjectJDO(String transferId,TransferType type){
		TransferObject t = new TransferObject();
		t.setId(uuidgen.nextUUID());
		t.setTransferType(type);
		t.setStatus(TransferStatus.STARTED.name());
		t.setTransferID(transferId);		
		return t;
	}

	public static void unzipArchive(String baseFolder,String archiveFile) throws Exception{
	    BufferedOutputStream dest = null;
        FileInputStream fis = new FileInputStream(archiveFile);
        
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
        ZipEntry entry;
        while((entry = zis.getNextEntry()) != null) {
           
           int count;
           byte data[] = new byte[BUFFER];
           // write the files to the disk
           String outFile = baseFolder + File.separator+ entry.getName();
           FileOutputStream fos = new FileOutputStream(outFile);
           logger.debug("Uncompressing file "+outFile );
           dest = new 
             BufferedOutputStream(fos, BUFFER);
           while ((count = zis.read(data, 0, BUFFER)) 
             != -1) {
              dest.write(data, 0, count);
           }
           dest.flush();
           dest.close();
        }
        zis.close();	
	}
	
	public static String getMimeType(String fileUrl)
		      throws java.io.IOException
		    {
		      FileNameMap fileNameMap = URLConnection.getFileNameMap();
		      String type = fileNameMap.getContentTypeFor(fileUrl);

		      return type;
		    }

	
}
