/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.agent.impl.context.AgentContext;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.state.AgentResource;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.impl.worker.ASyncWorker;
import org.gcube.datatransfer.agent.impl.worker.Worker;
import org.gcube.datatransfer.agent.impl.worker.async.DataStorageASyncWorker;
import org.gcube.datatransfer.agent.impl.worker.async.LocalFileTransferASyncWorker;
import org.gcube.datatransfer.agent.impl.worker.async.StorageManagerASyncWorker;
import org.gcube.datatransfer.agent.impl.worker.async.TreeManagerAsyncWorker;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.GetTransferOutcomesFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.MonitorTransferFault;
import org.gcube.datatransfer.agent.stubs.datatransferagent.PostProcessType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.SourceData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageAccessType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageManagerDetails;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferOptions;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;
import org.gcube.datatransfer.common.utils.Utils;

public class AgentFunctions {
    protected final GCUBELog logger = new GCUBELog(this.getClass());

    public AgentResource getResource() throws Exception {
        return AgentContext.getContext().getAgent();
    }

    public FutureTask<Worker> startAsyncTask(String id, SourceData source, DestData dest) {
        try {
            this.logger.debug((Object)"startAsyncTask has been reached ... ");
            ASyncWorker worker = null;
            FutureTask<Worker> task = null;
            if (source.getType().getValue().compareTo(TransferType.TreeBasedTransfer.getValue()) == 0) {
                worker = new TreeManagerAsyncWorker(id, source, dest);
            } else if (source.getType().getValue().compareTo(TransferType.FileBasedTransfer.getValue()) == 0) {
                worker = dest.getOutUri().getOptions().getStorageType().getValue().compareTo(StorageType.StorageManager.getValue()) == 0 ? new StorageManagerASyncWorker(id, source, dest) : (dest.getOutUri().getOptions().getStorageType().getValue().compareTo(StorageType.DataStorage.getValue()) == 0 ? new DataStorageASyncWorker(id, source, dest) : new LocalFileTransferASyncWorker(id, source, dest));
            }
            task = new FutureTask<Worker>(worker);
            worker.setTask(task);
            Thread t = new Thread(task);
            t.start();
            ServiceContext.getContext().getDbManager().storeTransfer(TransferUtils.createTransferJDO(id));
            AgentResource.FutureWorker futureWorker = new AgentResource.FutureWorker();
            futureWorker.setFutureTask(task);
            futureWorker.setWorker(worker);
            this.getResource().getWorkerMap().put(id, futureWorker);
            return task;
        }
        catch (Exception e) {
            this.logger.error((Object)"startAsyncTask - Exception");
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<FileTransferOutcome> getTransferOutcomes(String transferId) throws GetTransferOutcomesFault {
        if (transferId == null) {
            throw (GetTransferOutcomesFault)Utils.newFault((GCUBEFault)new GetTransferOutcomesFault(), (Throwable)new Exception("The Transfer ID is null"));
        }
        ArrayList<FileTransferOutcome> outcomes = null;
        try {
            outcomes = ServiceContext.getContext().getDbManager().getTransferObjectOutCome(transferId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (GetTransferOutcomesFault)Utils.newFault((GCUBEFault)new GetTransferOutcomesFault(), (Throwable)e);
        }
        return outcomes;
    }

    public Types.MonitorTransferReportMessage monitorTransferWithProgress(String transferId) throws MonitorTransferFault {
        if (transferId == null) {
            throw (MonitorTransferFault)Utils.newFault((GCUBEFault)new MonitorTransferFault(), (Throwable)new Exception("The Transfer ID is null"));
        }
        Types.MonitorTransferReportMessage message = null;
        try {
            message = ServiceContext.getContext().getDbManager().getTrasferProgressType(transferId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (MonitorTransferFault)Utils.newFault((GCUBEFault)new MonitorTransferFault(), (Throwable)e);
        }
        return message;
    }

    public static PostProcessType[] getPostProcessArray(List<Types.postProcessType> list) {
        if (list == null) {
            return null;
        }
        PostProcessType[] array = new PostProcessType[list.size()];
        int i = 0;
        for (Types.postProcessType type : list) {
            if (type.equals((Object)Types.postProcessType.FileConversion)) {
                array[i] = PostProcessType.FileConversion;
                ++i;
                continue;
            }
            if (type.equals((Object)Types.postProcessType.FileUnzip)) {
                array[i] = PostProcessType.FileUnzip;
                ++i;
                continue;
            }
            if (!type.equals((Object)Types.postProcessType.OriginalFileRemove)) continue;
            array[i] = PostProcessType.OriginalFileRemove;
            ++i;
        }
        return array;
    }

    public static TransferOptions getMappedTransferOptions(Types.TransferOptions optionsFromMessage) {
        TransferOptions options = new TransferOptions();
        StorageManagerDetails storageManagerDetails = new StorageManagerDetails();
        if (optionsFromMessage.getStorageManagerDetails() != null) {
            storageManagerDetails.setOwner(optionsFromMessage.getStorageManagerDetails().getOwner());
            storageManagerDetails.setServiceClass(optionsFromMessage.getStorageManagerDetails().getServiceClass());
            storageManagerDetails.setServiceName(optionsFromMessage.getStorageManagerDetails().getServiceName());
            StorageAccessType accessType = null;
            if (optionsFromMessage.getStorageManagerDetails().getAccessType() != null) {
                if (optionsFromMessage.getStorageManagerDetails().getAccessType().equals((Object)Types.storageAccessType.PRIVATE)) {
                    accessType = StorageAccessType.PRIVATE;
                } else if (optionsFromMessage.getStorageManagerDetails().getAccessType().equals((Object)Types.storageAccessType.SHARED)) {
                    accessType = StorageAccessType.SHARED;
                } else if (optionsFromMessage.getStorageManagerDetails().getAccessType().equals((Object)Types.storageAccessType.PUBLIC)) {
                    accessType = StorageAccessType.PUBLIC;
                }
            }
            storageManagerDetails.setAccessType(accessType);
        }
        options.setStorageManagerDetails(storageManagerDetails);
        if (optionsFromMessage.getStorageType() != null) {
            StorageType type = null;
            if (optionsFromMessage.getStorageType().equals((Object)Types.storageType.LocalGHN)) {
                type = StorageType.LocalGHN;
            } else if (optionsFromMessage.getStorageType().equals((Object)Types.storageType.DataStorage)) {
                type = StorageType.DataStorage;
            } else if (optionsFromMessage.getStorageType().equals((Object)Types.storageType.StorageManager)) {
                type = StorageType.StorageManager;
            }
            options.setStorageType(type);
        }
        options.setTransferTimeout(3600000L);
        options.setOverwrite(optionsFromMessage.isOverwrite());
        options.setPostProcess(AgentFunctions.getPostProcessArray(optionsFromMessage.getPostProcess()));
        if (optionsFromMessage.getConversionType() != null) {
            options.setConversionType(optionsFromMessage.getConversionType().toString());
        }
        return options;
    }
}

