/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.model.plugins.thredds;

import java.beans.ConstructorProperties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.transfer.model.plugins.thredds.DataSet;
import org.gcube.data.transfer.model.plugins.thredds.DataSetScan;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsCatalog;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThreddsInfo {
    private String hostname;
    private String localBasePath;
    private String instanceBaseUrl;
    private ThreddsCatalog catalog;
    private String adminUser;
    private String adminPassword;
    private int version;
    private int minor;
    private int build;
    private int revision;
    private String ghnId;

    public ThreddsCatalog getById(String id) {
        return ThreddsInfo.findById(this.catalog, id);
    }

    public ThreddsCatalog getCatalogByFittingLocation(String toMatchLocation) {
        return ThreddsInfo.getByFittingLocation(this.catalog, toMatchLocation);
    }

    public DataSet getDataSetFromLocation(String location) {
        try {
            return this.getCatalogByFittingLocation(location).getDataSetFromLocation(location);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static ThreddsCatalog findById(ThreddsCatalog catalog, String id) {
        if (catalog != null) {
            if (catalog.getID() != null && catalog.getID().equals(id)) {
                return catalog;
            }
            if (catalog.getSubCatalogs() != null && catalog.getSubCatalogs().getLinkedCatalogs() != null) {
                for (ThreddsCatalog cat : catalog.getSubCatalogs().getLinkedCatalogs()) {
                    ThreddsCatalog found = ThreddsInfo.findById(cat, id);
                    if (found == null) continue;
                    return found;
                }
            }
        }
        return null;
    }

    public static ThreddsCatalog getByFittingLocation(ThreddsCatalog catalog, String toMatchPath) {
        if (catalog != null) {
            for (DataSetScan scan : catalog.getDeclaredDataSetScan()) {
                if (scan == null || scan.getLocation() == null || !ThreddsInfo.matchesPath(scan.getLocation(), toMatchPath)) continue;
                return catalog;
            }
            if (catalog.getSubCatalogs() != null && catalog.getSubCatalogs().getLinkedCatalogs() != null) {
                for (ThreddsCatalog cat : catalog.getSubCatalogs().getLinkedCatalogs()) {
                    ThreddsCatalog found = ThreddsInfo.getByFittingLocation(cat, toMatchPath);
                    if (found == null) continue;
                    return found;
                }
            }
        }
        return null;
    }

    public static boolean matchesPath(String catalogPath, String toMatchPath) {
        if (toMatchPath.endsWith("/")) {
            return toMatchPath.startsWith(catalogPath);
        }
        return (toMatchPath + "/").startsWith(catalogPath);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getLocalBasePath() {
        return this.localBasePath;
    }

    public String getInstanceBaseUrl() {
        return this.instanceBaseUrl;
    }

    public ThreddsCatalog getCatalog() {
        return this.catalog;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public int getVersion() {
        return this.version;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuild() {
        return this.build;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getGhnId() {
        return this.ghnId;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setLocalBasePath(String localBasePath) {
        this.localBasePath = localBasePath;
    }

    public void setInstanceBaseUrl(String instanceBaseUrl) {
        this.instanceBaseUrl = instanceBaseUrl;
    }

    public void setCatalog(ThreddsCatalog catalog) {
        this.catalog = catalog;
    }

    public void setAdminUser(String adminUser) {
        this.adminUser = adminUser;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public void setBuild(int build) {
        this.build = build;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setGhnId(String ghnId) {
        this.ghnId = ghnId;
    }

    public String toString() {
        return "ThreddsInfo(hostname=" + this.getHostname() + ", localBasePath=" + this.getLocalBasePath() + ", instanceBaseUrl=" + this.getInstanceBaseUrl() + ", catalog=" + this.getCatalog() + ", adminUser=" + this.getAdminUser() + ", adminPassword=" + this.getAdminPassword() + ", version=" + this.getVersion() + ", minor=" + this.getMinor() + ", build=" + this.getBuild() + ", revision=" + this.getRevision() + ", ghnId=" + this.getGhnId() + ")";
    }

    public ThreddsInfo() {
    }

    @ConstructorProperties(value={"hostname", "localBasePath", "instanceBaseUrl", "catalog", "adminUser", "adminPassword", "version", "minor", "build", "revision", "ghnId"})
    public ThreddsInfo(String hostname, String localBasePath, String instanceBaseUrl, ThreddsCatalog catalog, String adminUser, String adminPassword, int version, int minor, int build, int revision, String ghnId) {
        this.hostname = hostname;
        this.localBasePath = localBasePath;
        this.instanceBaseUrl = instanceBaseUrl;
        this.catalog = catalog;
        this.adminUser = adminUser;
        this.adminPassword = adminPassword;
        this.version = version;
        this.minor = minor;
        this.build = build;
        this.revision = revision;
        this.ghnId = ghnId;
    }
}

