/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.data.transfer.model.ExecutionReport;
import org.gcube.data.transfer.model.PluginDescription;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.AbstractPlugin;
import org.gcube.data.transfer.plugin.AbstractPluginFactory;
import org.gcube.data.transfer.plugin.fails.PluginException;
import org.gcube.data.transfer.plugin.fails.PluginExecutionException;
import org.gcube.data.transfer.plugin.model.DataTransferContext;
import org.gcube.data.transfer.service.transfers.engine.PluginManager;
import org.gcube.data.transfer.service.transfers.engine.faults.PluginNotFoundException;
import org.gcube.data.transfer.service.transfers.engine.impl.PluginManagerImpl;
import org.gcube.data.transfer.service.transfers.engine.impl.TokenUtils;
import org.gcube.smartgears.ContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PluginManagerImpl
implements PluginManager {
    private static final Logger log = LoggerFactory.getLogger(PluginManagerImpl.class);
    private static final Object $LOCK = new Object[0];
    private static ServiceLoader<AbstractPluginFactory> abstractFactoryLoader = null;
    private static Map<String, PluginDescription> installedPlugins = null;
    private static PluginManagerImpl instance = null;

    public static synchronized PluginManagerImpl get() {
        if (instance == null) {
            instance = new PluginManagerImpl();
        }
        return instance;
    }

    public PluginManagerImpl() {
        PluginManagerImpl.load();
    }

    public Map<String, PluginDescription> getInstalledPlugins() {
        return installedPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, PluginDescription> load() {
        Object object = $LOCK;
        synchronized (object) {
            if (installedPlugins == null) {
                HashMap<String, PluginDescription> toSet = new HashMap<String, PluginDescription>();
                log.trace("Loading plugins descriptors..");
                abstractFactoryLoader = ServiceLoader.load(AbstractPluginFactory.class);
                for (AbstractPluginFactory factory : abstractFactoryLoader) {
                    toSet.put(factory.getID(), new PluginDescription(factory.getID(), factory.getDescription(), factory.getParameters()));
                }
                installedPlugins = toSet;
            }
            return installedPlugins;
        }
    }

    public void initPlugins() {
        for (AbstractPluginFactory factory : abstractFactoryLoader) {
            log.debug("Initializing {}, under {} ", (Object)factory.getID(), (Object)TokenUtils.getCurrentScope());
            try {
                factory.init(new DataTransferContext(ContextProvider.get()));
            }
            catch (Throwable e) {
                log.warn("Unable to initialize plugin {} ", (Object)factory.getID(), (Object)e);
            }
        }
    }

    public ExecutionReport execute(PluginInvocation invocation, String transferredFile) throws PluginException, PluginNotFoundException {
        log.debug("Executing invocation {} ", (Object)invocation);
        if (!this.getInstalledPlugins().containsKey(invocation.getPluginId())) {
            throw new PluginNotFoundException("Plugin with ID " + invocation.getPluginId() + " is not available.");
        }
        AbstractPluginFactory factory = this.getFactory(invocation.getPluginId());
        log.debug("Loaded factory {} ", factory.getClass());
        AbstractPlugin plugin = null;
        try {
            log.debug("Checking invocation {} ", (Object)invocation);
            PluginInvocation modifiedInvocation = factory.checkInvocation(invocation, transferredFile);
            plugin = factory.createWorker(modifiedInvocation);
            ExecutionReport report = plugin.execute();
            log.debug("Plugin execution report is {} ", (Object)report);
            switch (1.$SwitchMap$org$gcube$data$transfer$model$ExecutionReport$ExecutionReportFlag[report.getFlag().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    throw new PluginException("Wrong status after plugin execution. Report is " + report);
                }
                case 4: {
                    log.warn("Plugin failed to clean up. ");
                }
            }
            return report;
        }
        catch (PluginException e) {
            log.error("Unable to execute plguin invocation {} ", (Object)invocation, (Object)e);
            throw e;
        }
    }

    private AbstractPluginFactory getFactory(String pluginId) throws PluginNotFoundException {
        log.debug("Getting factory by ID {} ", (Object)pluginId);
        for (AbstractPluginFactory factory : abstractFactoryLoader) {
            if (!factory.getID().equals(pluginId)) continue;
            return factory;
        }
        throw new PluginNotFoundException("Plugin with ID " + pluginId + " not found");
    }

    public void shutdown() {
        log.trace("Shutting down plugins..");
        for (PluginDescription desc : this.getInstalledPlugins().values()) {
            try {
                AbstractPluginFactory factory = this.getFactory(desc.getId());
                log.debug("Shutting down {} ", (Object)desc.getId());
                factory.shutDown();
            }
            catch (Throwable e) {
                log.warn("Unexpected error while shutting down {} ", (Object)desc.getId(), (Object)e);
            }
        }
        installedPlugins = null;
    }

    public Object getPluginInfo(String pluginID) throws PluginNotFoundException, PluginExecutionException {
        Object toReturn = this.getFactory(pluginID).getInfo();
        log.trace("Serving plugin {} info {} ", (Object)pluginID, toReturn);
        return toReturn;
    }
}

