/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers.engine.impl;

import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.model.options.TransferOptions;
import org.gcube.data.transfer.service.transfers.engine.AccountingManager;
import org.gcube.data.transfer.service.transfers.engine.PersistenceProvider;
import org.gcube.data.transfer.service.transfers.engine.PluginManager;
import org.gcube.data.transfer.service.transfers.engine.RequestManager;
import org.gcube.data.transfer.service.transfers.engine.TicketManager;
import org.gcube.data.transfer.service.transfers.engine.impl.AccountingManagerImpl;
import org.gcube.data.transfer.service.transfers.engine.impl.LocalRequestHandler;
import org.gcube.data.transfer.service.transfers.engine.impl.RequestHandler;
import org.gcube.smartgears.ContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RequestManagerImpl
implements RequestManager {
    private static final Logger log = LoggerFactory.getLogger(RequestManagerImpl.class);
    ExecutorService executor;
    TicketManager ticketManager;
    PersistenceProvider persistenceProvider;
    PluginManager pluginManager;
    AccountingManager accounting;

    @Inject
    public RequestManagerImpl(TicketManager ticketManager, PersistenceProvider persistenceProvider) {
        log.info("Checking pool configuration..");
        int coreSize = 5;
        int maximumSize = 10;
        long maximumIdleTime = 60000L;
        try {
            Properties props = new Properties();
            props.load(ContextProvider.get().application().getResourceAsStream("config.properties"));
            coreSize = Integer.parseInt(props.getProperty("transfers.poolCoreSize"));
            maximumSize = Integer.parseInt(props.getProperty("transfers.poolMaximumSize"));
            maximumIdleTime = Long.parseLong(props.getProperty("transfers.threadMaxIdleTimeMs"));
        }
        catch (Throwable t) {
            log.warn("****************************************************************************");
            log.warn("Unable to read configuration, reverting to default pool values ");
            log.warn("Core size {} , maximum size {} , maximum idle time {}", new Object[]{coreSize, maximumSize, maximumIdleTime});
            log.warn("Error was ", t);
        }
        this.executor = new ThreadPoolExecutor(coreSize, maximumSize, maximumIdleTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.persistenceProvider = persistenceProvider;
        this.pluginManager = PluginManager.get();
        this.ticketManager = ticketManager;
        this.accounting = AccountingManagerImpl.get();
    }

    public TransferTicket put(TransferRequest request) {
        request.setId(UUID.randomUUID().toString());
        log.info("Managing request {} ", (Object)request);
        TransferTicket toReturn = new TransferTicket(request);
        String accountingId = this.accounting.createNewRecord();
        if (request.getSettings().getOptions().getMethod().equals((Object)TransferOptions.TransferMethod.FileUpload)) {
            log.debug("Request is sync");
            return new LocalRequestHandler(this.persistenceProvider, this.pluginManager, toReturn, accountingId).handle();
        }
        log.debug("Request is async");
        this.executor.execute((Runnable)new RequestHandler(this.ticketManager, new TransferTicket(request), this.persistenceProvider, this.pluginManager, accountingId));
        return toReturn;
    }

    public void shutdown() {
        log.debug("Calling shutdown..");
        this.executor.shutdownNow();
        long timeout = 4L;
        TimeUnit unit = TimeUnit.SECONDS;
        log.debug("Waiting termination.. {} {} ", (Object)timeout, (Object)unit);
        boolean halted = false;
        try {
            halted = this.executor.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            log.debug("Halted threads : {} ", (Object)halted);
        }
    }
}

