package org.gcube.datatransfer.scheduler.is;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.jdo.Extent;

import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;



public class ISManager <T> {
	/** The UUIDGen */
	private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
	public T t;
	public DataTransferDBManager dbManager;
	public String scope;

	public ISManager(DataTransferDBManager dbManager, String scope) {
		this.dbManager=dbManager;		
		this.scope = scope;
		this.t= (T) new Object();
	}


	/*
	 * updateObjsInDB
	 * input: Nothing
	 * return: Nothing
	 * used by CheckIS Thread 
	 */
	public void updateObjsInDB(){

		List<String> resultsFromIS;
		int newContentInDB=0;
		int oldContentInDB=0;
		String typeOfISManager = null;
		//System.out.println("\nISManager.updateObjsInDB - ..");

		//1.
		//retrieving the objects (either Agents or Sources or Storages) 
		//from the IS and we check if there's something new

		resultsFromIS = this.getObjsFromIS();

		String delimiter="--";

		for(String tmpResult : resultsFromIS){	
			String[] tmpSplitResult;
			tmpSplitResult=tmpResult.split(delimiter);

			String ServiceName=tmpSplitResult[0]; // for now - it's not being stored
			String resultIdOfIS = tmpSplitResult[1];
			String host=tmpSplitResult[2];
			String port=tmpSplitResult[3];

			if(this.checkIfObjExistsInDB_ById(resultIdOfIS)!=null){ //this one already exists in DB but is its status up?.. 
				String idOfObjInDB = this.checkIfObjExistsInDB_ById(resultIdOfIS);
				//we just check for the stored status in DB and if its down we'll change it.. 
				String statusOfObj = null;
				if(t.getClass().isInstance(Agent.class)){
					statusOfObj = this.dbManager.getPersistenceManager().getObjectById(Agent.class, idOfObjInDB).getStatus();
					typeOfISManager="for Agents";
				}
				else if(t.getClass().isInstance(DataSource.class)){
					statusOfObj = this.dbManager.getPersistenceManager().getObjectById(DataSource.class, idOfObjInDB).getStatus();
					typeOfISManager="for DataSources";
				}
				else if(t.getClass().isInstance(DataStorage.class)){
					statusOfObj = this.dbManager.getPersistenceManager().getObjectById(DataStorage.class, idOfObjInDB).getStatus();
					typeOfISManager="for DataStorages";
				}
				else System.out.println("ISManager - updateObjsInDB - Error - there is no class with this name");


				if(statusOfObj.compareTo("DOWN")==0){
					newContentInDB++;						
					try {
						if(t.getClass().isInstance(Agent.class)){
							this.dbManager.updateAgentStatus(idOfObjInDB, "UP");
						}
						else if(t.getClass().isInstance(DataSource.class)){
							this.dbManager.updateSourceStatus(idOfObjInDB, "UP");						
						}
						else if(t.getClass().isInstance(DataStorage.class)){
							this.dbManager.updateStorageStatus(idOfObjInDB, "UP");						
						}
						else System.out.println("ISManager - updateObjsInDB - Error - there is no class with this name");
					} catch (Exception e) {
						System.out.println("ISManager - updateObjsInDB - Exception in updating the status");
						e.printStackTrace();
					}
				}
			}
			else{
				//in other case we store it in DB because it seems to be a new one
				newContentInDB++;
				String idOfObjInDB = this.setObjToDB(resultIdOfIS,host,port);
				if(idOfObjInDB==null)System.out.println("ISManager - updateObjsInDB - Error in storing the new obj in DB");
			}				
		}

		//2.
		//retrieving all the nodes (either agents-sources or storages) from the DB and we check if someone does not exist anymore		
		try{
			Extent<?> resultExtent = null;
			if(t.getClass().isInstance(Agent.class)){
				resultExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
			}
			else if(t.getClass().isInstance(DataSource.class)){
				resultExtent = this.dbManager.getPersistenceManager().getExtent(DataSource.class, true);
			}
			else if(t.getClass().isInstance(DataStorage.class)){
				resultExtent = this.dbManager.getPersistenceManager().getExtent(DataStorage.class, true);
			}
			else System.out.println("ISManager - updateObjsInDB - Error - there is no class with this name");

			Iterator<?> iter = resultExtent.iterator();
			String idOfObj = null;
			String idOfObjOfIS = null;

			while (iter.hasNext()){
				Object obj=iter.next();

				if(t.getClass().isInstance(Agent.class)){
					//System.out.println("ISManager - updateObjsInDB - status="+((Agent)obj).getStatus());
					String resultStatus = ((Agent)obj).getStatus();
					if(resultStatus.compareTo("DOWN")==0) continue;

					idOfObj = ((Agent)obj).getAgentId();
					idOfObjOfIS = ((Agent)obj).getAgentIdOfIS();
				}
				else if(t.getClass().isInstance(DataSource.class)){
					//System.out.println("ISManager - updateObjsInDB - status="+((DataSource)obj).getStatus());
					String resultStatus = ((DataSource)obj).getStatus();
					if(resultStatus.compareTo("DOWN")==0) continue;

					idOfObj = ((DataSource)obj).getDataSourceId();
					idOfObjOfIS = ((DataSource)obj).getDataSourceIdOfIS();
				}
				else if(t.getClass().isInstance(DataStorage.class)){
					//System.out.println("ISManager - updateObjsInDB - status="+((DataStorage)obj).getStatus());
					String resultStatus = ((DataStorage)obj).getStatus();
					if(resultStatus.compareTo("DOWN")==0) continue;

					idOfObj = ((DataStorage)obj).getDataStorageId();
					idOfObjOfIS = ((DataStorage)obj).getDataStorageIdOfIS();
				}
				else System.out.println("ISManager - updateObjsInDB - Error - there is no class with this name");


				if(this.checkIfObjExistsInIS_ById(idOfObjOfIS)){
					//it is UP and it exists in IS so we proceed ..
					continue;
				}
				else{
					//it is UP but it does not exist anymore so we change its status ..
					oldContentInDB++;
					try {	
						if (t.getClass().isInstance(Agent.class)){
							this.dbManager.updateAgentStatus(idOfObj, "DOWN");
						}
						else if (t.getClass().isInstance(DataSource.class)){
							this.dbManager.updateSourceStatus(idOfObj, "DOWN");
						}
						else if (t.getClass().isInstance(DataStorage.class)){
							this.dbManager.updateStorageStatus(idOfObj, "DOWN");
						}
						else System.out.println("ISManager - updateObjsInDB - Error - there is no class:"+t.getClass().getName());

					} catch (Exception e) {
						System.out.println("ISManager - updateObjsInDB - Exception in updating the status");
						e.printStackTrace();
					}
					//this.dbManager.deleteAgent(this.dbManager.getPersistenceManager().getObjectById(Agent.class, tmpAgentId));
				}		
			}
		}catch(Exception e){
			e.printStackTrace();
		}		
		System.out.println("ISManager.updateObjsInDB ("+typeOfISManager+") - new UP-Nodes For Storing in DB="+newContentInDB+" - new DOWN-Nodes For Changing Their Status="+oldContentInDB);
	}	


	/*
	 * getObjsFromIS
	 * input: Nothing
	 * return: List<String> of Objects (either Agents or Sources or Storages) 
	 * for storing them in the DB
	 */
	public List<String> getObjsFromIS(){

		String tmpAgent;
		List<String> agentsFromIS=new ArrayList<String>();

		if (t.getClass().isInstance(Agent.class)){
			try{
				ISClient client = GHNContext.getImplementation(ISClient.class);
				GCUBERIQuery RIquery = client.getQuery(GCUBERIQuery.class);
				RIquery.addAtomicConditions(new AtomicCondition("//ServiceName","agent-service"));
				//System.out.println("ISManager.getObjsFromIS - Printing all the received agents from IS");
				for (GCUBERunningInstance instance : client.execute(RIquery,GCUBEScope.getScope(this.scope))){
					tmpAgent=new String();
					tmpAgent=instance.getServiceName()+"--"+instance.getID()+
							"--"+instance.getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent").getAddress().getHost()+
							"--"+instance.getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent").getAddress().getPort()+
							"--" ;

					//System.out.println("      tmpAgent="+tmpAgent);
					agentsFromIS.add(tmpAgent);
				}
			}catch(RuntimeException e){
				System.out.println("ISManager.getAgentsFromIS - RuntimeException....");
				e.printStackTrace();

			}catch(Exception e){
				System.out.println("ISManager.getAgentsFromIS - exception....");
				e.printStackTrace();
			}
			return agentsFromIS;
		}
		else if(t.getClass().isInstance(DataSource.class)){
			return null;
		}
		else if(t.getClass().isInstance(DataStorage.class)){
			return null;
		}

		return null;
	}

	/*
	 * checkIfObjExistsInIS_ById
	 * input: String with the objId of IS
	 * return: boolean - if exists in IS returns true, in other case false
	 */
	public boolean checkIfObjExistsInIS_ById(String id){

		if (t.getClass().isInstance(Agent.class)){
			try{
				ISClient client = GHNContext.getImplementation(ISClient.class);
				GCUBERIQuery RIquery = client.getQuery(GCUBERIQuery.class);
				RIquery.addAtomicConditions(new AtomicCondition("//ServiceName","agent-service"));
				for (GCUBERunningInstance instance : client.execute(RIquery,GCUBEScope.getScope(this.scope))){
					String instanceId=instance.getID();
					if(instanceId.compareTo(id)==0){
						return true;
					}
				}
			}catch(Exception e){
				System.out.println("ISManager.checkIfObjExistsInIS_ById - exception");
				e.printStackTrace();
			}
			return false;
		}	
		else if(t.getClass().isInstance(DataSource.class)){
			return false;
		}
		else if(t.getClass().isInstance(DataStorage.class)){
			return false;
		}
		return false;
	}

	/*
	 * checkIfObjExistsInDB_ById
	 * input: String with the objId of IS
	 * return: String - if exists in DB returns the objId of DB, in other case null
	 */
	public String checkIfObjExistsInDB_ById(String id){	

		if (t.getClass().isInstance(Agent.class)){
			try{
				Extent<?> agentExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
				Iterator<?> iter = agentExtent.iterator();

				while (iter.hasNext()){
					Object obj=iter.next();
					String tmpId = ((Agent)obj).getAgentIdOfIS();
					if(tmpId.compareTo(id)==0){
						return ((Agent)obj).getAgentId();
					}
				}
			}catch(Exception e){
				System.out.println("ISManager.checkIfObjExistsInDB_ById - exception");
				e.printStackTrace();
			}		
			return null;
		}	
		else if(t.getClass().isInstance(DataSource.class)){
			return null;
		}
		else if(t.getClass().isInstance(DataStorage.class)){
			return null;
		}
		return null;
	}


	/*
	 * setObjToDB
	 * input: String with the objId of IS
	 * input: String with the host of obj
	 * input: String with the port of obj
	 * return: String with the objId of DB, in other case null
	 */
	public String setObjToDB(String objIdOfIS, String host, String port){

		if (t.getClass().isInstance(Agent.class)){
			Agent agentDB=new Agent();
			String agentId = uuidgen.nextUUID();
			agentDB.setAgentId(agentId);
			agentDB.setAgentIdOfIS(objIdOfIS);
			agentDB.setHost(host);
			agentDB.setPort(Integer.valueOf(port));
			agentDB.setStatus("UP");				//there is a need for setting UP the status in the first time
			try {// *** store the Agent in DB ***
				this.dbManager.storeAgent(agentDB);
			} catch (Exception e) {
				System.out.println("ISManager.setObjToDB - Exception in storing the Agent");
				e.printStackTrace();
				return null;
			}
			return agentId;
		}
		else if (t.getClass().isInstance(DataSource.class)){
			DataSource sourceDB = new DataSource();
			return null;
		}
		else if (t.getClass().isInstance(DataStorage.class)){
			DataStorage storageDB = new DataStorage();
			return null;
		}
		return null;		

	}


	/*
	 * checkIfObjExistsInIS_ByHostname
	 * input: String with the host of the Object (either Agent or Source or Storage)
	 * return: String - if exists in IS returns the objId of IS, in other case null
	 */
	public String checkIfObjExistsInIS_ByHostname(String host){

		if (t.getClass().isInstance(Agent.class)){
			//System.out.println("ISManager.checkIfObjExistsInIS_ByHostname - Its an agent");

			try{
				ISClient client = GHNContext.getImplementation(ISClient.class);
				GCUBERIQuery RIquery = client.getQuery(GCUBERIQuery.class);
				RIquery.addAtomicConditions(new AtomicCondition("//ServiceName","agent-service"));
				for (GCUBERunningInstance instance : client.execute(RIquery,GCUBEScope.getScope(this.scope))){
					//System.out.println("ISManager.checkIfObjExistsInIS_ByHostname - host="+instance.getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent").getAddress().getHost()+" - diko mas host="+host);
					if(instance.getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent").getAddress().getHost().compareTo(host)==0){
						return instance.getID();
					}
				}
			}catch(Exception e){
				System.out.println("ISManager.checkIfObjExistsInIS_ByHostname - exception");
				e.printStackTrace();
			}
			return null;	
		}
		else if (t.getClass().isInstance(DataSource.class)){
			DataSource sourceDB = new DataSource();
			return null;
		}
		else if (t.getClass().isInstance(DataStorage.class)){
			DataStorage storageDB = new DataStorage();
			return null;
		}
		return null;
	}


}
