/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.library;

import com.thoughtworks.xstream.XStream;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.scheduler.library.fws.SchedulerServiceJAXWSStubs;
import org.gcube.datatransfer.scheduler.library.obj.InfoCancelSchedulerMessage;
import org.gcube.datatransfer.scheduler.library.obj.SchedulerObj;
import org.gcube.datatransfer.scheduler.library.outcome.CallingSchedulerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerLibrary {
    private final AsyncProxyDelegate<SchedulerServiceJAXWSStubs> delegate;
    Logger logger = LoggerFactory.getLogger((String)this.getClass().toString());

    public SchedulerLibrary(ProxyDelegate<SchedulerServiceJAXWSStubs> config) {
        this.delegate = new AsyncProxyDelegate(config);
    }

    public String scheduleTransfer(SchedulerObj schedulerObj) {
        final String msgStr = schedulerObj.toXML();
        Call<SchedulerServiceJAXWSStubs, String> call = new Call<SchedulerServiceJAXWSStubs, String>(){

            public String call(SchedulerServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.storeInfoScheduler(msgStr);
            }
        };
        String transferId = null;
        try {
            transferId = (String)this.delegate.make((Call)call);
        }
        catch (Exception e1) {
            this.logger.error("SchedulerLibrary (scheduleTransfer)- Exception.. Something wrong in the storeInfo(msgStr)");
            e1.printStackTrace();
        }
        if (transferId == null) {
            return null;
        }
        return transferId;
    }

    public CallingSchedulerResult cancelTransfer(String transferId, boolean force) {
        InfoCancelSchedulerMessage infoCancelSchedulerMessage = new InfoCancelSchedulerMessage();
        Types.CancelTransferMessage cancelTransferMessage = new Types.CancelTransferMessage();
        cancelTransferMessage.setForceStop(true);
        cancelTransferMessage.setTransferId(transferId);
        infoCancelSchedulerMessage.setCancelTransferMessage(cancelTransferMessage);
        final String msgStr = infoCancelSchedulerMessage.toXML();
        Call<SchedulerServiceJAXWSStubs, String> call = new Call<SchedulerServiceJAXWSStubs, String>(){

            public String call(SchedulerServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.cancelScheduledTransfer(msgStr);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e1) {
            this.logger.error("SchedulerLibrary (cancelTransfer)- Exception.. Something wrong");
            e1.printStackTrace();
        }
        if (result == null) {
            return null;
        }
        String tmpMsg = result;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        XStream xstream = new XStream();
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        callingSchedulerResult = (CallingSchedulerResult)xstream.fromXML(tmpMsg);
        return callingSchedulerResult;
    }

    public CallingSchedulerResult monitorTransfer(String transferId) {
        final String msgStr = transferId;
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        Call<SchedulerServiceJAXWSStubs, String> call = new Call<SchedulerServiceJAXWSStubs, String>(){

            public String call(SchedulerServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.monitorScheduledTransfer(msgStr);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e1) {
            this.logger.error("SchedulerLibrary (monitorTransfer)- Exception.. Something wrong");
            e1.printStackTrace();
        }
        if (result == null) {
            return null;
        }
        callingSchedulerResult.setMonitorResult(result);
        return callingSchedulerResult;
    }

    public CallingSchedulerResult getOutcomesOfTransfer(String transferId) {
        final String msgStr = transferId;
        Call<SchedulerServiceJAXWSStubs, String> call = new Call<SchedulerServiceJAXWSStubs, String>(){

            public String call(SchedulerServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.getScheduledTransferOutcomes(msgStr);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e1) {
            this.logger.error("SchedulerLibrary (getOutcomesOfTransfer)- Exception.. Something wrong ");
            e1.printStackTrace();
        }
        if (result == null) {
            return null;
        }
        String tmpMsg = result;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        XStream xstream = new XStream();
        CallingSchedulerResult callingSchedulerResult = new CallingSchedulerResult();
        callingSchedulerResult = (CallingSchedulerResult)xstream.fromXML(tmpMsg);
        return callingSchedulerResult;
    }
}

