package org.gcube.datatransfer.scheduler.impl.porttype;

import java.util.ArrayList;
import java.util.List;

import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.is.ISManager;

public class CheckIS extends Thread {
	DataTransferDBManager dbManager=null;
	long checkISIntervalMS=10000;
	ISManager isManager;
	
	public CheckIS(){
		this.dbManager=ServiceContext.getContext().getDbManager();
		this.isManager = new ISManager(this.dbManager);
	}
	
	
	public void run() {
		int runs=0;
		System.out.println("\nCheckIS -- Thread has started");
		do {
			runs++;
			
			//we update the agents in DB
			//more specifically we check if there's a new one in IS in order to store in DB
			// or if it's already exist in DB we change its status to UP .. 
			//Moreover we also check if a stored agent doesn't have UP status in IS anymore so we change their status to DOWN.
			try{
			this.isManager.updateTheAgentsInDB();		
			}catch(Exception e){
				System.out.println("nCheckIS -- Exception in updating the agents");
				e.printStackTrace();
			}
			try {
				Thread.sleep(checkISIntervalMS);
			} catch (InterruptedException e) {
				System.out.println("nCheckIS -- InterruptedException - Unable to sleep - circle of thread="+runs);
				e.printStackTrace();
			}
		
		}while (! Thread.interrupted());
	}
}
