package org.gcube.datatransfer.scheduler.impl.check;

import java.util.Calendar;
import java.util.List;
import javax.jdo.Query;

import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.handler.TransferHandler;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.FrequencyType;





public class CheckDBForTransfers {

	public DataTransferDBManager dbManager=null;
	public SchedulerResource resource=null;
	public long checkForTransfersIntervalMS;
	public List<Transfer> transfers=null;

	public CheckDBForTransfers(GCUBEWSResource ws, List<Transfer> transfers) {
		this.dbManager=ServiceContext.getContext().getDbManager();	
		this.resource=(SchedulerResource) ws;
		this.transfers=transfers;		
	}

	public void check() {
		Calendar calendarTmp;

		for(Transfer obj : this.transfers){

			// ****check for typeOfSchedule ****//
			TypeOfSchedule typeOfSchedule = null;
			String idTypeOfSchedule = null;
			try{
				idTypeOfSchedule=obj.getTypeOfScheduleId();
				typeOfSchedule = this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class,idTypeOfSchedule );
			}catch(Exception e){
				System.out.println("CheckForTransfers -- Exception in retrieving the typeOfSchedule");
				e.printStackTrace();
			}	

			String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();
			String idManuallyScheduled = typeOfSchedule.getManuallyScheduledId();			

			// ## if Direct Transfer - no schedule
			if(typeOfSchedule.isDirectedScheduled()==true){
				System.out.println("\nCheckForTransfers - "+obj.getSubmitter()+" -- A transfer (Direct Transfer) is happening today  - transferId:"+((Transfer)obj).getTransferId()+" -- submitter:"+((Transfer)obj).getSubmitter()+" -- status="+((Transfer)obj).getStatus());
				
				try {	
				this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
				}catch (Exception e) {
				System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - "+((Transfer)obj).getSubmitter() +" - id="+((Transfer)obj).getTransferId());
				e.printStackTrace();
				}
				 
				// **** Transfer Handler ****
				TransferHandler transferHandler = new TransferHandler(obj.getTransferId(),this.resource,false);
				transferHandler.start();
				
				
			}// ## if Manual Transfer - a specific instance
			else if (idManuallyScheduled!=null){
				ManuallyScheduled manuallyScheduled  = this.dbManager.getPersistenceManager().getObjectById(ManuallyScheduled.class, idManuallyScheduled);
				calendarTmp = manuallyScheduled.getCalendar();

				if( (calendarTmp.get(Calendar.YEAR) <= Calendar.getInstance().get(Calendar.YEAR))
						&&(calendarTmp.get(Calendar.MONTH) <= Calendar.getInstance().get(Calendar.MONTH))
						&&(calendarTmp.get(Calendar.DAY_OF_MONTH) <= Calendar.getInstance().get(Calendar.DAY_OF_MONTH))
						&&(calendarTmp.get(Calendar.HOUR_OF_DAY) <= Calendar.getInstance().get(Calendar.HOUR_OF_DAY))
						&&(calendarTmp.get(Calendar.MINUTE) <= Calendar.getInstance().get(Calendar.MINUTE))
						){
					System.out.println("\nCheckForTransfers - "+obj.getSubmitter()+" -- A transfer (Manually Scheduled) is happening today  - transferId:"+((Transfer)obj).getTransferId()+" -- submitter:"+((Transfer)obj).getSubmitter()+" -- status="+((Transfer)obj).getStatus());

					try {	
						this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
					}catch (Exception e) {
						System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - "+((Transfer)obj).getSubmitter() +" - id="+((Transfer)obj).getTransferId());
						e.printStackTrace();
					}

					// **** Transfer Handler ****
					TransferHandler transferHandler = new TransferHandler(obj.getTransferId(),this.resource,false);
					transferHandler.start();
				}
			}// ## if Periodically Transfer - every minute/hour/day/.. etc
			else if(periodicallyScheduledId!=null){
				PeriodicallyScheduled periodicallyScheduled= this.dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class, periodicallyScheduledId );		
				Calendar startInstance=periodicallyScheduled.getStartInstance();

				if( (startInstance.get(Calendar.YEAR)  <= Calendar.getInstance().get(Calendar.YEAR))
						&&(startInstance.get(Calendar.MONTH)  <= Calendar.getInstance().get(Calendar.MONTH))
						&&(startInstance.get(Calendar.DAY_OF_MONTH) <= Calendar.getInstance().get(Calendar.DAY_OF_MONTH))
						&&(startInstance.get(Calendar.HOUR_OF_DAY) <= Calendar.getInstance().get(Calendar.HOUR_OF_DAY))
						&&(startInstance.get(Calendar.MINUTE) <= Calendar.getInstance().get(Calendar.MINUTE))
						){
					
					
					System.out.println("\nCheckForTransfers - "+obj.getSubmitter()+" -- A transfer (Periodically Scheduled) is happening today  - transferId:"+((Transfer)obj).getTransferId()+" -- submitter:"+((Transfer)obj).getSubmitter()+" -- status="+((Transfer)obj).getStatus());
					try {	
						this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
					}catch (Exception e) {
						System.out.println("\nCheckForTransfers -- Exception in updating the transfer status - "+((Transfer)obj).getSubmitter() +" - id="+((Transfer)obj).getTransferId());
						e.printStackTrace();
					}

					// **** Transfer Handler ****
					TransferHandler transferHandler = new TransferHandler(obj.getTransferId(),this.resource,true);
					transferHandler.start();

				}
			}

		}

	}
	

}



