package org.gcube.datatransfer.scheduler.impl.handler;


import static org.gcube.datatransfer.agent.library.proxies.Proxies.transferAgent;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Future;

import javax.jdo.Query;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.TransferOptions;
import org.gcube.datatransfer.agent.library.outcome.FileTransferOutcome;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.OutUriData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageManagerDetails;
import org.gcube.datatransfer.agent.stubs.datatransferagent.StorageType;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;
import org.gcube.datatransfer.scheduler.stubs.datatransferscheduler.SourceData;

import org.gcube.datatransfer.scheduler.db.utils.Utils.FrequencyType;



public class TransferHandler extends Thread {
	Transfer transfer;
	String submitter;
	String transferId;
	DataTransferDBManager dbManager;
	SchedulerResource resource;
	String transferType;
	long checkForMonitorResultIntervalMS;

	//private static GCUBELog logger = new GCUBELog(TransferHandler.class);

	public TransferHandler(String transferId, GCUBEWSResource ws,boolean isPeriodically){
		this.dbManager=ServiceContext.getContext().getDbManager();
		this.transferId=transferId;		
		this.resource=(SchedulerResource) ws;
		this.transfer=this.dbManager.getPersistenceManager().getObjectById(Transfer.class, this.transferId);

		this.submitter=this.transfer.getSubmitter();		
		this.transferType=this.transfer.getTransferType();
		this.checkForMonitorResultIntervalMS=1000 * Integer.valueOf((String) ServiceContext.getContext().getProperty("checkForMonitorResultIntervalMS", true));

	}

	public void run() {
		System.out.println("\nTransferHandler - "+this.resource.getName()+" -- Thread has started");

		AgentLibrary agentLibrary = null;
		List<String> objectTrasferredIDs = new ArrayList<String>();
		List<String> objectFailedIDs = new ArrayList<String>();
		boolean failed=false;	
		List<String> errorsInTransfer = new ArrayList<String>();

		//retrieving the Agent Host and Port
		String agentId = this.transfer.getAgentId();
		if(agentId==null)System.out.println("TransferHandler - Error - agentId=null");
		String hostAgent=this.dbManager.getPersistenceManager().getObjectById(Agent.class,agentId).getHost();
		int portAgent = this.dbManager.getPersistenceManager().getObjectById(Agent.class,agentId).getPort();
		
		//add the transfer id to the resource array of active transfers
		addActiveTransferResource();

		//    *******TRANSFER*******    //

		if(this.transferType.compareTo("LocalFileBasedTransfer")==0){
			//in this case we transfer files from client to the agent node
			//no need for DataSource node
			//no need for DataStorage node
			
			//we need to collect the right TransferObjects
			//check for the objects having the same trasferId with this one.
			Query query=null;
			List<TransferObject> list=null;
			query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(TransferObject.class);
			list = (List<TransferObject>) query.execute();

			List<TransferObject> objectsToBeTransferred= new ArrayList<TransferObject>();
			String transferIdOfSpecific;

			for(TransferObject obj : list){
				transferIdOfSpecific = obj.getTransferid();
				if((transferIdOfSpecific==this.transferId)){
					objectsToBeTransferred.add(obj); 				
				}
			}
			
			//first needed input for the agent method
			ArrayList<File> filesToBeTransferred = new ArrayList<File>();
			for(TransferObject obj : objectsToBeTransferred){
				filesToBeTransferred.add(new File(obj.getURI()));
			}			
			//second needed input for the agent method		
			String destinationFolder = this.transfer.getDestinationFolder();
			//third needed input for the agent method
			boolean overwrite = this.transfer.isOverwrite();
			boolean unzipFile = this.transfer.isUnzipFile();
			String scope = this.transfer.getScope();
			ArrayList<FileTransferOutcome> outcomes = null;			
			try {
				System.out.println("TransferHandler -- scooooooooope="+scope);
				//GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope(scope));
				ScopeProvider.instance.set(scope); 
				agentLibrary =  transferAgent().at(hostAgent, portAgent).build();	

				// *** LocalFileBasedTransfer *** //
				outcomes = agentLibrary.copyLocalFiles(filesToBeTransferred, destinationFolder, overwrite, unzipFile);
				System.out.println("TransferHandler - After the agentLibrary.copyLocalFiles(...)");
			} catch (Exception e) {
				System.out.println("TransferHandler - Exception when call agentLibrary.copyLocalFiles(.....)");
				errorsInTransfer.add(e.getMessage());
				failed=true;
				e.printStackTrace();
			}

			try{
				int numOfObj=0;
				for (FileTransferOutcome outcome : outcomes){
					System.out.println("Exception: "+outcome.getException());
					System.out.println("FileName: "+ outcome.getFilename());
					System.out.println("Success?: "+ outcome.isSuccess());
					System.out.println("Failure?: "+ outcome.isFailure());

					if(outcome.isFailure()==true){
						objectFailedIDs.add(objectsToBeTransferred.get(numOfObj).getObjectId());			
					}
					else if (outcome.isSuccess()==true){
						objectTrasferredIDs.add(objectsToBeTransferred.get(numOfObj).getObjectId());
					}
					numOfObj++;
				}
			} catch (Exception e) {
				System.out.println("TransferHandler - Exception when read the outcomes");
				errorsInTransfer.add(e.getMessage());
				failed=true;
				e.printStackTrace();
			}		

			//remove the transfer id from the resource array of active transfers
			removeActiveTransferResource();
			
			//check the status of transfer
			// if failed
			if(failed==true){
				try {	
					this.dbManager.updateTransferStatus(this.transferId, "FAILED");
					this.dbManager.updateTransferError(this.transferId, errorsInTransfer);
				}catch (Exception e) {
					System.out.println("TransferHandler -- IfFailed - Exception - "+this.submitter+" - id="+this.transferId);
					e.printStackTrace();
				}
			}
			else{
				// if completed
				try {						
					this.dbManager.updateTransferStatus(this.transferId, "COMPLETED");
					String[] objectFailedIDsarray=objectFailedIDs.toArray(new String[objectFailedIDs.size()]);
					String[] objectTrasferredIDsarray=objectTrasferredIDs.toArray(new String[objectTrasferredIDs.size()]);

					this.dbManager.updateObjectTrasferredIDs(this.transferId, objectTrasferredIDsarray);
					this.dbManager.updateObjectFailedIDs(this.transferId, objectFailedIDsarray);
					//System.out.println("TransferHandler -- Completed - "+this.submitter+" - id="+this.transferId);
					System.out.println("TransferHandler -- Completed - "+this.submitter+" - id="+this.transferId);			
				}catch (Exception e) {
					System.out.println("TransferHandler -- IfCompleted - Exception");

					e.printStackTrace();
				}
				//optional printing
				for(String objId : this.dbManager.getPersistenceManager().getObjectById(Transfer.class,this.transferId).getObjectTrasferredIDs())
					System.out.println("TransferHandler -- Completed - TransferredObjectID:"+objId);

						for(String objId : this.dbManager.getPersistenceManager().getObjectById(Transfer.class,this.transferId).getObjectFailedIDs())
							System.out.println("TransferHandler -- Completed - FailedObjectID:"+objId);
			}
		}
		else if(this.transferType.compareTo("FileBasedTransfer")==0){
			
			String transferIdOfAgent = null;
			//objectsToBeTransferred is used only when we don't have source node ..
			List<TransferObject> objectsToBeTransferred= new ArrayList<TransferObject>();
			
			// if SourceId is null it means that we don't have any source node
			// we use directly the urls from the transfer objects
			if(this.transfer.getSourceId()==null){
				//we need to collect the right TransferObjects
				//check for the objects having the same trasferId with this one.
				Query query=null;
				List<TransferObject> list=null;
				query = ServiceContext.getContext().getDbManager().getPersistenceManager().newQuery(TransferObject.class);
				list = (List<TransferObject>) query.execute();

				String transferIdOfSpecific;

				for(TransferObject obj : list){
					transferIdOfSpecific = obj.getTransferid();
					if((transferIdOfSpecific==this.transferId)){
						objectsToBeTransferred.add(obj); 				
					}
				}

				//first needed input for the agent method
				ArrayList<URI> inputUris= new ArrayList<URI>();				
				for(TransferObject obj : objectsToBeTransferred){
					inputUris.add(obj.getURI());
				}	

				StorageType storageType=null;
				StorageManagerDetails storageManagerDetails = new StorageManagerDetails();
								
				// if StorageId is null it means that we don't have any storage node
				// we use the agent's node as a storage
				if(this.transfer.getStorageId()==null){					
					storageType=StorageType.LocalGHN;
					
					// (useless when we don't have a real storage)
					storageManagerDetails.setOwner("NickDrakopoulos");
					storageManagerDetails.setServiceName("--");
					storageManagerDetails.setServiceClass("--");
				}
				else{ // in other case we have a DataStorage node
					storageType=StorageType.StorageManager;
					// now storageManagerDetails has to be filled with the real info	
					storageManagerDetails.setOwner("NickDrakopoulos");
					storageManagerDetails.setServiceName("--");
					storageManagerDetails.setServiceClass("--");
				}
				
				//second needed input for the agent method
				String destinationFolder = this.transfer.getDestinationFolder();
				
				//third input for the agent method
				TransferOptions transferOptions= new TransferOptions();				
				transferOptions.setType(storageType);
				transferOptions.setOverwriteFile(this.transfer.isOverwrite());
				transferOptions.setUnzipFile(this.transfer.isUnzipFile());
				transferOptions.setStorageManagerDetails(storageManagerDetails);
				
				String scope = this.transfer.getScope();
				System.out.println("TransferHandler -- scooooooooope="+scope);

				try {
					//GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope(scope));
					ScopeProvider.instance.set(scope); 

					agentLibrary =  transferAgent().at(hostAgent, portAgent).build();	

					// *** startTransfer *** //
					transferIdOfAgent = agentLibrary.startTransfer(inputUris, destinationFolder, transferOptions);
					System.out.println("TransferHandler - After the agentLibrary.startTransfer(...)");
				} catch (Exception e) {
					System.out.println("TransferHandler - Exception when call agentLibrary.startTransfer(.....)");
					errorsInTransfer.add(e.getMessage());
					failed=true;
					e.printStackTrace();
				}
				try	{ // *** store the transferIdOfAgent inside the Transfer in DB ***
					ServiceContext.getContext().getDbManager().updateTransferIdOfAgentInTransfer(this.transferId,transferIdOfAgent);
				}
				catch(Exception e){
					System.out.println("TransferHandler "+
							"- Exception in storing the transferIdOfAgent inside the Transfer in DB\n");
					e.printStackTrace();
				}
			}
			else { // in other case we have a source node... 
				DataSource dataSource = this.dbManager.getPersistenceManager().getObjectById(DataSource.class, this.transfer.getSourceId());
				
				org.gcube.datatransfer.agent.library.DataSource dataSourceOfAgent = new org.gcube.datatransfer.agent.library.DataSource();
				SourceData sourceData = new SourceData();
				//sourceData.setHostName(dataSource.getHost());
				//sourceData.set...
				//TO BE DONE
				
				org.gcube.datatransfer.agent.library.DataStorage storageOfAgent = new org.gcube.datatransfer.agent.library.DataStorage();
				DestData destData= new DestData();
				
				StorageType storageType=null;
				StorageManagerDetails storageManagerDetails = new StorageManagerDetails();
								
				// if StorageId is null it means that we don't have any storage node
				// we use the agent's node as a storage
				if(this.transfer.getStorageId()==null){					
					storageType=StorageType.LocalGHN;
					
					// (useless when we don't have a real storage)
					storageManagerDetails.setOwner("NickDrakopoulos");
					storageManagerDetails.setServiceName("--");
					storageManagerDetails.setServiceClass("--");
				}
				else{ // in other case we have a DataStorage node
					storageType=StorageType.StorageManager;
					// now storageManagerDetails has to be filled with the real info	
					storageManagerDetails.setOwner("NickDrakopoulos");
					storageManagerDetails.setServiceName("--");
					storageManagerDetails.setServiceClass("--");
				}
				
				//second needed input for the agent method
				String destinationFolder = this.transfer.getDestinationFolder();
				
				//third input for the agent method
				TransferOptions transferOptions= new TransferOptions();				
				transferOptions.setType(storageType);
				transferOptions.setOverwriteFile(this.transfer.isOverwrite());
				transferOptions.setUnzipFile(this.transfer.isUnzipFile());
				transferOptions.setStorageManagerDetails(storageManagerDetails);
				
				String scope = this.transfer.getScope();
				System.out.println("TransferHandler -- scooooooooope="+scope);				
							
				try {
					ScopeProvider.instance.set(scope); 

					agentLibrary =  transferAgent().at(hostAgent, portAgent).build();	

					// *** startTransfer *** //
					//-----------------------------------------
					//here we need the new operation in agent
					//transferIdOfAgent=agentLibrary.startTransfer(dataSourceOfAgent, storageOfAgent, transferOptions);
					System.out.println("TransferHandler - After the agentLibrary.startTransfer(...)");
				} catch (Exception e) {
					System.out.println("TransferHandler - Exception when call agentLibrary.startTransfer(.....)");
					errorsInTransfer.add(e.getMessage());
					failed=true;
					e.printStackTrace();
				}
				try	{ // *** store the transferIdOfAgent inside the Transfer in DB ***
					ServiceContext.getContext().getDbManager().updateTransferIdOfAgentInTransfer(this.transferId,transferIdOfAgent);
				}
				catch(Exception e){
					System.out.println("TransferHandler "+
							"- Exception in storing the transferIdOfAgent inside the Transfer in DB\n");
					e.printStackTrace();
				}
			}
			
			//after checking if we have or not SourceData node / DataStorage node
			//and calling the appropriate operation of agent, 
			//we continuously monitor the result until we get sth different to "STARTED"
			
			String resultOfMonitoring="";
			do{	
				try{
					// *** monitorTransfer *** //
					resultOfMonitoring = agentLibrary.monitorTransfer(transferIdOfAgent);
					//System.out.println("TransferHandler - After the agentLibrary.monitorTransfer(...)");
				} catch (Exception e) {
					System.out.println("TransferHandler - Exception when call agentLibrary.monitorTransfer(.....)");
					errorsInTransfer.add(e.getMessage());
					failed=true;
					e.printStackTrace();
				}
				try {
					Thread.sleep(checkForMonitorResultIntervalMS);
				} catch (InterruptedException e) {
					System.out.println("TransferHandler -- InterruptedException-Unable to sleep");
					e.printStackTrace();
				}		
			}while(resultOfMonitoring.compareTo("STARTED")==0);

			System.out.println("TransferHandler -- monitorTransfer result="+resultOfMonitoring);
			String retrivedStatus= this.dbManager.getPersistenceManager().getObjectById(Transfer.class,this.transferId).getStatus();
			
			//remove the transfer id from the resource array of active transfers
			removeActiveTransferResource();
			
			//check the status of the transfer
			//if we had a cancellation during the transfer: 
			//Although transfer has been done we keep the status "CANCELED"
			//in case of having a periodicallyScheduled transfer.
			if(retrivedStatus.compareTo("CANCELED")==0){
				System.out.println("TransferHandler -- Canceled");
				return;
			}
			
			//check the result of monitoring - if it is cancel we update the status and return
			if(resultOfMonitoring.compareTo("CANCEL")==0){
				try {					
					this.dbManager.updateTransferStatus(this.transferId, "CANCELED");
					System.out.println("TransferHandler -- Canceled - "+this.submitter+" - id="+this.transferId);			
					return;
				}catch (Exception e) {
					System.out.println("TransferHandler -- IfCanceled - Exception");
					e.printStackTrace();
				}
			}
			
			//*** getTransferOutcomes *** //
			try {
				ArrayList<FileTransferOutcome> outcomes = agentLibrary.getTransferOutcomes(transferIdOfAgent, FileTransferOutcome.class);			
				int numOfObj=0;
				for (FileTransferOutcome outcome : outcomes){
					if(numOfObj==0)System.out.println("TransferHandler -- getTransferOutcomes:");
					System.out.println("Exception: "+outcome.getException());
					System.out.println("FileName: "+ outcome.getFilename());
					System.out.println("Success?: "+ outcome.isSuccess());
					System.out.println("Failure?: "+ outcome.isFailure());

					//objectFailedIDs and objectTrasferredIDs are only stored when we do not have any SourceNode and we use 
					// inputUrls directly .. 
					if(this.transfer.getSourceId()==null){
						if(outcome.isFailure()==true){
							objectFailedIDs.add(objectsToBeTransferred.get(numOfObj).getObjectId());			
						}
						else if (outcome.isSuccess()==true){
							objectTrasferredIDs.add(objectsToBeTransferred.get(numOfObj).getObjectId());
						}
					}
					numOfObj++;
				}
			} catch (Exception e) {
				System.out.println("TransferHandler - Exception when call agentLibrary.getTransferOutcomes(..) and read the outcomes");
				errorsInTransfer.add(e.getMessage());
				failed=true;
				e.printStackTrace();
			}		


			if(resultOfMonitoring.compareTo("DONE")==0){
				try {					
					this.dbManager.updateTransferStatus(this.transferId, "COMPLETED");
					System.out.println("TransferHandler -- Completed - "+this.submitter+" - id="+this.transferId);			

					//objectFailedIDs and objectTrasferredIDs are only stored when we do not have any SourceNode and we use 
					// inputUrls directly .. 
					if(this.transfer.getSourceId()==null){
						String[] objectFailedIDsarray=objectFailedIDs.toArray(new String[objectFailedIDs.size()]);
						String[] objectTrasferredIDsarray=objectTrasferredIDs.toArray(new String[objectTrasferredIDs.size()]);

						this.dbManager.updateObjectTrasferredIDs(this.transferId, objectTrasferredIDsarray);
						this.dbManager.updateObjectFailedIDs(this.transferId, objectFailedIDsarray);
					}
				}catch (Exception e) {
					System.out.println("TransferHandler -- IfCompleted - Exception");
					e.printStackTrace();
				}

				//optional printing when we don't have Source node and we use directly inputUrls
				if(this.transfer.getSourceId()==null){
					for(String objId : this.transfer.getObjectTrasferredIDs())
						System.out.println("TransferHandler -- Completed - TransferredObjectID:"+objId);

					for(String objId : this.transfer.getObjectFailedIDs())
						System.out.println("TransferHandler -- Completed - FailedObjectID:"+objId);
				}
			}
			else { //"FAILED"
				try {					
					this.dbManager.updateTransferStatus(this.transferId, "FAILED");
					//check for the outcome!! call the agent library and get the outcome! 
					this.dbManager.updateTransferError(this.transferId, errorsInTransfer);
					System.out.println("TransferHandler -- Failed - "+this.submitter+" - id="+this.transferId);			
				}catch (Exception e) {
					System.out.println("TransferHandler -- IfFailed - Exception");
					e.printStackTrace();
				}
			}
		}
		else if(this.transferType.compareTo("TreeBasedTransfer")==0){
			String scope = this.transfer.getScope();
			GCUBEScopeManager.DEFAULT.setScope(GCUBEScope.getScope(scope));
			// ##### empty for now #####
			//...
			//...
			//remove the transfer id from the resource array of active transfers
			removeActiveTransferResource();
		}

		//-------------------------------------------------------------------------------//
		//-------------------------------------------------------------------------------//
		//------------only in case of a periodically scheduled---------------------------//

		String idTypeOfSchedule=this.transfer.getTypeOfScheduleId();
		TypeOfSchedule typeOfSchedule = this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class,idTypeOfSchedule );
		String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();	
		String retrivedStatus= this.dbManager.getPersistenceManager().getObjectById(Transfer.class,this.transferId).getStatus();


		// if it's periodically scheduled we change (refresh with a new value) the startInstance
		// and we make the status of the transfer STANDBY again
		// but if it's been changed in CANCELED in the meantime we keep it as it is...
		if((periodicallyScheduledId!=null)&&(retrivedStatus!="CANCELED")){
			PeriodicallyScheduled periodicallyScheduled = this.dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class,periodicallyScheduledId );
			Calendar startInstance=periodicallyScheduled.getStartInstance();
			try{
				this.dbManager.updateTransferStartInstance(this.transferId, Calendar.getInstance());
			}catch (Exception e) {
				System.out.println("\nCheckForTransfers -- Exception in updating the transfer startInstance (1)- "+this.submitter +" - id="+this.transferId);
				e.printStackTrace();
			}
		
			try {					
				FrequencyType frequencyType = periodicallyScheduled.getFrequency();

				if(frequencyType==FrequencyType.perYear)startInstance.add(Calendar.YEAR, 1);
				else if(frequencyType==FrequencyType.perMonth)startInstance.add(Calendar.MONTH, 1);
				else if(frequencyType==FrequencyType.perWeek)startInstance.add(Calendar.DAY_OF_MONTH, 7);
				else if(frequencyType==FrequencyType.perDay)startInstance.add(Calendar.DAY_OF_MONTH, 1);
				else if(frequencyType==FrequencyType.perHour)startInstance.add(Calendar.HOUR_OF_DAY, 1);
				else if(frequencyType==FrequencyType.perMinute)startInstance.add(Calendar.MINUTE, 1);
			}catch (Exception e) {
				System.out.println("\nTransferHandler -- Exception in forward the startInstance - "+this.submitter +" - id="+this.transferId);
				e.printStackTrace();
			}
			
			try{				
				//i don't use the startInstance variable because it creates a problem when trying to store it in db 
				//it seems that there's an issue after using the 'roll' method.. that's why we copy
				//the values that we want in another calendar variable
				//----fixed .. I just use add instead of roll 
				Calendar tmpCalendar=Calendar.getInstance();
				tmpCalendar.set(Calendar.YEAR,startInstance.get(Calendar.YEAR));
				tmpCalendar.set(Calendar.MONTH,startInstance.get(Calendar.MONTH));
				tmpCalendar.set(Calendar.DAY_OF_MONTH,startInstance.get(Calendar.DAY_OF_MONTH));
				tmpCalendar.set(Calendar.HOUR_OF_DAY,startInstance.get(Calendar.HOUR_OF_DAY));
				tmpCalendar.set(Calendar.MINUTE,startInstance.get(Calendar.MINUTE));

				this.dbManager.updateTransferStartInstance(this.transferId, tmpCalendar);
			}catch (Exception e) {
				System.out.println("\nCheckForTransfers -- Exception in updating the transfer startInstance (2)- "+this.submitter +" - id="+this.transferId);
				e.printStackTrace();
			}
			
			try {	
				this.dbManager.updateTransferStatus(this.transferId, "STANDBY");
			}catch (Exception e) {
				System.out.println("\nTransferHandler -- Exception in updating the transfer status - "+this.submitter +" - id="+this.transferId);
				e.printStackTrace();
			}
		}

	}
	
	public void addActiveTransferResource(){
		String[] alreadyActiveTransferIDs = this.resource.getActiveTransfers();
		String[] newActiveTransferIDS= new String[alreadyActiveTransferIDs.length+1];
		int i=0;
		for(String temp : alreadyActiveTransferIDs){
			newActiveTransferIDS[i]=temp;
			i++;
		}
		newActiveTransferIDS[i]=this.transferId;
		try{
			this.resource.setActiveTransfers(newActiveTransferIDS);
			this.resource.store();
		}catch (Exception e) {
			System.out.println("TransferHandler (addResourceOfActiveTransfer)-- Exception in Storing the Resource Property 'ActiveTransfers'"  );
			e.printStackTrace();
		}
		try{
			int alreadyNumberOfActive = Integer.valueOf(this.resource.getNumOfActiveTransfers());
			String newNumberOfActive = (alreadyNumberOfActive+1)+"";
			this.resource.setNumOfActiveTransfers(newNumberOfActive);
			this.resource.store();
		}catch (Exception e) {
			System.out.println("TransferHandler (addResourceOfActiveTransfer) -- Exception in Storing the Resource Property 'NumOfActiveTransfers'"  );
			e.printStackTrace();
		}
	}

	public void removeActiveTransferResource(){
		String[] alreadyActiveTransferIDs = this.resource.getActiveTransfers();
		String[] newActiveTransferIDS= new String[alreadyActiveTransferIDs.length-1];
		int i=0;
		for(String temp : alreadyActiveTransferIDs){
			if(this.transferId.compareTo(temp)==0)continue;
			newActiveTransferIDS[i]=temp;
			i++;
		}
		try{
			this.resource.setActiveTransfers(newActiveTransferIDS);
			this.resource.store();
		}catch (Exception e) {
			System.out.println("TransferHandler (removeActiveTransferResource)-- Exception in Storing the Resource Property 'ActiveTransfers'"  );
			e.printStackTrace();
		}
		try{
			int alreadyNumberOfActive = Integer.valueOf(this.resource.getNumOfActiveTransfers());
			String newNumberOfActive = (alreadyNumberOfActive-1)+"";
			this.resource.setNumOfActiveTransfers(newNumberOfActive);
			this.resource.store();
		}catch (Exception e) {
			System.out.println("TransferHandler (removeActiveTransferResource) -- Exception in Storing the Resource Property 'NumOfActiveTransfers'"  );
			e.printStackTrace();
		}
	}
}
