/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.check;

import java.util.Calendar;
import java.util.List;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.ManuallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.PeriodicallyScheduled;
import org.gcube.datatransfer.scheduler.db.model.Transfer;
import org.gcube.datatransfer.scheduler.db.model.TypeOfSchedule;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;
import org.gcube.datatransfer.scheduler.impl.handler.TransferHandler;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerResource;

public class CheckDBForTransfers {
    public DataTransferDBManager dbManager = null;
    public SchedulerResource resource = null;
    public long checkForTransfersIntervalMS;
    public List<Transfer> transfers = null;
    GCUBELog logger = new GCUBELog(CheckDBForTransfers.class);

    public CheckDBForTransfers(GCUBEWSResource ws, List<Transfer> transfers) {
        this.dbManager = ServiceContext.getContext().getDbManager();
        this.resource = (SchedulerResource)ws;
        this.transfers = transfers;
    }

    public void check() {
        for (Transfer obj : this.transfers) {
            TypeOfSchedule typeOfSchedule = null;
            String idTypeOfSchedule = null;
            try {
                idTypeOfSchedule = obj.getTypeOfScheduleId();
                typeOfSchedule = (TypeOfSchedule)this.dbManager.getPersistenceManager().getObjectById(TypeOfSchedule.class, (Object)idTypeOfSchedule);
            }
            catch (Exception e) {
                this.logger.error((Object)"CheckForTransfers -- Exception in retrieving the typeOfSchedule");
                e.printStackTrace();
            }
            String periodicallyScheduledId = typeOfSchedule.getPeriodicallyScheduledId();
            String idManuallyScheduled = typeOfSchedule.getManuallyScheduledId();
            if (typeOfSchedule.isDirectedScheduled()) {
                this.logger.debug((Object)("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Direct Transfer) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus()));
                try {
                    this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
                }
                catch (Exception e) {
                    this.logger.error((Object)("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId()));
                    e.printStackTrace();
                }
                TransferHandler transferHandler = new TransferHandler(obj.getTransferId(), this.resource, false);
                transferHandler.start();
                continue;
            }
            if (idManuallyScheduled != null) {
                ManuallyScheduled manuallyScheduled = (ManuallyScheduled)this.dbManager.getPersistenceManager().getObjectById(ManuallyScheduled.class, (Object)idManuallyScheduled);
                Calendar calendarTmp = manuallyScheduled.getCalendar();
                Calendar calendarComp = this.setCalendarComp(calendarTmp);
                long leftMillis = calendarTmp.getTimeInMillis() - calendarComp.getTimeInMillis();
                if (leftMillis >= 60000L) continue;
                this.logger.debug((Object)("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Manually Scheduled) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus()));
                if (leftMillis < 0L) {
                    try {
                        this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId()));
                        e.printStackTrace();
                    }
                }
                TransferHandler transferHandler = new TransferHandler(obj.getTransferId(), this.resource, false);
                transferHandler.start();
                continue;
            }
            if (periodicallyScheduledId == null) continue;
            PeriodicallyScheduled periodicallyScheduled = (PeriodicallyScheduled)this.dbManager.getPersistenceManager().getObjectById(PeriodicallyScheduled.class, (Object)periodicallyScheduledId);
            Calendar startInstance = periodicallyScheduled.getStartInstance();
            Calendar calendarComp = this.setCalendarComp(startInstance);
            long leftMillis = startInstance.getTimeInMillis() - calendarComp.getTimeInMillis();
            if (leftMillis >= 60000L) continue;
            this.logger.debug((Object)("\nCheckForTransfers - " + obj.getSubmitter() + " -- A transfer (Periodically Scheduled) is happening today  - transferId:" + obj.getTransferId() + " -- submitter:" + obj.getSubmitter() + " -- status=" + obj.getStatus()));
            try {
                this.dbManager.updateTransferStatus(obj.getTransferId(), "ONGOING");
            }
            catch (Exception e) {
                this.logger.error((Object)("\nCheckForTransfers -- Exception in updating the transfer status - " + obj.getSubmitter() + " - id=" + obj.getTransferId()));
                e.printStackTrace();
            }
            TransferHandler transferHandler = new TransferHandler(obj.getTransferId(), this.resource, true);
            transferHandler.start();
        }
    }

    private Calendar setCalendarComp(Calendar transferCal) {
        Calendar calendarComp = (Calendar)transferCal.clone();
        calendarComp.set(1, Calendar.getInstance().get(1));
        calendarComp.set(2, Calendar.getInstance().get(2));
        calendarComp.set(5, Calendar.getInstance().get(5));
        calendarComp.set(11, Calendar.getInstance().get(11));
        calendarComp.set(12, Calendar.getInstance().get(12));
        return calendarComp;
    }
}

