/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.porttype;

import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.model.TransferObject;
import org.gcube.datatransfer.scheduler.impl.context.ServiceContext;

public class StoreTransferObjectThread
extends Thread {
    Set<TransferObject> objs;
    String transferId;
    GCUBELog logger = new GCUBELog((Object)this);

    public StoreTransferObjectThread(Set<TransferObject> objs, String transferId) {
        this.objs = objs;
        this.transferId = transferId;
    }

    @Override
    public void run() {
        for (int numOfTrying = 0; !this.process() && numOfTrying < 3; ++numOfTrying) {
        }
    }

    public boolean process() {
        try {
            ServiceContext.getContext().getDbManager().storeTransferObject(this.objs);
        }
        catch (Exception e) {
            this.logger.error((Object)"StoreTransferObjectThread - Exception in storing the Set of Transfer Objects:\n");
            e.printStackTrace();
            return false;
        }
        try {
            ServiceContext.getContext().getDbManager().updateTransferReadyObjects(this.transferId, true);
        }
        catch (Exception e) {
            this.logger.error((Object)"StoreTransferObjectThread - Exception in updating the ready objs flag:\n");
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

