/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.impl.context;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.datatransfer.common.messaging.MSGClient;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.impl.state.SchedulerRIResourceConsumer;
import org.gcube.datatransfer.scheduler.is.ISManager;

public class ServiceContext
extends GCUBEServiceContext {
    private static ServiceContext cache = new ServiceContext();
    private DataTransferDBManager dbManager = null;
    private String dbConfigurationFileName = null;
    private ISManager isManagerForAgents = null;
    private ISManager isManagerForSources = null;
    private ISManager isManagerForStorages = null;
    private boolean messagingEnabled = false;
    private MSGClient msgClient = null;
    private long maxTimeToSetInactiveAnOngoingTransferInMS = 0L;

    protected void onInitialisation() throws Exception {
        try {
            this.maxTimeToSetInactiveAnOngoingTransferInMS = Long.valueOf((String)this.getProperty("maxTimeToSetInactiveAnOngoingTransferInMS", new boolean[]{true}));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.maxTimeToSetInactiveAnOngoingTransferInMS = 1800000L;
        }
        this.dbConfigurationFileName = (String)this.getProperty("dbConfigurationFile", new boolean[]{true});
        this.messagingEnabled = (Boolean)this.getProperty("messaging", new boolean[]{true});
        this.dbManager = new DataTransferDBManager(this.dbConfigurationFileName, ServiceContext.getContext().getPersistenceRoot().getAbsolutePath(), (String)ServiceContext.getContext().getProperty("configDir", new boolean[]{true}));
        this.getInstance().subscribeResourceEvents((GCUBEResource.ResourceConsumer)new SchedulerRIResourceConsumer(), new GCUBEResource.ResourceTopic[]{GCUBEResource.ResourceTopic.ADDSCOPE});
    }

    public static ServiceContext getContext() {
        return cache;
    }

    private ServiceContext() {
    }

    protected String getJNDIName() {
        return "gcube/datatransfer/scheduler/";
    }

    public DataTransferDBManager getDbManager() {
        return this.dbManager;
    }

    public void setDbManager(DataTransferDBManager dbManager) {
        this.dbManager = dbManager;
    }

    public ISManager getIsManagerForAgents() {
        return this.isManagerForAgents;
    }

    public void setIsManagerForAgents(ISManager isManagerForAgents) {
        this.isManagerForAgents = isManagerForAgents;
    }

    public ISManager getIsManagerForSources() {
        return this.isManagerForSources;
    }

    public void setIsManagerForSources(ISManager isManagerForSources) {
        this.isManagerForSources = isManagerForSources;
    }

    public ISManager getIsManagerForStorages() {
        return this.isManagerForStorages;
    }

    public void setIsManagerForStorages(ISManager isManagerForStorages) {
        this.isManagerForStorages = isManagerForStorages;
    }

    public String getDbConfigurationFileName() {
        return this.dbConfigurationFileName;
    }

    public void setDbConfigurationFileName(String dbConfigurationFileName) {
        this.dbConfigurationFileName = dbConfigurationFileName;
    }

    public boolean isMessagingEnabled() {
        return this.messagingEnabled;
    }

    public MSGClient getMsgClient() {
        return this.msgClient;
    }

    public void setMessagingEnabled(boolean messagingEnabled) {
        this.messagingEnabled = messagingEnabled;
    }

    public void setMsgClient(MSGClient msgClient) {
        this.msgClient = msgClient;
    }

    public long getMaxTimeToSetInactiveAnOngoingTransferInMS() {
        return this.maxTimeToSetInactiveAnOngoingTransferInMS;
    }

    public void setMaxTimeToSetInactiveAnOngoingTransferInMS(long maxTimeToSetInactiveAnOngoingTransferInMS) {
        this.maxTimeToSetInactiveAnOngoingTransferInMS = maxTimeToSetInactiveAnOngoingTransferInMS;
    }
}

