/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.plugins.sis;

import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import java.io.File;
import java.util.Map;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.xml.XML;
import org.gcube.data.transfer.model.ExecutionReport;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.AbstractPlugin;
import org.gcube.data.transfer.plugin.fails.PluginCleanupException;
import org.gcube.data.transfer.plugin.fails.PluginExecutionException;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.opengis.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SisPlugin
extends AbstractPlugin {
    private static final Logger log = LoggerFactory.getLogger(SisPlugin.class);

    public SisPlugin(PluginInvocation invocation) {
        super(invocation);
    }

    public void cleanup() throws PluginCleanupException {
    }

    public ExecutionReport run() throws PluginExecutionException {
        try {
            Map params = this.invocation.getParameters();
            String dataStorePath = (String)params.get("SOURCE_FILE");
            String category = params.containsKey("GEONETWORK_CATEGORY") ? (String)params.get("GEONETWORK_CATEGORY") : "Dataset";
            String stylesheet = params.containsKey("GEONETWORK_STYLESHEET") ? (String)params.get("GEONETWORK_STYLESHEET") : "_none_";
            File dataStore = new File(dataStorePath);
            log.debug("Extracting meta from {} ", (Object)dataStore.getAbsolutePath());
            Metadata meta = SisPlugin.getMetaFromFile(dataStore);
            long id = SisPlugin.publishMetadata(meta, category, stylesheet);
            return new ExecutionReport(this.invocation, "Published meta with id : " + id, ExecutionReport.ExecutionReportFlag.SUCCESS);
        }
        catch (DataStoreException e) {
            log.error("Unable to parse source ", (Throwable)e);
            throw new PluginExecutionException("Unable to extract metadata.", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("Unexpected error while generating metadata.", t);
            throw new PluginExecutionException("Unexpected error while generating meta.", t);
        }
    }

    public static final Metadata getMetaFromFile(Object dataStore) throws UnsupportedStorageException, DataStoreException {
        return DataStores.open((Object)dataStore).getMetadata();
    }

    public static final long publishMetadata(Metadata meta, String category, String stylesheet) throws Exception {
        File tmp = File.createTempFile("tmp_meta_", ".xml");
        XML.marshal((Object)meta, (File)tmp);
        GeoNetworkAdministration publisher = GeoNetwork.get();
        publisher.login(LoginLevel.DEFAULT);
        GNInsertConfiguration config = publisher.getCurrentUserConfiguration(category, stylesheet);
        config.setValidate(Boolean.valueOf(false));
        long toReturn = publisher.insertMetadata(config, tmp);
        tmp.delete();
        return toReturn;
    }
}

