package org.gcube.data.transfer.plugins.thredds.catalog;

import java.io.File;
import java.util.Map;

import org.gcube.data.transfer.model.ExecutionReport;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.model.ExecutionReport.ExecutionReportFlag;
import org.gcube.data.transfer.plugin.AbstractPlugin;
import org.gcube.data.transfer.plugin.fails.PluginCleanupException;
import org.gcube.data.transfer.plugin.fails.PluginExecutionException;
import org.gcube.data.transfer.plugins.thredds.ThreddsInitDetails;
import org.gcube.data.transfer.plugins.thredds.XMLCatalogHandler;

import lombok.extern.slf4j.Slf4j;
@Slf4j
public class RegisterCatalogPlugin extends AbstractPlugin{

	ThreddsInitDetails threddsInit;


	public RegisterCatalogPlugin(PluginInvocation invocation,ThreddsInitDetails threddsInit) {
		super(invocation);
		this.threddsInit=threddsInit;
	}

	@Override
	public void cleanup() throws PluginCleanupException {
		// TODO Auto-generated method stub

	}

	@Override
	public ExecutionReport run() throws PluginExecutionException {
		try {		
			Map<String,String> params=invocation.getParameters();
			String catalogFile=params.get(RegisterCatalogPluginFactory.CATALOG_FILE);
			String catalogReference=params.get(RegisterCatalogPluginFactory.CATALOG_REFERENCE);
			log.trace("Registering {} as {} in {} ",catalogFile,catalogReference,threddsInit.getMainCatalogFile());
			
			
			XMLCatalogHandler handler=new XMLCatalogHandler(new File(threddsInit.getMainCatalogFile()));

			handler.registerCatalog(catalogFile,catalogReference);

			return new ExecutionReport(invocation,"Registered catalog entry "+catalogReference,ExecutionReportFlag.SUCCESS);
		}catch(Throwable t) {
			log.error("Unable to register catalog.",t);
			throw new PluginExecutionException("Unable to register catalog.",t);
		}
	}
	
}
