/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.util.SVNUpdater;
import org.gcube.dataanalysis.dataminer.poolmanager.util.ServiceConfiguration;

public class CheckMethod {
    public boolean checkMethod(String machine, String token) throws Exception {
        try {
            String line;
            System.out.println("Machine: " + machine);
            String getCapabilitesRequest = new String();
            String getCapabilitesResponse = new String();
            System.out.println("   Token: " + token);
            String request = "http://" + machine + "/wps/WebProcessingService?Request=GetCapabilities&Service=WPS&gcube-token=" + token;
            String response = machine + "___" + token + ".xml";
            getCapabilitesRequest = request;
            getCapabilitesResponse = response;
            String baseDescriptionRequest = "http://" + machine + "/wps/WebProcessingService?Request=DescribeProcess&Service=WPS&Version=1.0.0&gcube-token=" + token + "&Identifier=";
            URL requestURL = new URL(request);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(requestURL.openStream()));
            FileWriter fileWriter = new FileWriter(response);
            boolean flag = true;
            while (flag && (line = bufferedReader.readLine()) != null) {
                fileWriter.write(line);
                fileWriter.write(System.lineSeparator());
                if (!line.contains("ows:Identifier")) continue;
                String operatorName = line.substring(line.indexOf(">") + 1);
                operatorName = operatorName.substring(0, operatorName.indexOf("<"));
                System.out.println("      " + operatorName);
                URL innerRequestURL = new URL(baseDescriptionRequest + operatorName);
                BufferedReader innerBufferedReader = new BufferedReader(new InputStreamReader(innerRequestURL.openStream()));
                String innerLine = innerBufferedReader.readLine();
                boolean innerFlag = true;
                while (innerFlag && (innerLine = innerBufferedReader.readLine()) != null) {
                    if (innerLine.contains("ows:Abstract")) {
                        String operatorDescription = innerLine.substring(innerLine.indexOf(">") + 1);
                        operatorDescription = operatorDescription.substring(0, operatorDescription.indexOf("<"));
                        System.out.println("         " + operatorDescription);
                        innerFlag = false;
                        continue;
                    }
                    if (innerLine.contains("ows:ExceptionText")) {
                        System.out.println("         error retrieving operator description");
                        innerFlag = false;
                        flag = false;
                        continue;
                    }
                    innerLine = innerBufferedReader.readLine();
                }
            }
            fileWriter.close();
        }
        catch (Exception a) {
            a.getMessage();
            return false;
        }
        return true;
    }

    public boolean algoExists(Algorithm a, String env) throws Exception {
        System.out.println("checking existing in env: " + env);
        File file = new File("/home/gcube/wps_algorithms/algorithms/" + a.getName() + ".jar");
        File file2 = new File("/home/gcube/wps_algorithms/algorithms/" + a.getName() + "_interface.jar");
        System.out.println("First file is located to: " + file.getPath());
        System.out.println("Second file is located to: " + file2.getPath());
        if (this.doesExist(file.getPath(), env) && this.doesExist(file2.getPath(), env)) {
            this.copyFromDmToSVN(file, env);
            this.copyFromDmToSVN(file2, env);
            return true;
        }
        System.out.println("Algorithm " + a.getName() + ".jar and " + a.getName() + "_interface.jar files are not present at the expected path");
        return false;
    }

    public void deleteFiles(Algorithm a, String env) throws Exception {
        JSch jsch = new JSch();
        Session session = null;
        Channel channel = null;
        ChannelSftp c = null;
        ServiceConfiguration p = new ServiceConfiguration();
        System.out.println("checking existing in env: " + env + " " + p.getHost(env));
        File file = new File("/home/gcube/wps_algorithms/algorithms/" + a.getName() + ".jar");
        File file2 = new File("/home/gcube/wps_algorithms/algorithms/" + a.getName() + "_interface.jar");
        System.out.println("First file is located to: " + file.getPath());
        System.out.println("Second file is located to: " + file2.getPath());
        jsch.setKnownHosts("~/.ssh/known_hosts");
        String privateKey = "~/.ssh/id_rsa";
        jsch.addIdentity(privateKey);
        System.out.println("Private Key Added.");
        session = jsch.getSession("root", p.getHost(env));
        System.out.println("session created.");
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.connect();
        channel = session.openChannel("sftp");
        channel.connect();
        System.out.println("shell channel connected....");
        c = (ChannelSftp)channel;
        if (this.doesExist(file.getPath(), env) && this.doesExist(file2.getPath(), env)) {
            c.rm(file.getPath());
            c.rm(file2.getPath());
            System.out.println("Both the files have been deleted");
        } else {
            System.out.println("Files not found");
        }
        channel.disconnect();
        c.disconnect();
        session.disconnect();
    }

    public boolean doesExist(String path, String env) throws Exception {
        boolean success;
        ChannelSftp c;
        Channel channel;
        Session session;
        block2: {
            JSch jsch = new JSch();
            session = null;
            channel = null;
            c = null;
            success = false;
            ServiceConfiguration p = new ServiceConfiguration();
            jsch.setKnownHosts("~/.ssh/known_hosts");
            String privateKey = "~/.ssh/id_rsa";
            jsch.addIdentity(privateKey);
            System.out.println("Private Key Added.");
            session = jsch.getSession("root", p.getHost(env));
            System.out.println("session created.");
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            channel = session.openChannel("sftp");
            channel.connect();
            System.out.println("shell channel connected....");
            c = (ChannelSftp)channel;
            SftpATTRS is = null;
            System.out.println(path);
            try {
                is = c.lstat(path);
                success = true;
            }
            catch (SftpException e) {
                if (e.id != 2) break block2;
                success = false;
            }
        }
        channel.disconnect();
        c.disconnect();
        session.disconnect();
        return success;
    }

    public void copyFromDmToSVN(File a, String env) throws Exception {
        JSch jsch = new JSch();
        Session session = null;
        ServiceConfiguration sc = new ServiceConfiguration();
        SVNUpdater svnUpdater = new SVNUpdater(sc);
        ServiceConfiguration p = new ServiceConfiguration();
        jsch.setKnownHosts("~/.ssh/known_hosts");
        String privateKey = "~/.ssh/id_rsa";
        jsch.addIdentity(privateKey);
        System.out.println("Private Key Added.");
        session = jsch.getSession("root", p.getHost(env));
        System.out.println("session created.");
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.connect();
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp sftp = (ChannelSftp)channel;
        sftp.cd("/home/gcube/wps_algorithms/algorithms/");
        System.out.println("REMOTE : /home/gcube/wps_algorithms/algorithms/" + a.getName());
        System.out.println("LOCAL : /tmp/" + a.getName());
        sftp.get("/home/gcube/wps_algorithms/algorithms/" + a.getName(), "/tmp/" + a.getName());
        channel.disconnect();
        session.disconnect();
        File f = new File("/tmp/" + a.getName());
        svnUpdater.updateAlgorithmFiles(f);
        f.delete();
    }

    public static void main(String[] args) throws Exception {
        CheckMethod a = new CheckMethod();
        Algorithm al = new Algorithm();
        al.setName("RBLACKBOX");
        a.deleteFiles(al, "Dev");
    }
}

