/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Dependency;
import org.gcube.dataanalysis.dataminer.poolmanager.util.NotificationHelper;
import org.gcube.dataanalysis.dataminer.poolmanager.util.SendMail;
import org.gcube.dataanalysis.dataminer.poolmanager.util.ServiceConfiguration;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class SVNUpdater {
    private SVNRepository svnRepository;
    private ServiceConfiguration configuration;

    public SVNUpdater(ServiceConfiguration configuration) throws SVNException {
        this.svnRepository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)configuration.getSVNRepository()));
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager();
        this.svnRepository.setAuthenticationManager(authManager);
        this.configuration = configuration;
    }

    public String getDependencyFile(String language) {
        String a = "";
        a = this.getStagingDependencyFile(language);
        return a;
    }

    public String getStagingDependencyFile(String language) {
        switch (language) {
            case "R": {
                return this.configuration.getSVNStagingCRANDepsList();
            }
            case "R-blackbox": {
                return this.configuration.getSVNStagingRBDepsList();
            }
            case "Java": {
                return this.configuration.getSVNStagingJavaDepsList();
            }
            case "Knime-Workflow": {
                return this.configuration.getSVNStagingKWDepsList();
            }
            case "Linux-compiled": {
                return this.configuration.getSVNStagingLinuxCompiledDepsList();
            }
            case "Octave": {
                return this.configuration.getSVNStagingOctaveDepsList();
            }
            case "Python": {
                return this.configuration.getSVNStagingPythonDepsList();
            }
            case "Pre-Installed": {
                return this.configuration.getSVNStagingPreInstalledDepsList();
            }
            case "Windows-compiled": {
                return this.configuration.getSVNStagingWCDepsList();
            }
        }
        return null;
    }

    public void updateSVNStagingAlgorithmList(Algorithm algorithm, String targetVRE, String category, String algorithm_type, String user) {
        this.updateSVNAlgorithmList(this.configuration.getSVNStagingAlgorithmsList(), algorithm, targetVRE, category, algorithm_type, user);
    }

    public void updateSVNProdAlgorithmList(Algorithm algorithm, String targetVRE, String category, String algorithm_type, String user) {
        this.updateSVNAlgorithmList(this.configuration.getSVNProdAlgorithmsList(), algorithm, targetVRE, category, algorithm_type, user);
    }

    public void updateAlgorithmFiles(File a) throws SVNException {
        this.updateAlgorithmList(this.configuration.getStageRepository(), a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAlgorithmList(String svnMainAlgoRepo, File a) throws SVNException {
        try {
            System.out.println("Adding .jar file: " + a + " to repository " + svnMainAlgoRepo);
            if (this.fileExists(svnMainAlgoRepo + File.separator + a.getName(), -1L)) {
                this.updateFile(SVNUpdater.reteriveByteArrayInputStream((File)a), svnMainAlgoRepo, a.getName());
            } else {
                this.putFile(SVNUpdater.reteriveByteArrayInputStream((File)a), svnMainAlgoRepo, a.getName());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.svnRepository.closeSession();
        }
    }

    public void putFile(ByteArrayInputStream byteArrayInputStream, String destinationFolder, String fileName) throws SVNException {
        ISVNEditor commitEditor = this.svnRepository.getCommitEditor("Add algorithm to list", null);
        commitEditor.openRoot(-1L);
        commitEditor.openDir(destinationFolder, -1L);
        String filePath = destinationFolder + "/" + fileName;
        commitEditor.addFile(filePath, null, -1L);
        commitEditor.applyTextDelta(filePath, null);
        SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
        String checksum = deltaGenerator.sendDelta(filePath, (InputStream)byteArrayInputStream, (ISVNDeltaConsumer)commitEditor, true);
        commitEditor.closeFile(filePath, checksum);
        commitEditor.closeDir();
        commitEditor.closeDir();
        commitEditor.closeEdit();
    }

    public void updateFile(ByteArrayInputStream byteArrayInputStream, String destinationFolder, String fileName) throws SVNException {
        ISVNEditor commitEditor = this.svnRepository.getCommitEditor("Add algorithm to list", null);
        commitEditor.openRoot(-1L);
        commitEditor.openDir(destinationFolder, -1L);
        String filePath = destinationFolder + "/" + fileName;
        commitEditor.openFile(filePath, -1L);
        commitEditor.applyTextDelta(filePath, null);
        SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
        String checksum = deltaGenerator.sendDelta(filePath, (InputStream)byteArrayInputStream, (ISVNDeltaConsumer)commitEditor, true);
        commitEditor.closeFile(filePath, checksum);
        commitEditor.closeDir();
        commitEditor.closeDir();
        commitEditor.closeEdit();
    }

    public boolean fileExists(String path, long revision) throws SVNException {
        SVNNodeKind kind = this.svnRepository.checkPath(path, revision);
        return kind == SVNNodeKind.FILE;
    }

    public static ByteArrayInputStream reteriveByteArrayInputStream(File file) throws IOException {
        return new ByteArrayInputStream(FileUtils.readFileToByteArray((File)file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSVNAlgorithmList(String file, Algorithm algorithm, String targetVRE, String category, String algorithm_type, String user) {
        try {
            System.out.println("Updating algorithm list: " + file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.svnRepository.getFile(file, -1L, null, (OutputStream)byteArrayOutputStream);
            String[] lines = byteArrayOutputStream.toString().split("\\r?\\n");
            LinkedList<String> newContent = new LinkedList<String>(Arrays.asList(lines));
            for (String l : lines) {
                if (!l.contains(algorithm.getClazz())) continue;
                newContent.remove(l);
            }
            newContent.add(this.generateAlgorithmEntry(algorithm, targetVRE, category, algorithm_type));
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            byte[] originalContents = byteArrayOutputStream.toByteArray();
            ISVNEditor commitEditor = this.svnRepository.getCommitEditor("update algorithm list", null);
            commitEditor.openRoot(-1L);
            commitEditor.openFile(file, -1L);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String line : newContent) {
                baos.write(line.getBytes());
                baos.write("\n".getBytes());
            }
            byte[] bytes = baos.toByteArray();
            commitEditor.applyTextDelta(file, SVNUpdater.md5((byte[])originalContents));
            String checksum = deltaGenerator.sendDelta(file, (InputStream)new ByteArrayInputStream(originalContents), 0L, (InputStream)new ByteArrayInputStream(bytes), (ISVNDeltaConsumer)commitEditor, true);
            commitEditor.closeFile(file, checksum);
            commitEditor.closeEdit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.svnRepository.closeSession();
        }
    }

    public String generateAlgorithmEntry(Algorithm algorithm, String targetVRE, String category, String algorithm_type) throws ParseException {
        StringBuffer sb = new StringBuffer("| ");
        sb.append(algorithm.getName() + " | ");
        sb.append(algorithm.getFullname() + " | ");
        sb.append(category + " | ");
        sb.append("DataMinerPoolManager | ");
        sb.append("<notextile>./addAlgorithm.sh " + algorithm.getName() + " " + algorithm.getCategory() + " " + algorithm.getClazz() + " " + targetVRE + " " + algorithm_type + " N " + algorithm.getPackageURL() + " \"" + algorithm.getDescription() + "\" </notextile> | ");
        sb.append("none | ");
        sb.append(this.getTimeZone() + " | ");
        return sb.toString();
    }

    public Collection<String> getUndefinedDependencies(String file, Collection<Dependency> deps) throws SVNException {
        LinkedList<String> undefined = new LinkedList<String>();
        if (file.isEmpty()) {
            return undefined;
        }
        System.out.println("Checking dependencies list: " + file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.svnRepository.getFile(file, -1L, null, (OutputStream)byteArrayOutputStream);
        LinkedList<String> validDependencies = new LinkedList<String>();
        for (String l : byteArrayOutputStream.toString().split("\\r?\\n")) {
            validDependencies.add(l.trim());
        }
        for (Dependency d : deps) {
            String depName = d.getName();
            if (validDependencies.contains(depName)) continue;
            undefined.add(depName);
        }
        return undefined;
    }

    public boolean checkIfAvaialable(String file, Collection<Dependency> deps) throws SVNException {
        SendMail sm = new SendMail();
        NotificationHelper nh = new NotificationHelper();
        boolean check = false;
        try {
            System.out.println("Checking dependencies list: " + file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.svnRepository.getFile(file, -1L, null, (OutputStream)byteArrayOutputStream);
            String[] lines = byteArrayOutputStream.toString().split("\\r?\\n");
            LinkedList<String> ldep = new LinkedList<String>();
            for (Dependency d : deps) {
                ldep.add(d.getName());
            }
            for (String a : lines) {
                for (String b : ldep) {
                    if (b.equals(a)) {
                        System.out.println("The following dependency is correctly written: " + b);
                        check = true;
                        continue;
                    }
                    check = false;
                }
            }
        }
        catch (Exception a) {
            a.getMessage();
        }
        return check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSVN(String file, Collection<Dependency> deps) {
        try {
            System.out.println("Updating dependencies list: " + file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.svnRepository.getFile(file, -1L, null, (OutputStream)byteArrayOutputStream);
            String[] lines = byteArrayOutputStream.toString().split("\\r?\\n");
            LinkedList<String> ldep = new LinkedList<String>();
            for (Dependency d : deps) {
                ldep.add(d.getName());
            }
            List aa = this.checkMatch(lines, ldep);
            Collections.sort(aa);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            byte[] originalContents = byteArrayOutputStream.toByteArray();
            ISVNEditor commitEditor = this.svnRepository.getCommitEditor("update dependencies", null);
            commitEditor.openRoot(-1L);
            commitEditor.openFile(file, -1L);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String line : aa) {
                baos.write(line.getBytes());
                baos.write("\n".getBytes());
            }
            byte[] bytes = baos.toByteArray();
            commitEditor.applyTextDelta(file, SVNUpdater.md5((byte[])originalContents));
            String checksum = deltaGenerator.sendDelta(file, (InputStream)new ByteArrayInputStream(originalContents), 0L, (InputStream)new ByteArrayInputStream(bytes), (ISVNDeltaConsumer)commitEditor, true);
            commitEditor.closeFile(file, checksum);
            commitEditor.closeEdit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.svnRepository.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5(byte[] contents) {
        byte[] tmp = new byte[1024];
        SVNChecksumInputStream checksumStream = new SVNChecksumInputStream((InputStream)new ByteArrayInputStream(contents), "md5");
        try {
            while (checksumStream.read(tmp) > 0) {
            }
            String string = checksumStream.getDigest();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            SVNFileUtil.closeFile((InputStream)checksumStream);
        }
    }

    public List<String> checkMatch(String[] lines, List<String> ls) {
        HashSet<String> ss = new HashSet<String>(ls);
        ss.addAll(Arrays.asList(lines));
        return new ArrayList<String>(ss);
    }

    public String getTimeZone() throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        Date fromDate = formatter.parse(cal.getTime().toString());
        TimeZone central = TimeZone.getTimeZone("UTC");
        formatter.setTimeZone(central);
        System.out.println(formatter.format(fromDate));
        return formatter.format(fromDate);
    }

    public static void main(String[] args) throws SVNException, ParseException {
        ServiceConfiguration sc = new ServiceConfiguration("/home/ngalante/workspace/dataminer-pool-manager/src/main/resources/service.properties");
        SVNUpdater c = new SVNUpdater(sc);
        Calendar cal = Calendar.getInstance();
        cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        Date fromDate = formatter.parse(cal.getTime().toString());
        TimeZone central = TimeZone.getTimeZone("UTC");
        formatter.setTimeZone(central);
        System.out.println(formatter.format(fromDate));
    }
}

