package org.gcube.dataaccess.ckanutillibrary;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Use this factory to retrieve an utility class instance associated to a particular scope.
 * NOTE: YOU ARE SUGGESTED TO USE THIS CLASS, DO NOT INSTANCIATE THE CkanUtils object directly.
 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
 */
public class CKanUtilsFactory {

	/**
	 * logger
	 */
	private static final Logger logger = LoggerFactory.getLogger(CKanUtilsFactory.class);

	/**
	 *  map <scope, util class for this scope>
	 */
	private static Map<String, CKanUtilsImpl> instanceForScopes;

	/**
	 *  this object singleton instance
	 */
	private static CKanUtilsFactory factoryInstance = new CKanUtilsFactory();

	/**
	 * private constructor
	 */
	private CKanUtilsFactory(){
		
		logger.debug("Instanciating factory");
		instanceForScopes = new HashMap<String, CKanUtilsImpl>();

	}

	/**
	 * Get the factory object
	 */
	public static CKanUtilsFactory getInstance(){

		return factoryInstance;

	}

	/**
	 * Retrieve catalogue utils class for this scope
	 * @param scope
	 * @throws Exception 
	 */
	public CKanUtilsImpl getCkanUtilsForScope(String scope) throws Exception{
		
		logger.debug("Requested catalogue utils for scope " + scope);

		synchronized (instanceForScopes) {

			if(instanceForScopes.containsKey(scope)){
				
				logger.debug("Catalogue utils already cached, returning object");
				return instanceForScopes.get(scope);
				
			}
			else{

				logger.debug("Instanciating utils for this scope");
				CKanUtilsImpl utilsForScope = new CKanUtilsImpl("/gcube");
				
				// save into the map
				instanceForScopes.put(scope, utilsForScope);
				
				return utilsForScope;

			}
		}
	}
}
