/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.algorithms.drmalgorithms;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.access.DatabasesDiscoverer;
import org.gcube.dataaccess.databases.resources.DBResource;
import org.gcube.dataaccess.databases.utils.DatabaseManagement;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.resources.discovery.client.api.DiscoveryException;
import org.gcube.resources.discovery.client.api.InvalidResultException;
import org.hibernate.HibernateException;

public class RandomSampleOnTable
extends StandardLocalInfraAlgorithm {
    private LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    private DatabaseManagement mgt;
    private String resourceName = null;
    private String databaseName = null;
    private String schemaName = null;
    private String tableName = null;
    private String driverInfo;

    public void init() throws Exception {
        this.mgt = new DatabaseManagement(this.config.getConfigPath());
        AnalysisLogger.getLogger().debug((Object)"In RandomSmartSampleOnTable->Initialization");
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("In RandomSmartSampleOnTable->scope set by config object: " + scope));
    }

    public String getDescription() {
        return "Algorithm that allows to perform a sample operation on a table randomly";
    }

    protected void process() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"In RandomSmartSampleOnTable->Processing");
        try {
            List<String> Info = this.retrieveInfo();
            this.tableName = this.getInputParameter("TableName");
            if (this.tableName != null) {
                this.tableName = this.getInputParameter("TableName").trim();
            }
            if (this.tableName == null || this.tableName.equals("")) {
                throw new Exception("Warning: insert the table name");
            }
            if (this.driverInfo.toLowerCase().contains("postgres")) {
                this.schemaName = this.getInputParameter("SchemaName");
                if (this.schemaName != null) {
                    this.schemaName = this.getInputParameter("SchemaName").trim();
                }
                if (this.schemaName == null || this.schemaName.equals("")) {
                    throw new Exception("Warning: insert the schema name");
                }
            }
            this.getConnection(Info);
            this.map = this.randomSampleOnTable();
        }
        catch (HibernateException h) {
            AnalysisLogger.getLogger().debug((Object)("In RandomSmartSampleOnTable-> ERROR " + h.getMessage()));
            throw h;
        }
        catch (IllegalStateException e) {
            AnalysisLogger.getLogger().debug((Object)("In RandomSmartSampleOnTable-> ERROR " + e.getMessage()));
            throw e;
        }
        catch (DiscoveryException e1) {
            AnalysisLogger.getLogger().debug((Object)("In RandomSmartSampleOnTable-> ERROR " + e1.getMessage()));
            throw e1;
        }
        catch (InvalidResultException e2) {
            AnalysisLogger.getLogger().debug((Object)("In RandomSmartSampleOnTable-> ERROR " + e2.getMessage()));
            throw e2;
        }
        catch (IOException e3) {
            AnalysisLogger.getLogger().debug((Object)("In RandomSmartSampleOnTable-> ERROR " + e3.getMessage()));
            throw e3;
        }
        catch (Exception e4) {
            AnalysisLogger.getLogger().debug((Object)("In RandomSmartSampleOnTable-> Exception " + e4.getMessage()));
            throw e4;
        }
        finally {
            this.mgt.closeConnection();
        }
    }

    protected void setInputParameters() {
        this.addStringInput("ResourceName", "The name of the resource", "");
        this.addStringInput("DatabaseName", "The name of the database", "");
        this.addStringInput("SchemaName", "The name of the schema", "");
        this.addStringInput("TableName", "The name of the table", "");
    }

    public StatisticalType getOutput() {
        AnalysisLogger.getLogger().debug((Object)"In RandomSampleOnTable->retrieving outputs");
        PrimitiveType output = new PrimitiveType(LinkedHashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap" + UUID.randomUUID(), "Results Map");
        return output;
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"In RandomSampleOnTable->Shutdown");
    }

    private List<String> retrieveInfo() throws Exception, IllegalStateException, DiscoveryException, InvalidResultException {
        this.resourceName = this.getInputParameter("ResourceName");
        if (this.resourceName != null) {
            this.resourceName = this.getInputParameter("ResourceName").trim();
        }
        if (this.resourceName == null || this.resourceName.equals("")) {
            throw new Exception("Warning: insert the resource name");
        }
        this.databaseName = this.getInputParameter("DatabaseName");
        if (this.databaseName != null) {
            this.databaseName = this.getInputParameter("DatabaseName").trim();
        }
        if (this.databaseName == null || this.databaseName.equals("")) {
            throw new Exception("Warning: insert the database name");
        }
        DatabasesDiscoverer discovery = new DatabasesDiscoverer();
        List resources = discovery.discover();
        AnalysisLogger.getLogger().debug((Object)("In RandomSampleOnTable->number of elements: " + resources.size()));
        ArrayList<String> info = new ArrayList<String>();
        block0: for (int i = 0; i < resources.size(); ++i) {
            if (!((DBResource)resources.get(i)).getResourceName().toLowerCase().equals(this.resourceName.toLowerCase())) continue;
            this.normalizeDBInfo((DBResource)resources.get(i));
            for (int j = 0; j < ((DBResource)resources.get(i)).getAccessPoints().size(); ++j) {
                if (!((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDatabaseName().toLowerCase().equals(this.databaseName.toLowerCase())) continue;
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getUsername());
                AnalysisLogger.getLogger().debug((Object)("In RandomSampleOnTable->username: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getUsername()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getPassword());
                AnalysisLogger.getLogger().debug((Object)("In RandomSampleOnTable->password: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getPassword()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver());
                this.driverInfo = ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver();
                AnalysisLogger.getLogger().debug((Object)("In RandomSampleOnTable->driver: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDialect());
                AnalysisLogger.getLogger().debug((Object)("In RandomSampleOnTable->dialect: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDialect()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).address());
                AnalysisLogger.getLogger().debug((Object)("In RandomSampleOnTable->url: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).address()));
                info.add(this.databaseName);
                AnalysisLogger.getLogger().debug((Object)("In RandomSampleOnTable->databasename: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDatabaseName()));
                break block0;
            }
        }
        AnalysisLogger.getLogger().debug((Object)"In RandomSampleOnTable->information useful for connection: retrieved");
        return info;
    }

    private void normalizeDBInfo(DBResource resource) throws Exception {
        try {
            int ap = resource.getAccessPoints().size();
            for (int i = 0; i < ap; ++i) {
                resource.normalize(i);
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("In RandomSampleOnTable->: Error in normalization process" + e.getMessage()));
            throw e;
        }
    }

    private void getConnection(List<String> Info) throws IOException {
        Iterator<String> iterator = Info.iterator();
        String DatabaseUserName = iterator.next();
        String DatabasePassword = iterator.next();
        String DatabaseDriver = iterator.next();
        String DatabaseDialect = iterator.next();
        String DatabaseURL = iterator.next();
        String DatabaseName = iterator.next();
        this.mgt.createConnection(DatabaseUserName, DatabasePassword, DatabaseDriver, DatabaseDialect, DatabaseURL, DatabaseName);
        AnalysisLogger.getLogger().debug((Object)("In RandomSampleOnTable->database " + DatabaseName + ": connected"));
    }

    private LinkedHashMap<String, StatisticalType> randomSampleOnTable() throws Exception {
        LinkedHashMap<String, StatisticalType> mapResults = new LinkedHashMap<String, StatisticalType>();
        AnalysisLogger.getLogger().debug((Object)"In RandomSampleOnTable->starting the sample operation on table randomly");
        if (this.driverInfo.toLowerCase().contains("postgres")) {
            this.mgt.randomSampleOnTable(this.tableName, this.schemaName, this.config.getPersistencePath());
        }
        if (this.driverInfo.toLowerCase().contains("mysql")) {
            this.mgt.randomSampleOnTable(this.tableName, this.databaseName, this.config.getPersistencePath());
        }
        AnalysisLogger.getLogger().debug((Object)"In RandomSampleOnTable->result retrieved");
        HashMap mapResult = new HashMap();
        mapResult = this.mgt.getMapSampleTableResult();
        String encoded = null;
        encoded = new String(((String)mapResult.get("HEADERS")).getBytes(), "UTF-8");
        PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)encoded, PrimitiveTypes.STRING, "Row Header", "Row Header");
        mapResults.put("HEADERS", (StatisticalType)val);
        for (int i = 0; i < mapResult.size() - 1; ++i) {
            encoded = new String(((String)mapResult.get(String.valueOf(i))).getBytes(), "UTF-8");
            String row = "Row " + Integer.toString(i + 1);
            PrimitiveType val1 = new PrimitiveType(String.class.getName(), (Object)encoded, PrimitiveTypes.STRING, row, row);
            mapResults.put(String.valueOf(i), (StatisticalType)val1);
        }
        PrimitiveType fileResult = new PrimitiveType(File.class.getName(), (Object)this.mgt.getFile(), PrimitiveTypes.FILE, "File", "File");
        mapResults.put("File", (StatisticalType)fileResult);
        return mapResults;
    }
}

