/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.algorithms.drmalgorithms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.access.DatabasesDiscoverer;
import org.gcube.dataaccess.databases.resources.DBResource;
import org.gcube.dataaccess.databases.utils.DatabaseManagement;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.resources.discovery.client.api.DiscoveryException;
import org.gcube.resources.discovery.client.api.InvalidResultException;
import org.hibernate.HibernateException;

public class ListTables
extends StandardLocalInfraAlgorithm {
    private static final String TABLE_NAME = "Table Name ";
    private LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    private DatabaseManagement mgt;
    private String driverInfo;
    private String resourceName = null;
    private String databaseName = null;
    private String schemaName = null;

    public void init() throws Exception {
        this.mgt = new DatabaseManagement(this.config.getConfigPath());
        AnalysisLogger.getLogger().debug((Object)"In ListTables->Initialization");
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("In ListTables->scope set by config object: " + scope));
    }

    public String getDescription() {
        return "Algorithm that allows to view the table names of a chosen database";
    }

    protected void process() throws Exception, IOException, IllegalStateException, DiscoveryException, InvalidResultException, HibernateException {
        AnalysisLogger.getLogger().debug((Object)"In ListTables->Processing");
        try {
            List<String> Info = this.retrieveInfo();
            this.getConnection(Info);
            List listTables = new ArrayList();
            if (this.driverInfo.toLowerCase().contains("postgres")) {
                this.schemaName = this.getInputParameter("SchemaName");
                if (this.schemaName != null) {
                    this.schemaName = this.getInputParameter("SchemaName").trim();
                }
                if (this.schemaName == null || this.schemaName.equals("")) {
                    throw new Exception("Warning: insert the schema name");
                }
                listTables = this.mgt.getTables(this.databaseName, this.schemaName);
                AnalysisLogger.getLogger().debug((Object)"In ListTables->getting table's name for database postgres");
            }
            if (this.driverInfo.toLowerCase().contains("mysql")) {
                listTables = this.mgt.getTables(this.databaseName, null);
                AnalysisLogger.getLogger().debug((Object)"In ListTables->getting table's name for database mysql");
            }
            if (listTables == null) {
                AnalysisLogger.getLogger().debug((Object)"In ListTables->Warning: no tables available");
            } else {
                for (int i = 0; i < listTables.size(); ++i) {
                    String tableId = TABLE_NAME + (i + 1);
                    PrimitiveType val = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, tableId, tableId);
                    val.setContent(listTables.get(i));
                    this.map.put(tableId, (StatisticalType)val);
                }
            }
        }
        catch (HibernateException h) {
            AnalysisLogger.getLogger().debug((Object)("In ListTables-> ERROR " + h.getMessage()));
            throw h;
        }
        catch (IllegalStateException e) {
            AnalysisLogger.getLogger().debug((Object)("In ListTables-> ERROR " + e.getMessage()));
            throw e;
        }
        catch (DiscoveryException e1) {
            AnalysisLogger.getLogger().debug((Object)("In ListTables-> ERROR " + e1.getMessage()));
            throw e1;
        }
        catch (InvalidResultException e2) {
            AnalysisLogger.getLogger().debug((Object)("In ListTables-> ERROR " + e2.getMessage()));
            throw e2;
        }
        catch (IOException e3) {
            AnalysisLogger.getLogger().debug((Object)("In ListTables-> Exception " + e3.getMessage()));
            throw e3;
        }
        catch (Exception e4) {
            AnalysisLogger.getLogger().debug((Object)("In ListTables-> Exception " + e4.getMessage()));
            throw e4;
        }
        finally {
            this.mgt.closeConnection();
        }
    }

    protected void setInputParameters() {
        this.addStringInput("ResourceName", "The name of the resource", "");
        this.addStringInput("DatabaseName", "The name of the database", "");
        this.addStringInput("SchemaName", "The name of the schema", "");
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"In ListTables->Shutdown");
    }

    public StatisticalType getOutput() {
        AnalysisLogger.getLogger().debug((Object)"In ListTables->retrieving outputs");
        PrimitiveType output = new PrimitiveType(LinkedHashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap" + UUID.randomUUID(), "Results Map");
        return output;
    }

    private List<String> retrieveInfo() throws Exception, IllegalStateException, DiscoveryException, InvalidResultException {
        this.resourceName = this.getInputParameter("ResourceName");
        if (this.resourceName != null) {
            this.resourceName = this.getInputParameter("ResourceName").trim();
        }
        if (this.resourceName == null || this.resourceName.equals("")) {
            throw new Exception("Warning: insert the resource name");
        }
        this.databaseName = this.getInputParameter("DatabaseName");
        if (this.databaseName != null) {
            this.databaseName = this.getInputParameter("DatabaseName").trim();
        }
        if (this.databaseName == null || this.databaseName.equals("")) {
            throw new Exception("Warning: insert the database name");
        }
        DatabasesDiscoverer discovery = new DatabasesDiscoverer();
        List resources = discovery.discover();
        AnalysisLogger.getLogger().debug((Object)("In ListTables->number of database resources: " + resources.size()));
        for (int i = 0; i < resources.size(); ++i) {
            AnalysisLogger.getLogger().debug((Object)("In ListTables->Resource's name: " + ((DBResource)resources.get(i)).getResourceName()));
        }
        ArrayList<String> info = new ArrayList<String>();
        block1: for (int i = 0; i < resources.size(); ++i) {
            if (!((DBResource)resources.get(i)).getResourceName().toLowerCase().equals(this.resourceName.toLowerCase())) continue;
            this.normalizeDBInfo((DBResource)resources.get(i));
            for (int j = 0; j < ((DBResource)resources.get(i)).getAccessPoints().size(); ++j) {
                if (!((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDatabaseName().toLowerCase().equals(this.databaseName.toLowerCase())) continue;
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getUsername());
                AnalysisLogger.getLogger().debug((Object)("In ListTables->username: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getUsername()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getPassword());
                AnalysisLogger.getLogger().debug((Object)("In ListTables->password: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getPassword()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver());
                this.driverInfo = ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver();
                AnalysisLogger.getLogger().debug((Object)("In ListTables->driver: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDriver()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDialect());
                AnalysisLogger.getLogger().debug((Object)("In ListTables->dialect: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDialect()));
                info.add(((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).address());
                AnalysisLogger.getLogger().debug((Object)("In ListTables->url: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).address()));
                info.add(this.databaseName);
                AnalysisLogger.getLogger().debug((Object)("In ListTables->databasename: " + ((DBResource.AccessPoint)((DBResource)resources.get(i)).getAccessPoints().get(j)).getDatabaseName()));
                break block1;
            }
        }
        AnalysisLogger.getLogger().debug((Object)"In ListTables->information useful for connection: retrieved");
        return info;
    }

    private void getConnection(List<String> Info) throws IOException {
        Iterator<String> iterator = Info.iterator();
        String DatabaseUserName = iterator.next();
        String DatabasePassword = iterator.next();
        String DatabaseDriver = iterator.next();
        String DatabaseDialect = iterator.next();
        String DatabaseURL = iterator.next();
        String DatabaseName = iterator.next();
        this.mgt.createConnection(DatabaseUserName, DatabasePassword, DatabaseDriver, DatabaseDialect, DatabaseURL, DatabaseName);
        AnalysisLogger.getLogger().debug((Object)("In ListTables->database " + DatabaseName + ": connected"));
    }

    private void normalizeDBInfo(DBResource resource) throws Exception {
        try {
            int ap = resource.getAccessPoints().size();
            for (int i = 0; i < ap; ++i) {
                resource.normalize(i);
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("In ListTables->: Error in normalization process" + e.getMessage()));
            throw e;
        }
    }
}

