/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.utils;

import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.parser.ParseException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataaccess.databases.converter.SqlDialectConverter;
import org.gcube.dataaccess.databases.sampler.Sampler;
import org.gcube.dataaccess.databases.structure.AbstractTableStructure;
import org.gcube.dataaccess.databases.structure.MySQLTableStructure;
import org.gcube.dataaccess.databases.structure.PostgresTableStructure;
import org.gcube.dataaccess.databases.utils.ConnectionManager;
import org.gcube.dataaccess.databases.utils.DatabaseOperations;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.hibernate.SessionFactory;

public class DatabaseManagement {
    private List<String> tablesname = null;
    private String configPath = "";
    private String sourceSchemaName = null;
    private SessionFactory sourceDBSession;
    private String DBType;
    private AbstractTableStructure crossTableStructure;
    private DatabaseOperations op = new DatabaseOperations();
    private MySQLTableStructure mysqlobj;
    private ConnectionManager connection;
    private long estimatedRows = 0L;
    private File file = null;
    private BufferedWriter out;
    private HashMap<String, String> mapResult = new HashMap();
    private static final String MYSQL = "MySQL";
    private static final String POSTGRES = "Postgres";
    private static final String selectTablesQuery = "SELECT  distinct  table_name FROM information_schema.COLUMNS where table_schema='%1$s'";
    private static final String listSchemaNameQuery = "select nspname from pg_namespace where nspname <> 'information_schema' and nspname !~ E'^pg_'";
    private static final String queryForDataTypeColumnsPostgres = "SELECT data_type, udt_name FROM information_schema.COLUMNS WHERE table_name ='%1$s' and table_schema='%2$s' order by ordinal_position asc";
    private static final String queryForDataTypeColumnsMysql = "SELECT data_type FROM information_schema.COLUMNS WHERE table_name ='%1$s' and table_schema='%2$s' order by ordinal_position asc";
    private static final String queryForColumnsPostgres = "SELECT column_name FROM information_schema.COLUMNS WHERE table_name ='%1$s' and table_schema='%2$s' order by ordinal_position asc";
    private static final String queryForColumnsMysql = "SELECT column_name FROM information_schema.COLUMNS WHERE table_name ='%1$s' and table_schema='%2$s' order by ordinal_position asc";
    private String header = "";
    List<String> listColumnNamesTable = null;
    public static final int POSTGRESQLDialect = 4;
    public static final int MYSQLDialect = 5;

    public DatabaseManagement(String configPath) {
        this.configPath = configPath;
        this.connection = new ConnectionManager();
    }

    private String convertToJavaType(String type, String val) throws Exception {
        type = type.toLowerCase();
        String valConverted = val;
        try {
            valConverted = "" + Long.parseLong(valConverted);
        }
        catch (Exception e) {
            if (type != null) {
                if (type.contains("decimal") || type.contains("double") || type.contains("numeric") || type.contains("float")) {
                    valConverted = "" + Double.parseDouble(valConverted);
                }
                if (type.contains("real")) {
                    valConverted = "" + Float.parseFloat(valConverted);
                }
                if (type.contains("string") || type.contains("varchar") || type.contains("char") || type.contains("text") || type.contains("character varying")) {
                    valConverted = "\"" + valConverted + "\"";
                }
                if (type.contains("geometry") || type.contains("geography")) {
                    valConverted = "\"" + valConverted + "\"";
                }
            }
        }
        return valConverted;
    }

    public SessionFactory createConnection(String DatabaseUserName, String DatabasePassword, String DatabaseDriver, String DatabaseDialect, String DatabaseURL, String DatabaseName) throws IOException {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement->DatabaseName: " + DatabaseName));
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement->DatabaseURL: " + DatabaseURL));
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement->DatabaseUserName: " + DatabaseUserName));
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement->DatabasePassword: " + DatabasePassword));
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement->configPath: " + this.configPath));
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement->DatabaseDriver: " + DatabaseDriver));
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement->DatabaseDialect: " + DatabaseDialect));
        config = this.connection.setconfiguration(this.configPath, DatabaseUserName, DatabasePassword, DatabaseDriver, DatabaseDialect, DatabaseURL, DatabaseName);
        this.sourceDBSession = this.connection.initDBConnection(config);
        if (DatabaseDriver.toLowerCase().contains("postgres")) {
            this.DBType = POSTGRES;
        }
        if (DatabaseDriver.toLowerCase().contains("mysql")) {
            this.DBType = MYSQL;
        }
        return this.sourceDBSession;
    }

    public SessionFactory createConnection(String cfgDir, String SourceFile) throws Exception {
        this.configPath = cfgDir;
        if (!this.configPath.endsWith("/")) {
            this.configPath = this.configPath + "/";
        }
        this.sourceSchemaName = this.op.getDBSchema(this.configPath + SourceFile);
        this.sourceDBSession = this.connection.initDBConnection(this.configPath + SourceFile);
        this.DBType = this.op.getDBType();
        return this.sourceDBSession;
    }

    public void closeConnection() {
        if (this.sourceDBSession != null) {
            this.sourceDBSession.close();
            AnalysisLogger.getLogger().debug((Object)"In DatabaseManagement->Connection closed");
            this.sourceDBSession = null;
        }
    }

    public List<Object> submitQuery(String query, Connection conn, String pathFile) throws Exception {
        List<Object> results = new ArrayList();
        results = this.connection.executeQueryJDBC(query, conn);
        if (results != null) {
            AnalysisLogger.getLogger().debug((Object)"DatabaseManagement-> Query result retrieved");
        }
        List<String> DataTypeColumns = null;
        String FileName = pathFile + "SubmitQueryResult_" + UUID.randomUUID() + ".csv";
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement-> writing the result in the file: " + FileName));
        try {
            this.file = new File(FileName);
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));
            this.writeSubmitResultIntoFile(results, DataTypeColumns);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (this.out != null) {
                this.out.close();
                this.out = null;
                AnalysisLogger.getLogger().debug((Object)"In DatabaseManagement-> File closed");
            }
        }
        return results;
    }

    public List<String> getTables(String databaseName, String schemaName) throws Exception {
        List<Object> resultSet;
        String query = null;
        if (this.DBType.equals(POSTGRES)) {
            query = String.format(selectTablesQuery, schemaName);
            AnalysisLogger.getLogger().debug((Object)("DatabaseManagement->retrieving tables names with query: " + query));
            this.sourceSchemaName = schemaName;
        }
        if (this.DBType.equals(MYSQL)) {
            query = String.format(selectTablesQuery, databaseName);
            AnalysisLogger.getLogger().debug((Object)("DatabaseManagement->retrieving tables names with query: " + query));
            this.sourceSchemaName = databaseName;
        }
        if ((resultSet = this.connection.executeQuery(query, this.sourceDBSession)) != null) {
            AnalysisLogger.getLogger().debug((Object)"DatabaseManagement->table's list retrieved");
            this.tablesname = new ArrayList<String>();
            for (int i = 0; i < resultSet.size(); ++i) {
                Object element = resultSet.get(i);
                ArrayList listvalues = new ArrayList(((LinkedHashMap)element).values());
                for (int j = 0; j < listvalues.size(); ++j) {
                    this.tablesname.add(listvalues.get(j).toString());
                }
            }
        }
        return this.tablesname;
    }

    public List<String> getSchemas() throws Exception {
        List<Object> resultSet;
        ArrayList<String> list = new ArrayList<String>();
        if (this.DBType.equals(POSTGRES) && (resultSet = this.connection.executeQuery(listSchemaNameQuery, this.sourceDBSession)) != null) {
            for (int i = 0; i < resultSet.size(); ++i) {
                Object element = resultSet.get(i);
                ArrayList listvalues = new ArrayList(((LinkedHashMap)element).values());
                for (int j = 0; j < listvalues.size(); ++j) {
                    list.add(listvalues.get(j).toString());
                }
            }
        }
        return list;
    }

    public String getCreateTable(String tablename, String schemaName) throws Exception {
        String createstatement = "";
        if (this.DBType.equals(POSTGRES)) {
            String tableBuildQuery;
            this.crossTableStructure = this.getSourceTableObject(tablename, schemaName);
            createstatement = tableBuildQuery = this.crossTableStructure.buildUpCreateTable();
            AnalysisLogger.getLogger().debug((Object)("DatabaseManagement->'Create Table' statement: " + tableBuildQuery));
        }
        if (this.DBType.equals(MYSQL)) {
            this.crossTableStructure = this.getSourceTableObject(tablename, schemaName);
            try {
                String createtablestatement;
                createstatement = createtablestatement = this.mysqlobj.showCreateTable(this.connection, this.sourceDBSession);
                AnalysisLogger.getLogger().debug((Object)("DatabaseManagement->'Create Table' statement: " + createtablestatement));
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("DatabaseManagement->Exception: " + e.getMessage()));
                throw e;
            }
        }
        this.getColumnNamesTable(tablename, schemaName);
        return createstatement;
    }

    private AbstractTableStructure getSourceTableObject(String tableName, String schemaName) throws Exception {
        this.sourceSchemaName = schemaName;
        if (this.DBType.equals(MYSQL)) {
            this.mysqlobj = new MySQLTableStructure(this.sourceSchemaName, tableName, this.sourceDBSession);
            return this.mysqlobj;
        }
        if (this.DBType.equals(POSTGRES)) {
            PostgresTableStructure postobj = new PostgresTableStructure(this.sourceSchemaName, tableName, this.sourceDBSession);
            return postobj;
        }
        return null;
    }

    public long getNumberOfRows(String tablename, String schemaName) throws Exception {
        long rows = this.op.calculateElements(this.connection, this.DBType, tablename, schemaName, this.sourceDBSession);
        AnalysisLogger.getLogger().debug((Object)("DatabaseManagement->rows' number calculated: " + rows));
        this.estimatedRows = rows;
        return rows;
    }

    public void smartSampleOnTable(String tableName, String schemaName, String pathFile) throws Exception {
        List<String> DataTypeColumns;
        Sampler sampler;
        List<Object> resultSet = null;
        AnalysisLogger.getLogger().debug((Object)"DatabaseManagement->starting the Smart Sample on table operation");
        AnalysisLogger.getLogger().debug((Object)"DatabaseManagement->retrieving the 100 rows");
        if (this.estimatedRows == 0L) {
            this.estimatedRows = this.getNumberOfRows(tableName, schemaName);
        }
        if ((resultSet = (sampler = new Sampler()).smartSampleOnTable(this.connection, this.sourceDBSession, this.DBType, tableName, schemaName, this.estimatedRows, DataTypeColumns = this.getDataTypeColumns(tableName, schemaName))) != null) {
            AnalysisLogger.getLogger().debug((Object)"DatabaseManagement-> rows retrieved");
        }
        List<String> listColumns = sampler.getListColumns();
        for (int i = 0; i < listColumns.size(); ++i) {
            this.header = i != listColumns.size() - 1 ? this.header + listColumns.get(i) + "," : this.header + listColumns.get(i);
        }
        String FileName = pathFile + "SmartSampling_" + UUID.randomUUID() + ".csv";
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement-> writing the result in the file: " + FileName));
        try {
            this.file = new File(FileName);
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));
            this.writeSamplingResultIntoFile(resultSet, DataTypeColumns);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (this.out != null) {
                this.out.close();
                this.out = null;
                AnalysisLogger.getLogger().debug((Object)"In DatabaseManagement-> File closed");
            }
        }
    }

    public void sampleOnTable(String tableName, String schemaName, String pathFile) throws Exception {
        List<Object> resultSet = null;
        AnalysisLogger.getLogger().debug((Object)"DatabaseManagement->starting the Sample on table operation");
        AnalysisLogger.getLogger().debug((Object)"DatabaseManagement->retrieving the first 100 rows");
        List<String> DataTypeColumns = this.getDataTypeColumns(tableName, schemaName);
        Sampler sampler = new Sampler();
        resultSet = sampler.sampleOnTable(this.connection, this.sourceDBSession, this.DBType, tableName, schemaName, DataTypeColumns);
        if (resultSet != null) {
            AnalysisLogger.getLogger().debug((Object)"DatabaseManagement-> rows retrieved");
        }
        List<String> listColumns = sampler.getListColumns();
        for (int i = 0; i < listColumns.size(); ++i) {
            this.header = i != listColumns.size() - 1 ? this.header + listColumns.get(i) + ", " : this.header + listColumns.get(i);
        }
        String FileName = pathFile + "Sampling_" + UUID.randomUUID() + ".csv";
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement-> writing the result in the file: " + FileName));
        try {
            this.file = new File(FileName);
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));
            this.writeSamplingResultIntoFile(resultSet, DataTypeColumns);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (this.out != null) {
                this.out.close();
                this.out = null;
                AnalysisLogger.getLogger().debug((Object)"In DatabaseManagement-> File closed");
            }
        }
    }

    public void randomSampleOnTable(String tableName, String schemaName, String pathFile) throws Exception {
        Sampler sampler;
        List<Object> resultSet = null;
        AnalysisLogger.getLogger().debug((Object)"DatabaseManagement->starting the Random Sample on table operation");
        AnalysisLogger.getLogger().debug((Object)"DatabaseManagement->retrieving 100 rows");
        List<String> DataTypeColumns = this.getDataTypeColumns(tableName, schemaName);
        if (this.estimatedRows == 0L) {
            this.estimatedRows = this.getNumberOfRows(tableName, schemaName);
        }
        if ((resultSet = (sampler = new Sampler()).randomSampleOnTable(this.connection, this.sourceDBSession, this.DBType, tableName, schemaName, this.estimatedRows, DataTypeColumns)) != null) {
            AnalysisLogger.getLogger().debug((Object)"DatabaseManagement-> rows retrieved");
        }
        List<String> listColumns = sampler.getListColumns();
        for (int i = 0; i < listColumns.size(); ++i) {
            this.header = i != listColumns.size() - 1 ? this.header + listColumns.get(i) + ", " : this.header + listColumns.get(i);
        }
        String FileName = pathFile + "RandomSampling_" + UUID.randomUUID() + ".csv";
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement-> writing the result in the file: " + FileName));
        try {
            this.file = new File(FileName);
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF-8"));
            this.writeSamplingResultIntoFile(resultSet, DataTypeColumns);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (this.out != null) {
                this.out.close();
                this.out = null;
                AnalysisLogger.getLogger().debug((Object)"In DatabaseManagement-> File closed");
            }
        }
    }

    private void buildMapResult(List<Object> result, List<String> DataTypeColumns) throws Exception {
        if (this.header.equals("")) {
            ArrayList listKeys = new ArrayList(((LinkedHashMap)result.get(0)).keySet());
            for (int i = 0; i < listKeys.size(); ++i) {
                this.header = i != listKeys.size() - 1 ? this.header + (String)listKeys.get(i) + ", " : this.header + (String)listKeys.get(i);
            }
        }
        this.mapResult.put("HEADERS", this.header);
        if (result != null && result.size() != 0) {
            for (int i = 0; i < result.size(); ++i) {
                String RowString = "";
                Object element = result.get(i);
                ArrayList listvalues = new ArrayList(((LinkedHashMap)element).values());
                Object[] row = listvalues.toArray();
                if (row.length < 1) continue;
                for (int j = 0; j < row.length; ++j) {
                    if (row[j] == null) {
                        row[j] = "";
                    }
                    String original = row[j].toString();
                    String parsed = "" + row[j];
                    if (original != "") {
                        parsed = DataTypeColumns == null || DataTypeColumns.size() == 0 ? this.convertToJavaType(row[j].getClass().getName(), parsed) : this.convertToJavaType(DataTypeColumns.get(j), parsed);
                    }
                    if (j != row.length - 1) {
                        RowString = j == 0 ? parsed : RowString + "," + parsed;
                    }
                    if (j != row.length - 1) continue;
                    RowString = row.length == 1 ? parsed : RowString + "," + parsed;
                    this.mapResult.put(String.valueOf(i), RowString);
                }
            }
        }
    }

    private void writeSubmitResultIntoFile(List<Object> result, List<String> DataTypeColumns) throws Exception {
        try {
            if (this.header.equals("")) {
                ArrayList listKeys = new ArrayList(((LinkedHashMap)result.get(0)).keySet());
                for (int i = 0; i < listKeys.size(); ++i) {
                    this.header = i != listKeys.size() - 1 ? this.header + (String)listKeys.get(i) + ", " : this.header + (String)listKeys.get(i);
                }
            }
            this.out.write(this.header);
            this.out.newLine();
            this.mapResult.put("HEADERS", this.header);
            if (result != null && result.size() != 0) {
                for (int i = 0; i < result.size(); ++i) {
                    String RowString = "";
                    Object element = result.get(i);
                    ArrayList listvalues = new ArrayList(((LinkedHashMap)element).values());
                    Object[] row = listvalues.toArray();
                    if (row.length < 1) continue;
                    for (int j = 0; j < row.length; ++j) {
                        String truncVal;
                        if (row[j] == null) {
                            row[j] = "";
                        }
                        String original = row[j].toString();
                        String parsed = "" + row[j];
                        String regex1 = "[\"'`]";
                        String regex2 = "[ \\t\\n\\r\\f\\v]";
                        parsed = parsed.replaceAll(regex1, "").replaceAll(regex2, " ");
                        if (original != "") {
                            parsed = DataTypeColumns == null || DataTypeColumns.size() == 0 ? this.convertToJavaType(row[j].getClass().getName(), parsed) : this.convertToJavaType(DataTypeColumns.get(j), parsed);
                        }
                        if ((truncVal = parsed).length() > 255 && (truncVal = truncVal.substring(0, 255)).startsWith("\"") && !truncVal.endsWith("\"")) {
                            truncVal = truncVal + "\"";
                        }
                        if (j != row.length - 1) {
                            this.out.write(parsed);
                            this.out.write(",");
                            RowString = j == 0 ? truncVal : RowString + "," + truncVal;
                        }
                        if (j != row.length - 1) continue;
                        this.out.write(parsed);
                        this.out.newLine();
                        RowString = row.length == 1 ? truncVal : RowString + "," + truncVal;
                        if (result.size() > 1000) {
                            if (i >= 1000) continue;
                            this.mapResult.put(String.valueOf(i), RowString);
                            continue;
                        }
                        this.mapResult.put(String.valueOf(i), RowString);
                    }
                }
            }
            AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement-> map size without header: " + (this.mapResult.size() - 1)));
            AnalysisLogger.getLogger().debug((Object)"In DatabaseManagement-> Writing File and Result Map creation operations terminated");
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (this.out != null) {
                this.out.close();
                this.out = null;
                AnalysisLogger.getLogger().debug((Object)"In DatabaseManagement-> File closed");
            }
        }
    }

    private void writeSamplingResultIntoFile(List<Object> result, List<String> DataTypeColumns) throws Exception {
        try {
            if (this.header.equals("")) {
                ArrayList listKeys = new ArrayList(((LinkedHashMap)result.get(0)).keySet());
                for (int i = 0; i < listKeys.size(); ++i) {
                    this.header = i != listKeys.size() - 1 ? this.header + (String)listKeys.get(i) + ", " : this.header + (String)listKeys.get(i);
                }
            }
            this.out.write(this.header);
            this.out.newLine();
            this.mapResult.put("HEADERS", this.header);
            if (result != null && result.size() != 0) {
                for (int i = 0; i < result.size(); ++i) {
                    String RowString = "";
                    Object element = result.get(i);
                    ArrayList listvalues = new ArrayList(((LinkedHashMap)element).values());
                    Object[] row = listvalues.toArray();
                    if (row.length < 1) continue;
                    for (int j = 0; j < row.length; ++j) {
                        String truncVal;
                        if (row[j] == null) {
                            row[j] = "";
                        }
                        String original = row[j].toString();
                        String parsed = "" + row[j];
                        if (original != "") {
                            parsed = DataTypeColumns == null || DataTypeColumns.size() == 0 ? this.convertToJavaType(row[j].getClass().getName(), parsed) : this.convertToJavaType(DataTypeColumns.get(j), parsed);
                        }
                        if ((truncVal = parsed).length() > 255 && (truncVal = truncVal.substring(0, 255)).startsWith("\"") && !truncVal.endsWith("\"")) {
                            truncVal = truncVal + "\"";
                        }
                        if (j != row.length - 1) {
                            this.out.write(parsed);
                            this.out.write(",");
                            RowString = j == 0 ? truncVal : RowString + "," + truncVal;
                        }
                        if (j != row.length - 1) continue;
                        this.out.write(parsed);
                        this.out.newLine();
                        RowString = row.length == 1 ? truncVal : RowString + "," + truncVal;
                        this.mapResult.put(String.valueOf(i), RowString);
                    }
                }
            }
            AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement-> map size without header: " + (this.mapResult.size() - 1)));
            AnalysisLogger.getLogger().debug((Object)"In DatabaseManagement-> Writing File and Result Map creation operations terminated");
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (this.out != null) {
                this.out.close();
                this.out = null;
                AnalysisLogger.getLogger().debug((Object)"In DatabaseManagement-> File closed");
            }
        }
    }

    private List<String> getDataTypeColumns(String tableName, String schemaName) throws Exception {
        ArrayList listvalues;
        Object element;
        int i;
        String query;
        AnalysisLogger.getLogger().debug((Object)"In DatabaseManagement->retrieving data type columns");
        List<Object> resultDataTypeColumns = null;
        ArrayList<String> DataTypeColumns = new ArrayList<String>();
        if (this.DBType.equals(POSTGRES) && (resultDataTypeColumns = this.connection.executeQuery(query = String.format(queryForDataTypeColumnsPostgres, tableName, schemaName), this.sourceDBSession)) != null) {
            for (i = 0; i < resultDataTypeColumns.size(); ++i) {
                element = resultDataTypeColumns.get(i);
                listvalues = new ArrayList(((LinkedHashMap)element).values());
                if (listvalues.get(0).toString().equals("USER-DEFINED")) {
                    DataTypeColumns.add(i, (String)listvalues.get(1));
                    continue;
                }
                DataTypeColumns.add(i, (String)listvalues.get(0));
            }
        }
        if (this.DBType.equals(MYSQL) && (resultDataTypeColumns = this.connection.executeQuery(query = String.format(queryForDataTypeColumnsMysql, tableName, schemaName), this.sourceDBSession)) != null) {
            for (i = 0; i < resultDataTypeColumns.size(); ++i) {
                element = resultDataTypeColumns.get(i);
                listvalues = new ArrayList(((LinkedHashMap)element).values());
                DataTypeColumns.add(i, (String)listvalues.get(0));
            }
        }
        return DataTypeColumns;
    }

    private List<String> getColumnNamesTable(String tableName, String schemaName) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"DatabaseManagement->retrieving column names");
        String queryColumns = null;
        if (this.DBType.equals(POSTGRES)) {
            queryColumns = String.format("SELECT column_name FROM information_schema.COLUMNS WHERE table_name ='%1$s' and table_schema='%2$s' order by ordinal_position asc", tableName, schemaName);
        }
        if (this.DBType.equals(MYSQL)) {
            queryColumns = String.format("SELECT column_name FROM information_schema.COLUMNS WHERE table_name ='%1$s' and table_schema='%2$s' order by ordinal_position asc", tableName, schemaName);
        }
        List<Object> columnsSet = null;
        columnsSet = this.connection.executeQuery(queryColumns, this.sourceDBSession);
        AnalysisLogger.getLogger().debug((Object)("DatabaseManagement->query submitted successfully: " + queryColumns));
        if (columnsSet != null) {
            this.listColumnNamesTable = new ArrayList<String>();
            for (int i = 0; i < columnsSet.size(); ++i) {
                Object element = columnsSet.get(i);
                ArrayList listvalues = new ArrayList(((LinkedHashMap)element).values());
                for (int j = 0; j < listvalues.size(); ++j) {
                    this.listColumnNamesTable.add(listvalues.get(j).toString());
                }
            }
        }
        return this.listColumnNamesTable;
    }

    public List<String> getListColumnNamesTable() {
        return this.listColumnNamesTable;
    }

    public HashMap<String, String> getMapSampleTableResult() {
        return this.mapResult;
    }

    public File getFile() {
        return this.file;
    }

    public HashMap<String, String> getMapQueryResult() {
        return this.mapResult;
    }

    public String smartCorrectionOnQuery(String OriginalQuery, int dialect) throws ParseException, ConvertException {
        String queryCorrected = "";
        SqlDialectConverter obj = new SqlDialectConverter(OriginalQuery);
        queryCorrected = obj.convert(dialect);
        AnalysisLogger.getLogger().debug((Object)("In DatabaseManagement-> query converted: " + queryCorrected));
        return queryCorrected;
    }
}

