/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.codec.digest.DigestUtils;
import org.gcube.dataanalysis.copernicus.motu.client.MultiValueParameters;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.gcube.dataanalysis.copernicus.motu.model.ServiceMetadata;
import org.gcube.dataanalysis.datasetimporter.util.TimeUtil;

public class DownloadRequest {
    private String service;
    private String product;
    private String action;
    private Collection<String> variables;
    private Double xLo;
    private Double xHi;
    private Double yLo;
    private Double yHi;
    private Double zLo;
    private Double zHi;
    private Calendar tLo;
    private Calendar tHi;
    private String scriptVersion;
    private String mode;
    private String output;

    public DownloadRequest() {
    }

    public DownloadRequest(DownloadRequest other) {
        this();
        this.setService(other.getService());
        this.setProduct(other.getProduct());
        this.setAction(other.getAction());
        this.setVariables(other.getVariables());
        this.setxRange(other.getxLo(), other.getxHi());
        this.setyRange(other.getyLo(), other.getyHi());
        this.setzRange(other.getzLo(), other.getzHi());
        this.settRange(other.gettLo(), other.gettHi());
        this.setScriptVersion(other.getScriptVersion());
        this.setMode(other.getMode());
        this.setOutput(other.getOutput());
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setService(ServiceMetadata service) {
        this.service = service.getName();
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setProduct(ProductMetadataInfo product) {
        this.product = product.getTitle();
    }

    public Double getxLo() {
        return this.xLo;
    }

    public void setxLo(Double xLo) {
        this.xLo = xLo;
    }

    public Double getxHi() {
        return this.xHi;
    }

    public void setxHi(Double xHi) {
        this.xHi = xHi;
    }

    public void setxRange(Double xLo, Double xHi) {
        this.setxLo(xLo);
        this.setxHi(xHi);
    }

    public Double getyLo() {
        return this.yLo;
    }

    public void setyLo(Double yLo) {
        this.yLo = yLo;
    }

    public Double getyHi() {
        return this.yHi;
    }

    public void setyHi(Double yHi) {
        this.yHi = yHi;
    }

    public void setyRange(Double yLo, Double yHi) {
        this.setyLo(yLo);
        this.setyHi(yHi);
    }

    public Double getzLo() {
        return this.zLo;
    }

    public void setzLo(Double zLo) {
        this.zLo = zLo;
    }

    public Double getzHi() {
        return this.zHi;
    }

    public void setzHi(Double zHi) {
        this.zHi = zHi;
    }

    public void setzRange(Double zLo, Double zHi) {
        this.setzLo(zLo);
        this.setzHi(zHi);
    }

    public Calendar gettLo() {
        return this.tLo;
    }

    public void settLo(Calendar tLo) {
        this.tLo = tLo;
    }

    public void settLo(String tLo) throws ParseException {
        this.settLo(TimeUtil.toCalendar((String)tLo));
    }

    public Calendar gettHi() {
        return this.tHi;
    }

    public void settHi(Calendar tHi) {
        this.tHi = tHi;
    }

    public void settHi(String tHi) throws ParseException {
        this.settHi(TimeUtil.toCalendar((String)tHi));
    }

    public void settRange(Calendar tLo, Calendar tHi) {
        this.settLo(tLo);
        this.settHi(tHi);
    }

    public void settRange(String tLo, String tHi) throws ParseException {
        this.settLo(tLo);
        this.settHi(tHi);
    }

    public String getScriptVersion() {
        return this.scriptVersion;
    }

    public void setScriptVersion(String scriptVersion) {
        this.scriptVersion = scriptVersion;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Collection<String> getVariables() {
        if (this.variables == null) {
            this.variables = new Vector<String>();
        }
        return new TreeSet<String>(this.variables);
    }

    public Boolean hasVariables() {
        return this.variables != null && this.variables.size() > 0;
    }

    public void setVariables(Collection<String> variables) {
        this.variables = variables;
    }

    public void addVariable(String variable) {
        if (this.variables == null) {
            this.variables = new Vector<String>();
        }
        this.variables.add(variable);
    }

    public MultiValueParameters getParametersMap() {
        MultiValueParameters output = new MultiValueParameters();
        if (this.service != null) {
            output.put("service", this.service);
        }
        if (this.product != null) {
            output.put("product", this.product);
        }
        if (this.action != null) {
            output.put("action", this.action);
        }
        if (this.xLo != null) {
            output.put("x_lo", this.xLo.toString());
        }
        if (this.xHi != null) {
            output.put("x_hi", this.xHi.toString());
        }
        if (this.yLo != null) {
            output.put("y_lo", this.yLo.toString());
        }
        if (this.yHi != null) {
            output.put("y_hi", this.yHi.toString());
        }
        if (this.zLo != null) {
            output.put("z_lo", this.zLo.toString());
        }
        if (this.zHi != null) {
            output.put("z_hi", this.zHi.toString());
        }
        if (this.tLo != null) {
            output.put("t_lo", TimeUtil.toString((Calendar)this.tLo));
        }
        if (this.tHi != null) {
            output.put("t_hi", TimeUtil.toString((Calendar)this.tHi));
        }
        if (this.scriptVersion != null) {
            output.put("scriptVersion", this.scriptVersion);
        }
        if (this.mode != null) {
            output.put("mode", this.mode);
        }
        if (this.output != null) {
            output.put("output", this.output);
        }
        if (this.variables != null) {
            for (String variable : this.variables) {
                output.put("variable", variable);
            }
        }
        return output;
    }

    public String getHash() {
        DownloadRequest request = this;
        String text = "*";
        text = text + request.getService() + "*";
        text = text + request.getProduct() + "*";
        text = text + (request.getxLo() == null ? "XLOW" : request.getxLo()) + "*";
        text = text + (request.getxHi() == null ? "XHI" : request.getxHi()) + "*";
        text = text + (request.getyLo() == null ? "YLOW" : request.getyLo()) + "*";
        text = text + (request.getyHi() == null ? "YHI" : request.getyHi()) + "*";
        text = text + (request.getzLo() == null ? "ZLOW" : request.getzLo()) + "*";
        text = text + (request.getzHi() == null ? "ZHI" : request.getzHi()) + "*";
        text = text + (request.gettLo() == null ? "TLOW" : TimeUtil.toString((Calendar)request.gettLo())) + "*";
        text = text + (request.gettHi() == null ? "THI" : TimeUtil.toString((Calendar)request.gettHi())) + "*";
        if (request.getVariables() == null || request.getVariables().isEmpty()) {
            text = text + "all-variables*";
        } else {
            for (String v : request.getVariables()) {
                text = text + v + "*";
            }
        }
        return DigestUtils.md5Hex((String)text);
    }
}

