/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author Paolo Fabriani
 *
 */
@XmlRootElement(name="document")
public class CmemsDocument {

    private String title;
    private String url;
    private String date;

    public CmemsDocument() {
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    @XmlTransient
    public boolean isEmpty() {
        if(this.getTitle()!=null && !this.getTitle().trim().isEmpty())
            return false;
        if(this.getUrl()!=null && !this.getUrl().trim().isEmpty())
            return false;
        return true;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
