/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.dataanalysis.copernicus.motu.client.MultiValueParameters;
import org.gcube.dataanalysis.copernicus.motu.util.NetworkUtils;
import org.gcube.dataanalysis.datasetimporter.util.TextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CASClient {
    private static Logger logger = LoggerFactory.getLogger(CASClient.class);
    private String endpoint;
    private String username;
    private String password;

    public CASClient() {
    }

    public CASClient(String endpoint) {
        this();
        this.endpoint = endpoint;
    }

    public CASClient(String endpoint, String username, String password) {
        this(endpoint);
        this.setUsername(username);
        this.setPassword(password);
    }

    public String getEndpoint() {
        if (this.endpoint.startsWith("http:")) {
            return this.endpoint.replaceFirst("http:", "https:");
        }
        return this.endpoint;
    }

    public boolean isAuthnEndpoint(String endpoint) {
        return endpoint.indexOf("/login?") != -1;
    }

    public void setEndpoint(String endpoint) {
        if (endpoint.indexOf("/login?") != -1) {
            endpoint = endpoint.substring(0, endpoint.indexOf("/login?"));
            endpoint = endpoint + "/v1/tickets";
        }
        this.endpoint = endpoint;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private static String extractTGT(String response) {
        String tgt = null;
        Pattern p = Pattern.compile("/(TGT[^\"]+)");
        Matcher m = p.matcher(response);
        if (m.find()) {
            tgt = m.group(1);
        }
        return tgt;
    }

    private String getTicketGrantTicket() throws Exception {
        this.info("requesting a TGT...");
        MultiValueParameters params = new MultiValueParameters();
        params.put("username", this.getUsername());
        params.put("password", this.getPassword());
        String response = NetworkUtils.post(this.getEndpoint(), params);
        this.info("got response " + response);
        String tgt = CASClient.extractTGT(response);
        this.info("got TGT: " + tgt);
        return tgt;
    }

    private void info(String msg) {
        logger.info(TextUtil.removePasswords((String)msg));
    }

    private void debug(String msg) {
        logger.debug(TextUtil.removePasswords((String)msg));
    }

    private String getServiceTicketFor(String serviceRequest) throws Exception {
        this.info("requesting a ST for " + serviceRequest);
        String tgt = this.getTicketGrantTicket();
        if (tgt == null) {
            throw new Exception("got an empty TGT");
        }
        String url = this.getEndpoint() + "/" + tgt;
        MultiValueParameters params = new MultiValueParameters();
        params.put("service", serviceRequest.toString());
        String serviceTicket = NetworkUtils.post(url, params).trim();
        this.info("got ST: " + serviceTicket);
        return serviceTicket;
    }

    public String authenticateForURL(String url) throws Exception {
        String serviceTicket = this.getServiceTicketFor(url);
        return url + "&ticket=" + serviceTicket;
    }

    public String authenticateForURL(String url, MultiValueParameters parameters) throws Exception {
        String serviceURL = url;
        if (parameters != null) {
            serviceURL = serviceURL + "?" + NetworkUtils.getDataString(parameters);
        }
        return this.authenticateForURL(serviceURL);
    }
}

