/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotuWorkspace {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotuWorkspace.class);
    private String executionsRoot;
    private String executionId;
    private String inputSubpath = "input";
    private String outputSubpath = "output";

    public MotuWorkspace(String executionId) {
        this.executionId = executionId;
    }

    private File getExecutionsRoot() {
        return new File(this.executionsRoot);
    }

    public void setExecutionsRoot(String executionsRoot) {
        this.executionsRoot = executionsRoot;
    }

    public File getRoot() {
        return new File(this.executionsRoot, this.executionId);
    }

    public File getInputLocation() {
        return new File(this.getRoot(), this.inputSubpath);
    }

    public File getOutputLocation() {
        return new File(this.getRoot(), this.outputSubpath);
    }

    public void destroy() throws IOException {
        LOGGER.info("Removing execution directory '" + this.getRoot() + "'");
        if (this.getRoot().getAbsolutePath().startsWith("/tmp")) {
            FileUtils.deleteDirectory((File)this.getRoot());
        }
        LOGGER.info("Removed.");
    }

    public void ensureStructureExists() {
        this.ensureDirectory(this.getExecutionsRoot());
        this.ensureDirectory(this.getRoot());
        this.ensureDirectory(this.getInputLocation());
        this.ensureDirectory(this.getOutputLocation());
    }

    private void ensureDirectory(File dir) {
        LOGGER.debug("Creating directory: '" + dir.getAbsolutePath() + "'");
        if (!dir.exists()) {
            boolean result = false;
            try {
                dir.mkdir();
                result = true;
            }
            catch (SecurityException se) {
                LOGGER.error("Unable to create directory '" + dir.getAbsolutePath() + "'");
            }
            if (result) {
                LOGGER.debug("Created directory '" + dir.getAbsolutePath() + "'");
            }
        } else {
            LOGGER.debug("Directory '" + dir.getAbsolutePath() + "' already exists. Skipping.");
        }
    }

    public void setOutputLocation(String outputLocation) {
        this.outputSubpath = outputLocation;
    }

    public void setInputLocation(String inputLocation) {
        this.inputSubpath = inputLocation;
    }

    public void exec(String command, String subpath, String logfilename) {
        File executionDir = null;
        executionDir = subpath == null ? this.getRoot() : new File(this.getRoot(), subpath);
        this.exec(command, executionDir, logfilename);
    }

    public void exec(String command, File subpath, String logfilename) {
        LOGGER.info(String.format("Executing command '%s'", command));
        ProcessBuilder builder = new ProcessBuilder(command.split(" "));
        if (subpath == null) {
            builder.directory(this.getRoot());
        } else {
            builder.directory(subpath);
        }
        if (logfilename != null) {
            File logFile = new File(this.getRoot(), logfilename);
            builder.redirectErrorStream(true);
            builder.redirectOutput(logFile);
            LOGGER.info(String.format("  writing stdout and stderr to '%s'", logFile.getPath()));
        }
        try {
            Process process = builder.start();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error(e.toString());
        }
        LOGGER.info("Execution complete.");
    }
}

