/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.api;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ChunkTimespan;
import org.gcube.dataanalysis.datasetimporter.util.TimeUtil;

@XmlRootElement
public class ImportOptions {
    private Integer backTime;
    private String dataset;
    private String importSchedule;
    private String motu;
    private String product;
    private ChunkTimespan chunkSpan;
    private Calendar tLo;
    private Calendar tHi;
    private Collection<String> variables;
    private Double xLo;
    private Double xHi;
    private Double yLo;
    private Double yHi;
    private Double zLo;
    private Double zHi;

    public ImportOptions() {
    }

    public ImportOptions(Map<String, String> p) throws ParseException {
        this();
        if (p.get("chunkSpan") != null) {
            switch (p.get("chunkSpan")) {
                case "day": {
                    this.setChunkSpan(ChunkTimespan.DAY);
                    break;
                }
                case "month": {
                    this.setChunkSpan(ChunkTimespan.MONTH);
                    break;
                }
                case "year": {
                    this.setChunkSpan(ChunkTimespan.YEAR);
                }
            }
        }
        if (p.get("dataset") != null) {
            this.setDataset(p.get("dataset"));
        }
        if (p.get("motu") != null) {
            this.setMotu(p.get("motu"));
        }
        if (p.get("product") != null) {
            this.setProduct(p.get("product"));
        }
        if (p.get("backTime") != null) {
            this.setBackTime(Integer.parseInt(p.get("backTime")));
        }
        if (p.get("importSchedule") != null) {
            this.setImportSchedule(p.get("importSchedule"));
        }
        if (p.get("tLo") != null) {
            this.settLo(TimeUtil.toCalendar((String)p.get("tLo")));
        }
        if (p.get("tHi") != null) {
            this.settHi(TimeUtil.toCalendar((String)p.get("tHi")));
        }
        if (p.get("xLo") != null) {
            this.setxLo(Double.parseDouble(p.get("xLo")));
        }
        if (p.get("xHi") != null) {
            this.setxHi(Double.parseDouble(p.get("xHi")));
        }
        if (p.get("yLo") != null) {
            this.setyLo(Double.parseDouble(p.get("yLo")));
        }
        if (p.get("yHi") != null) {
            this.setyHi(Double.parseDouble(p.get("yHi")));
        }
        if (p.get("zLo") != null) {
            this.setzLo(Double.parseDouble(p.get("zLo")));
        }
        if (p.get("zHi") != null) {
            this.setzHi(Double.parseDouble(p.get("zHi")));
        }
        if (p.get("variables") != null) {
            String[] vars;
            for (String v : vars = p.get("variables").split(",")) {
                this.addVariable(v.trim());
            }
        }
    }

    public Integer getBackTime() {
        return this.backTime;
    }

    public void setBackTime(int backTime) {
        this.backTime = backTime;
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public String getMotu() {
        return this.motu;
    }

    public void setMotu(String motu) {
        this.motu = motu;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public ChunkTimespan getChunkSpan() {
        return this.chunkSpan;
    }

    public void setChunkSpan(ChunkTimespan chunkSpan) {
        this.chunkSpan = chunkSpan;
    }

    public Calendar gettLo() {
        return this.tLo;
    }

    public void settLo(Calendar tLo) {
        this.tLo = tLo;
    }

    public Calendar gettHi() {
        return this.tHi;
    }

    public void settHi(Calendar tHi) {
        this.tHi = tHi;
    }

    @XmlElement(name="variable")
    @XmlElementWrapper(name="variables")
    public Collection<String> getVariables() {
        return this.variables;
    }

    public void addVariable(String variable) {
        if (this.variables == null) {
            this.variables = new TreeSet<String>();
        }
        this.variables.add(variable);
    }

    public void setVariables(Collection<String> variables) {
        this.variables = variables;
    }

    public Double getxLo() {
        return this.xLo;
    }

    public void setxLo(Double xLo) {
        this.xLo = xLo;
    }

    public Double getxHi() {
        return this.xHi;
    }

    public void setxHi(Double xHi) {
        this.xHi = xHi;
    }

    public Double getyLo() {
        return this.yLo;
    }

    public void setyLo(Double yLo) {
        this.yLo = yLo;
    }

    public Double getyHi() {
        return this.yHi;
    }

    public void setyHi(Double yHi) {
        this.yHi = yHi;
    }

    public Double getzLo() {
        return this.zLo;
    }

    public void setzLo(Double zLo) {
        this.zLo = zLo;
    }

    public Double getzHi() {
        return this.zHi;
    }

    public void setzHi(Double zHi) {
        this.zHi = zHi;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> out = new HashMap<String, String>();
        if (this.getChunkSpan() != null) {
            out.put("chunkSpan", this.getChunkSpan().toString());
        }
        if (this.getDataset() != null) {
            out.put("dataset", this.getDataset());
        }
        if (this.getMotu() != null) {
            out.put("motu", this.getMotu());
        }
        if (this.getProduct() != null) {
            out.put("product", this.getProduct());
        }
        if (this.getBackTime() != null) {
            out.put("backTime", this.getBackTime().toString());
        }
        if (this.getImportSchedule() != null) {
            out.put("importSchedule", this.getImportSchedule().toString());
        }
        if (this.gettHi() != null) {
            out.put("tHi", TimeUtil.toString((Calendar)this.gettHi()));
        }
        if (this.gettLo() != null) {
            out.put("tLo", TimeUtil.toString((Calendar)this.gettLo()));
        }
        if (this.getxHi() != null) {
            out.put("xHi", this.getxHi().toString());
        }
        if (this.getxLo() != null) {
            out.put("xLo", this.getxLo().toString());
        }
        if (this.getyHi() != null) {
            out.put("yHi", this.getyHi().toString());
        }
        if (this.getyLo() != null) {
            out.put("yLo", this.getyLo().toString());
        }
        if (this.getzHi() != null) {
            out.put("zHi", this.getzHi().toString());
        }
        if (this.getzLo() != null) {
            out.put("zLo", this.getzLo().toString());
        }
        if (this.getVariables() != null) {
            out.put("variables", "" + String.join((CharSequence)", ", this.getVariables()));
        }
        return out;
    }

    public String getHash() {
        String S;
        String text = S = "|";
        text = text + (this.getProduct() == null ? "PR" : this.getProduct()) + S;
        text = text + (this.getDataset() == null ? "DS" : this.getDataset()) + S;
        text = text + (this.getChunkSpan() == null ? "CS" : this.getChunkSpan()) + S;
        text = text + (this.getxLo() == null ? "XL" : this.getxLo()) + S;
        text = text + (this.getxHi() == null ? "XH" : this.getxHi()) + S;
        text = text + (this.getyLo() == null ? "YL" : this.getyLo()) + S;
        text = text + (this.getyHi() == null ? "YH" : this.getyHi()) + S;
        text = text + (this.getzLo() == null ? "ZL" : this.getzLo()) + S;
        text = text + (this.getzHi() == null ? "ZH" : this.getzHi()) + S;
        text = text + (this.gettLo() == null ? "TL" : TimeUtil.toString((Calendar)this.gettLo())) + S;
        text = text + (this.gettHi() == null ? "TH" : TimeUtil.toString((Calendar)this.gettHi())) + S;
        text = this.getVariables() == null || this.getVariables().isEmpty() ? text + "AV" + S : text + String.join((CharSequence)S, this.getVariables()) + S;
        return DigestUtils.md5Hex((String)text);
    }

    public String getImportSchedule() {
        return this.importSchedule;
    }

    public void setImportSchedule(String importSchedule) {
        this.importSchedule = importSchedule;
    }

    public void setBackTime(Integer backTime) {
        this.backTime = backTime;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

