/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Dependency;
import org.gcube.dataanalysis.dataminer.poolmanager.rest.PoolManager;
import org.gcube.dataanalysis.dataminer.poolmanager.service.DataminerPoolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNException;

@Path(value="/")
public class RestPoolManager
implements PoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestPoolManager.class);
    private PoolManager service = new DataminerPoolManager();

    @GET
    @Path(value="/scopes/add")
    @Produces(value={"text/plain"})
    public String addAlgorithmToVRE(@QueryParam(value="algorithm") String algorithm, @QueryParam(value="name") String name, @QueryParam(value="description") String description, @QueryParam(value="category") String category, @DefaultValue(value="transducerers") @QueryParam(value="algorithmType") String algorithmType, @DefaultValue(value="N") @QueryParam(value="skipJava") String skipJava, @DefaultValue(value="false") @QueryParam(value="publish") boolean publish, @DefaultValue(value="false") @QueryParam(value="updateSVN") boolean updateSVN) throws IOException, InterruptedException, SVNException {
        Algorithm algo = this.getAlgorithm(algorithm, null, null, name, description, category, algorithmType, skipJava);
        if (publish) {
            this.service.addAlgToIs(algo);
        }
        if (updateSVN) {
            for (Dependency d : algo.getDependencies()) {
                LinkedList<String> ls;
                if (d.getType().equals("os")) {
                    ls = new LinkedList<String>();
                    ls.add(d.getName());
                    this.service.updateSVN("r_deb_pkgs.txt", ls);
                }
                if (d.getType().equals("cran")) {
                    ls = new LinkedList();
                    ls.add(d.getName());
                    this.service.updateSVN("r_cran_pkgs.txt", ls);
                }
                if (!d.getType().equals("github")) continue;
                ls = new LinkedList();
                ls.add(d.getName());
                this.service.updateSVN("r_github_pkgs.txt", ls);
            }
        }
        return this.service.addAlgorithmToVRE(algo, ScopeProvider.instance.get());
    }

    @GET
    @Path(value="/hosts/add")
    @Produces(value={"text/plain"})
    public String addAlgorithmToHost(@QueryParam(value="algorithm") String algorithm, @QueryParam(value="hostname") String hostname, @QueryParam(value="name") String name, @QueryParam(value="description") String description, @QueryParam(value="category") String category, @DefaultValue(value="transducerers") @QueryParam(value="algorithmType") String algorithmType, @DefaultValue(value="N") @QueryParam(value="skipJava") String skipJava, @DefaultValue(value="false") @QueryParam(value="publish") boolean publish, @DefaultValue(value="false") @QueryParam(value="updateSVN") boolean updateSVN) throws IOException, InterruptedException, SVNException {
        Algorithm algo = this.getAlgorithm(algorithm, null, hostname, name, description, category, algorithmType, skipJava);
        if (publish) {
            this.service.addAlgToIs(algo);
        }
        if (updateSVN) {
            for (Dependency d : algo.getDependencies()) {
                LinkedList<String> ls;
                if (d.getType().equals("os")) {
                    ls = new LinkedList<String>();
                    ls.add(d.getName());
                    this.service.updateSVN("r_deb_pkgs.txt", ls);
                }
                if (d.getType().equals("cran")) {
                    ls = new LinkedList();
                    ls.add(d.getName());
                    this.service.updateSVN("r_cran_pkgs.txt", ls);
                }
                if (!d.getType().equals("github")) continue;
                ls = new LinkedList();
                ls.add(d.getName());
                this.service.updateSVN("r_github_pkgs.txt", ls);
            }
        }
        return this.service.addAlgorithmToHost(algo, hostname);
    }

    private Algorithm getAlgorithm(String algorithm, String vre, String hostname, String name, String description, String category, String algorithmType, String skipJava) throws IOException, InterruptedException {
        LOGGER.debug("Adding algorithm =" + algorithm + " to VRE =" + ScopeProvider.instance.get());
        Algorithm algo = this.service.extractAlgorithm(algorithm);
        if (algo.getCategory() == null) {
            algo.setCategory(category);
        } else {
            algo.setCategory(algo.getCategory());
        }
        if (algo.getAlgorithmType() == null) {
            algo.setAlgorithmType(algorithmType);
        } else {
            algo.setAlgorithmType(algo.getCategory());
        }
        if (algo.getSkipJava() == null) {
            algo.setSkipJava(skipJava);
        } else {
            algo.setSkipJava(algo.getSkipJava());
        }
        if (algo.getName() == null) {
            algo.setName(name);
        } else {
            algo.setName(algo.getName());
        }
        if (algo.getDescription() == null) {
            algo.setDescription(description);
        } else {
            algo.setDescription(algo.getDescription());
        }
        return algo;
    }

    @GET
    @Path(value="/log")
    @Produces(value={"text/plain"})
    public String getLogById(@QueryParam(value="logUrl") String logUrl) throws IOException {
        LOGGER.debug("Returning Log =" + logUrl);
        return this.service.getScriptFromURL(this.service.getURLfromWorkerLog(logUrl));
    }

    public Algorithm extractAlgorithm(String url) throws IOException {
        return null;
    }

    public static void main(String[] args) throws IOException, InterruptedException, SVNException {
        ScopeProvider.instance.set("/gcube/devNext/NextNext");
        RestPoolManager a = new RestPoolManager();
        a.addAlgorithmToVRE("http://data.d4science.org/TVc0TW9Ud1FjYlppK0NHd2pvU0owNmRFWHE4OW4xSGNHbWJQNStIS0N6Yz0", "test", null, null, "N", "transducerers", true, false);
    }

    public void getLogId(Algorithm algo, String vre) {
    }

    public String getScriptFromURL(URL logId) throws IOException {
        return null;
    }

    public String addAlgorithmToVRE(Algorithm algo, String vre) throws IOException, InterruptedException {
        return null;
    }

    public String addAlgorithmToHost(Algorithm algo, String hostname) throws IOException, InterruptedException {
        return null;
    }

    public URL getURLfromWorkerLog(String logUrl) throws MalformedURLException, UnknownHostException {
        return null;
    }

    public void addAlgToIs(Algorithm algo) {
    }

    public Set<Algorithm> getAlgoFromIs() {
        return null;
    }

    public List<String> updateSVN(String file, List<String> ldep) throws SVNException {
        return null;
    }
}

