/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.clients;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Host;
import org.gcube.informationsystem.publisher.AdvancedScopedPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNException;

public class ISClient {
    private Logger logger = LoggerFactory.getLogger(ISClient.class);

    public Host getDataminer(String hostname) {
        Host h = new Host();
        boolean remote2 = true;
        if (!remote2) {
            h.setName("dataminer1-devnext.d4science.org");
            return h;
        }
        h.setName(hostname);
        return h;
    }

    public static String getHProxy() {
        Host h = new Host();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'DataMiner'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        h.setName(((ServiceEndpoint)resources.get(0)).profile().runtime().hostedOn());
        return h.getName();
    }

    public Collection<Host> listDataminersInVRE() {
        boolean remote = false;
        if (!remote) {
            Vector<Host> out = new Vector<Host>();
            Host h = new Host();
            h.setName("dataminer1-devnext.d4science.org");
            out.add(h);
            return out;
        }
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Platform/Name/text() eq 'DataMiner'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        Vector<Host> out = new Vector<Host>();
        for (ServiceEndpoint r : resources) {
            Host h = new Host();
            h.setName(r.profile().runtime().hostedOn());
            out.add(h);
        }
        return out;
    }

    public void updateAlg(Algorithm algo) {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + algo.getName() + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        if (ds.isEmpty()) {
            return;
        }
        GenericResource a = (GenericResource)ds.get(0);
        a.profile().newBody(this.getAlgoBody(algo));
        try {
            scopedPublisher.update((Resource)a);
        }
        catch (RegistryNotFoundException e) {
            e.printStackTrace();
        }
    }

    private String getAlgoBody(Algorithm algo) {
        return "<category>" + algo.getCategory() + "</category>\n<clazz>" + algo.getClazz() + "</clazz>\n<algorithmType>" + algo.getAlgorithmType() + "</algorithmType>\n<skipJava>" + algo.getSkipJava() + "</skipJava>\n<packageURL>" + algo.getPackageURL() + "</packageURL>\n<dependencies>" + algo.getDependencies() + "</dependencies>";
    }

    public void addAlgToIs(Algorithm algo, String token) {
        GenericResource a = new GenericResource();
        a.newProfile().name(algo.getName()).type("StatisticalManagerAlgorithm").description(algo.getDescription());
        a.profile().newBody(this.getAlgoBody(algo));
        try {
            SecurityTokenProvider.instance.set(token);
            this.publishScopedResource(a, Arrays.asList(SecurityTokenProvider.instance.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unPublishScopedResource(GenericResource resource) throws RegistryNotFoundException, Exception {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        AdvancedScopedPublisher advancedScopedPublisher = new AdvancedScopedPublisher(scopedPublisher);
        String id = resource.id();
        this.logger.info("Trying to remove {} with ID {} from {}", new Object[]{resource.getClass().getSimpleName(), id, ScopeProvider.instance.get()});
        advancedScopedPublisher.forceRemove((Resource)resource);
        this.logger.info("{} with ID {} removed successfully", (Object)resource.getClass().getSimpleName(), (Object)id);
    }

    public void publishScopedResource(GenericResource a, List<String> scopes) throws RegistryNotFoundException, Exception {
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)a, (Writer)stringWriter);
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        try {
            this.logger.debug(scopes.toString());
            this.logger.debug(stringWriter.toString());
            scopedPublisher.create((Resource)a, scopes);
        }
        catch (RegistryNotFoundException e) {
            this.logger.error("Registry not found", (Throwable)e);
            throw e;
        }
    }

    public static void main(String[] args) throws IOException, SVNException {
        ISClient a = new ISClient();
        ScopeProvider.instance.set("/gcube/devNext/NextNext");
    }
}

