package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers;
import java.io.File;
import java.net.URL;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.io.StringWriter;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlObject;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.bindings.*;
import org.n52.wps.algorithm.annotation.*;
import org.n52.wps.io.data.*;
import org.n52.wps.io.data.binding.complex.*;
import org.n52.wps.io.data.binding.literal.*;
import org.n52.wps.server.*;import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.AbstractEcologicalEngineMapper;import org.n52.wps.server.*;import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.*;
@Algorithm(statusSupported=true, title="BIONYM_LOCAL", abstrakt="A fast version of the algorithm implementing BiOnym, a flexible workflow approach to taxon name matching. The workflow allows to activate several taxa names matching algorithms and to get the list of possible transcriptions for a list of input raw species names with possible authorship indication.", identifier="org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.BIONYM_LOCAL", version = "1.1.0")
public class BIONYM_LOCAL extends AbstractEcologicalEngineMapper implements ITransducer{
@LiteralDataInput(abstrakt="Name of the parameter: SpeciesAuthorName. The scientific name of the species, possibly with authorship", defaultValue="Gadus morhua (Linnaeus, 1758)", title="The scientific name of the species, possibly with authorship", identifier = "SpeciesAuthorName", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setSpeciesAuthorName(String data) {inputs.put("SpeciesAuthorName",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Taxa_Authority_File. The reference dataset to use", allowedValues= {"ASFIS","FISHBASE","OBIS","OBIS_ANIMALIA","OBIS_CNIDARIA","OBIS_ECHINODERMATA","OBIS_PLATYHELMINTHES","COL_FULL","COL_CHORDATA","COL_MAMMALIA","IRMNG_ACTINOPTERYGII","WORMS_ANIMALIA","WORMS_PISCES"}, defaultValue="FISHBASE", title="The reference dataset to use", identifier = "Taxa_Authority_File", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setTaxa_Authority_File(String data) {inputs.put("Taxa_Authority_File",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Parser_Name. The Species - Authority parser", allowedValues= {"SIMPLE","GNI","NONE"}, defaultValue="SIMPLE", title="The Species - Authority parser", identifier = "Parser_Name", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setParser_Name(String data) {inputs.put("Parser_Name",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Activate_Preparsing_Processing. Use preparsing rules to correct common errors", defaultValue="true", allowedValues= {"true","false"}, title="Use preparsing rules to correct common errors", identifier = "Activate_Preparsing_Processing", maxOccurs=1, minOccurs=1,binding = LiteralBooleanBinding.class) public void setActivate_Preparsing_Processing(Boolean data) {inputs.put("Activate_Preparsing_Processing",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: Use_Stemmed_Genus_and_Species. Process using Genus and Species names without declension", defaultValue="false", allowedValues= {"true","false"}, title="Process using Genus and Species names without declension", identifier = "Use_Stemmed_Genus_and_Species", maxOccurs=1, minOccurs=1,binding = LiteralBooleanBinding.class) public void setUse_Stemmed_Genus_and_Species(Boolean data) {inputs.put("Use_Stemmed_Genus_and_Species",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: Accuracy_vs_Speed. A trade-off between recognition speed and accuracy. Max speed corresponds to search for strings with the same length only.", allowedValues= {"MAX_ACCURACY","LOW_SPEED","MEDIUM_SPEED","HIGH_SPEED","MAX_SPEED"}, defaultValue="MAX_ACCURACY", title="A trade-off between recognition speed and accuracy. Max speed corresponds to search for strings with the same length only.", identifier = "Accuracy_vs_Speed", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setAccuracy_vs_Speed(String data) {inputs.put("Accuracy_vs_Speed",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Matcher_1. Choose a Matcher", allowedValues= {"GSAy","FUZZYMATCH","LEVENSHTEIN","SOUNDEX","LEV_SDX_TRIG","TRIGRAM","NONE"}, defaultValue="GSAy", title="Choose a Matcher", identifier = "Matcher_1", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setMatcher_1(String data) {inputs.put("Matcher_1",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Threshold_1. Threshold", defaultValue="0.6", title="Threshold", identifier = "Threshold_1", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setThreshold_1(Double data) {inputs.put("Threshold_1",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: MaxResults_1. The maximum number of matching candidates per each raw input species", defaultValue="10", title="The maximum number of matching candidates per each raw input species", identifier = "MaxResults_1", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setMaxResults_1(Integer data) {inputs.put("MaxResults_1",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: Matcher_2. Choose a Matcher", allowedValues= {"GSAy","FUZZYMATCH","LEVENSHTEIN","SOUNDEX","LEV_SDX_TRIG","TRIGRAM","NONE"}, defaultValue="FUZZYMATCH", title="Choose a Matcher", identifier = "Matcher_2", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setMatcher_2(String data) {inputs.put("Matcher_2",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Threshold_2. Threshold", defaultValue="0.6", title="Threshold", identifier = "Threshold_2", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setThreshold_2(Double data) {inputs.put("Threshold_2",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: MaxResults_2. The maximum number of matching candidates per each raw input species", defaultValue="10", title="The maximum number of matching candidates per each raw input species", identifier = "MaxResults_2", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setMaxResults_2(Integer data) {inputs.put("MaxResults_2",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: Matcher_3. Choose a Matcher", allowedValues= {"GSAy","FUZZYMATCH","LEVENSHTEIN","SOUNDEX","LEV_SDX_TRIG","TRIGRAM","NONE"}, defaultValue="LEVENSHTEIN", title="Choose a Matcher", identifier = "Matcher_3", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setMatcher_3(String data) {inputs.put("Matcher_3",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Threshold_3. Threshold", defaultValue="0.4", title="Threshold", identifier = "Threshold_3", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setThreshold_3(Double data) {inputs.put("Threshold_3",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: MaxResults_3. The maximum number of matching candidates per each raw input species", defaultValue="5", title="The maximum number of matching candidates per each raw input species", identifier = "MaxResults_3", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setMaxResults_3(Integer data) {inputs.put("MaxResults_3",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: Matcher_4. Choose a Matcher", allowedValues= {"GSAy","FUZZYMATCH","LEVENSHTEIN","SOUNDEX","LEV_SDX_TRIG","TRIGRAM","NONE"}, defaultValue="TRIGRAM", title="Choose a Matcher", identifier = "Matcher_4", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setMatcher_4(String data) {inputs.put("Matcher_4",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Threshold_4. Threshold", defaultValue="0.4", title="Threshold", identifier = "Threshold_4", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setThreshold_4(Double data) {inputs.put("Threshold_4",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: MaxResults_4. The maximum number of matching candidates per each raw input species", defaultValue="5", title="The maximum number of matching candidates per each raw input species", identifier = "MaxResults_4", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setMaxResults_4(Integer data) {inputs.put("MaxResults_4",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: Matcher_5. Choose a Matcher (Optional)", allowedValues= {"GSAy","FUZZYMATCH","LEVENSHTEIN","SOUNDEX","LEV_SDX_TRIG","TRIGRAM","NONE"}, defaultValue="NONE", title="Choose a Matcher (Optional)", identifier = "Matcher_5", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setMatcher_5(String data) {inputs.put("Matcher_5",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Threshold_5. Threshold (def. 0.2)", defaultValue="0.2", title="Threshold (def. 0.2)", identifier = "Threshold_5", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setThreshold_5(Double data) {inputs.put("Threshold_5",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: MaxResults_5. The maximum number of matching candidates per each raw input species", defaultValue="0", title="The maximum number of matching candidates per each raw input species", identifier = "MaxResults_5", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setMaxResults_5(Integer data) {inputs.put("MaxResults_5",""+data);}

@ComplexDataOutput(abstrakt="Output that is not predetermined", title="NonDeterministicOutput", identifier = "non_deterministic_output", binding = GenericXMLDataBinding.class)
 public XmlObject getNon_deterministic_output() {return (XmlObject) outputs.get("non_deterministic_output");}
@Execute	public void run() throws Exception {		super.run();	} }