/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.ConfigurationManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.IOWPSInformation;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.StatisticalTypeToWPSType;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.DataProvenance;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.StoredData;

public class OutputsManager {
    private AlgorithmConfiguration config;
    private List<File> generatedFiles = new ArrayList<File>();
    private List<String> generatedTables = new ArrayList<String>();
    private IClient storageclient;
    private String computationsession;
    private List<StoredData> provenanceData = new ArrayList<StoredData>();

    public List<StoredData> getProvenanceData() {
        return this.provenanceData;
    }

    public List<File> getGeneratedData() {
        return this.generatedFiles;
    }

    public List<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public List<String> getGeneratedTables() {
        return this.generatedTables;
    }

    public OutputsManager(AlgorithmConfiguration config, String computationsession) {
        this.config = config;
        this.computationsession = computationsession;
    }

    public LinkedHashMap<String, Object> createOutput(StatisticalType prioroutput, StatisticalType posterioroutput) throws Exception {
        LinkedHashMap<String, Object> outputs = new LinkedHashMap<String, Object>();
        AnalysisLogger.getLogger().debug((Object)"Converting prior output into WPS output");
        StatisticalTypeToWPSType converter = new StatisticalTypeToWPSType();
        converter.convert2WPSType(prioroutput, false, this.config);
        this.generatedFiles.addAll(converter.getGeneratedFiles());
        this.generatedTables.addAll(converter.getGeneratedTables());
        LinkedHashMap<String, IOWPSInformation> priorOutput = converter.outputSet;
        AnalysisLogger.getLogger().debug((Object)"Converting posterior output into WPS output");
        StatisticalTypeToWPSType postconverter = new StatisticalTypeToWPSType();
        postconverter.convert2WPSType(posterioroutput, false, this.config);
        this.generatedFiles.addAll(postconverter.getGeneratedFiles());
        AnalysisLogger.getLogger().debug((Object)("Generated Files " + this.generatedFiles));
        this.generatedTables.addAll(postconverter.getGeneratedTables());
        AnalysisLogger.getLogger().debug((Object)("Generated Tables " + this.generatedFiles));
        LinkedHashMap<String, IOWPSInformation> postOutput = postconverter.outputSet;
        LinkedHashMap<String, IOWPSInformation> ndoutput = new LinkedHashMap<String, IOWPSInformation>();
        AnalysisLogger.getLogger().debug((Object)"Merging prior and posterior output");
        if (ConfigurationManager.useStorage().booleanValue()) {
            this.prepareForStoring();
        }
        for (String okey : postOutput.keySet()) {
            AnalysisLogger.getLogger().debug((Object)("Assigning output: " + okey + " to the expected output"));
            IOWPSInformation postInfo = postOutput.get(okey);
            IOWPSInformation info = priorOutput.get(okey);
            if (info == null) {
                for (String priorPName : priorOutput.keySet()) {
                    if (outputs.get(priorPName) != null || !priorPName.startsWith(postInfo.getClassname())) continue;
                    okey = priorPName;
                    info = priorOutput.get(priorPName);
                    break;
                }
            }
            if (postInfo != null && postInfo.getContent() != null) {
                if (ConfigurationManager.useStorage().booleanValue() && postInfo.getLocalMachineContent() != null) {
                    String storageurl = this.uploadFileOnStorage(postInfo.getLocalMachineContent(), postInfo.getMimetype());
                    postInfo.setContent(storageurl);
                }
                if (info != null) {
                    AnalysisLogger.getLogger().debug((Object)("Found a corresponding output: " + okey));
                    outputs.put(okey, postInfo.getContent());
                    if (postInfo.getLocalMachineContent() != null) {
                        ndoutput.put(okey, postInfo);
                    }
                } else {
                    AnalysisLogger.getLogger().debug((Object)("Output was not expected: " + okey));
                    ndoutput.put(okey, postInfo);
                }
                this.saveProvenanceData(postInfo);
            }
            System.gc();
        }
        XmlObject ndxml = this.generateNonDeterministicOutput(ndoutput);
        outputs.put("non_deterministic_output", ndxml);
        for (String pkey : priorOutput.keySet()) {
            if (outputs.get(pkey) != null) continue;
            AnalysisLogger.getLogger().debug((Object)("Safety check: adding empty string for " + pkey + " of type " + priorOutput.get(pkey).getClassname()));
            outputs.put(pkey, "");
        }
        return outputs;
    }

    private void saveProvenanceData(IOWPSInformation info) {
        String name = info.getName();
        String id = info.getName();
        DataProvenance provenance = DataProvenance.COMPUTED;
        String creationDate = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(System.currentTimeMillis());
        String operator = this.config.getAgent();
        String computationId = this.computationsession;
        String type = info.getMimetype();
        String payload = info.getContent();
        StoredData data = new StoredData(name, info.getAbstractStr(), id, provenance, creationDate, operator, computationId, type, payload, this.config.getGcubeScope());
        this.provenanceData.add(data);
    }

    private void prepareForStoring() {
        AnalysisLogger.getLogger().debug((Object)"Preparing storage client");
        String scope = this.config.getGcubeScope();
        String serviceClass = "WPS";
        String serviceName = "wps.synch";
        String owner = this.config.getParam(ConfigurationManager.serviceUserNameParameterVariable);
        this.storageclient = new StorageClient(serviceClass, serviceName, owner, AccessType.SHARED, MemoryType.VOLATILE).getClient();
        AnalysisLogger.getLogger().debug((Object)"Storage client ready");
    }

    private String uploadFileOnStorage(String localfile, String mimetype) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Storing->Start uploading on storage the following file: " + localfile));
        File localFile = new File(localfile);
        String remotef = "/wps_synch_output/" + this.config.getAgent() + "/" + this.computationsession + "/" + localFile.getName();
        this.storageclient.put(true).LFile(localfile).RFile(remotef);
        String url = this.storageclient.getHttpUrl().RFile(remotef);
        AnalysisLogger.getLogger().info((Object)("Storing->Uploading finished - URL: " + url));
        return url;
    }

    public String cleanTagString(String tag) {
        return tag.replace(" ", "_").replaceAll("[\\]\\[!\"#$%&'()*+,\\./:;<=>?@\\^`{|}~-]", "");
    }

    public XmlObject generateNonDeterministicOutputPlain(LinkedHashMap<String, IOWPSInformation> ndoutput) throws Exception {
        String XMLString = "<gml:featureMember xmlns:gml=\"http://www.opengis.net/gml\" xmlns:d4science=\"http://www.d4science.org\">\n\t<d4science:output fid=\"outputcollection\">\n";
        for (String key : ndoutput.keySet()) {
            IOWPSInformation info = ndoutput.get(key);
            String payload = info.getContent();
            String mimetype = info.getMimetype();
            XMLString = String.valueOf(XMLString) + "\t\t<d4science:k_" + this.cleanTagString(key) + ">" + "\t\t\t<d4science:Data><![CDATA[" + payload + "]]></d4science:Data>\n" + "\t\t\t<d4science:Description><![CDATA[" + (info.getAbstractStr() != null ? info.getAbstractStr() : "") + "]]></d4science:Description>\n" + "\t\t\t<d4science:MimeType>" + mimetype + "</d4science:MimeType>\n" + "\t\t</d4science:k_" + this.cleanTagString(key) + ">\n";
        }
        XMLString = String.valueOf(XMLString) + "\t</d4science:output>\n</gml:featureMember>\n";
        AnalysisLogger.getLogger().debug((Object)("Non deterministic output: " + XMLString));
        XmlObject xmlData = XmlObject.Factory.newInstance();
        ByteArrayInputStream xstream = new ByteArrayInputStream(XMLString.getBytes());
        xmlData = XmlObject.Factory.parse((InputStream)xstream);
        AnalysisLogger.getLogger().debug((Object)"Output has been correctly parsed");
        return xmlData;
    }

    public XmlObject generateNonDeterministicOutputCollection(LinkedHashMap<String, IOWPSInformation> ndoutput) throws Exception {
        String XMLString = "<ogr:FeatureCollection xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://ogr.maptools.org/ result_8751.xsd\" xmlns:ogr=\"http://ogr.maptools.org/\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:d4science=\"http://www.d4science.org\">\n<gml:featureMember>\n <ogr:Result fid=\"F0\">\n\t<d4science:output fid=\"outputcollection\">\n";
        for (String key : ndoutput.keySet()) {
            IOWPSInformation info = ndoutput.get(key);
            String payload = info.getContent();
            String mimetype = info.getMimetype();
            XMLString = String.valueOf(XMLString) + "\t\t<d4science:k_" + this.cleanTagString(key) + ">" + "\t\t\t<d4science:Data><![CDATA[" + payload + "]]></d4science:Data>\n" + "\t\t\t<d4science:Description><![CDATA[" + (info.getAbstractStr() != null ? info.getAbstractStr() : "") + "]]></d4science:Description>\n" + "\t\t\t<d4science:MimeType>" + mimetype + "</d4science:MimeType>\n" + "\t\t</d4science:k_" + this.cleanTagString(key) + ">\n";
        }
        XMLString = String.valueOf(XMLString) + "\t</d4science:output>\n  </ogr:Result>\n</gml:featureMember>\n</ogr:FeatureCollection>";
        AnalysisLogger.getLogger().debug((Object)("Non deterministic output: " + XMLString));
        XmlObject xmlData = XmlObject.Factory.newInstance();
        ByteArrayInputStream xstream = new ByteArrayInputStream(XMLString.getBytes());
        xmlData = XmlObject.Factory.parse((InputStream)xstream);
        AnalysisLogger.getLogger().debug((Object)"Output has been correctly parsed");
        return xmlData;
    }

    public XmlObject generateNonDeterministicOutput(LinkedHashMap<String, IOWPSInformation> ndoutput) throws Exception {
        if (ndoutput.size() == 0) {
            return null;
        }
        String XMLString = "<ogr:FeatureCollection xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://ogr.maptools.org/ result_8751.xsd\" xmlns:ogr=\"http://ogr.maptools.org/\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:d4science=\"http://www.d4science.org\">\n<gml:featureMember>\n";
        int count = 0;
        for (String key : ndoutput.keySet()) {
            IOWPSInformation info = ndoutput.get(key);
            String payload = info.getContent();
            String mimetype = info.getMimetype();
            String abstractStr = info.getAbstractStr();
            AnalysisLogger.getLogger().debug((Object)("IOWPS Information: name " + info.getName() + "," + "abstr " + info.getAbstractStr() + "," + "content " + info.getContent() + "," + "def " + info.getDefaultVal() + ","));
            if ((abstractStr == null || abstractStr.trim().length() == 0) && payload != null && payload.trim().length() > 0) {
                abstractStr = info.getName();
            } else if (abstractStr == null) {
                abstractStr = "";
            }
            XMLString = String.valueOf(XMLString) + "\t\t<ogr:Result fid=\"F" + count + "\">" + "\t\t\t<d4science:Data><![CDATA[" + payload + "]]></d4science:Data>\n" + "\t\t\t<d4science:Description><![CDATA[" + abstractStr + "]]></d4science:Description>\n" + "\t\t\t<d4science:MimeType>" + mimetype + "</d4science:MimeType>\n" + "\t\t</ogr:Result>\n";
            ++count;
        }
        XMLString = String.valueOf(XMLString) + "\t</gml:featureMember>\n</ogr:FeatureCollection>";
        AnalysisLogger.getLogger().debug((Object)("Non deterministic output: " + XMLString));
        XmlObject xmlData = XmlObject.Factory.newInstance();
        ByteArrayInputStream xstream = new ByteArrayInputStream(XMLString.getBytes());
        xmlData = XmlObject.Factory.parse((InputStream)xstream);
        AnalysisLogger.getLogger().debug((Object)"Output has been correctly parsed");
        return xmlData;
    }

    public void shutdown() {
        try {
            this.storageclient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

