/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.is.InformationSystemUtils;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.ConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenManager.class);
    String username;
    String scope;
    String token;
    String tokenQualifier;

    public String getScope() {
        return this.scope;
    }

    public String getUserName() {
        return this.username;
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenQualifier() {
        return this.tokenQualifier;
    }

    public void getCredentials() {
        try {
            LOGGER.info("Retrieving token credentials");
            this.username = AuthorizationProvider.instance.get().getClient().getId();
            this.token = SecurityTokenProvider.instance.get();
            if (this.token == null || this.token.isEmpty()) {
                String jwtToken = AccessTokenProvider.instance.get();
                this.scope = ScopeProvider.instance.get();
                this.token = this.getGcubeTokenFromUriResolver(jwtToken, this.scope);
            }
            AuthorizationEntry entry = Constants.authorizationService().get(this.token);
            this.scope = entry.getContext();
            this.tokenQualifier = entry.getQualifier();
        }
        catch (Exception e) {
            LOGGER.error("Error Retrieving token credentials: " + e.getLocalizedMessage(), (Throwable)e);
            this.scope = null;
            this.username = null;
        }
        if ((this.scope == null || this.username == null) && ConfigurationManager.isSimulationMode().booleanValue()) {
            this.scope = ConfigurationManager.defaultScope;
            this.username = ConfigurationManager.defaultUsername;
        }
        LOGGER.info("Retrieved scope: {} Username: {} Token {} SIMULATION MODE: {} ", new Object[]{this.scope, this.username, this.token, ConfigurationManager.isSimulationMode()});
    }

    public String getGcubeTokenFromUriResolver(String jwtToken, String scope) throws Exception {
        String gcubeToken;
        block65: {
            gcubeToken = null;
            String uriResolverOatURL = InformationSystemUtils.retrieveUriResolverOat(scope);
            try {
                LOGGER.info("Create Request: " + uriResolverOatURL);
                URL urlObj = new URL(uriResolverOatURL);
                HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Authorization", "Bearer " + jwtToken);
                connection.setDoOutput(true);
                try (AutoCloseable conc = () -> connection.disconnect();){
                    int responseCode = connection.getResponseCode();
                    LOGGER.info("Response Code: " + responseCode);
                    if (Response.Status.fromStatusCode((int)responseCode).compareTo((Enum)Response.Status.OK) == 0) {
                        try (InputStream ins = connection.getInputStream();
                             BufferedReader in = new BufferedReader(new InputStreamReader(ins));){
                            String inputLine = null;
                            inputLine = in.readLine();
                            if (inputLine != null) {
                                // empty if block
                            }
                            gcubeToken = inputLine;
                            break block65;
                        }
                    }
                    String error = "Invalid Response Code retrieving GCube Token from Uri Resolver: " + responseCode;
                    LOGGER.error(error);
                    try (InputStream ins = connection.getErrorStream();
                         BufferedReader in = new BufferedReader(new InputStreamReader(ins));){
                        String inputLine = null;
                        while ((inputLine = in.readLine()) != null) {
                            LOGGER.error(inputLine);
                        }
                    }
                    throw new Exception(error);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error retrieving GcubeToken from Uri Resolver: " + e.getLocalizedMessage());
                e.printStackTrace();
                throw e;
            }
        }
        LOGGER.info("Retrieved GcubeToken: " + gcubeToken);
        return gcubeToken;
    }
}

