/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.datasetimporter.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SizeUtils {
    public static String units = " KMGTPEZY";

    public static long parse(String arg0) throws ParseException {
        String digit = "[0-9\\\\.,E]+";
        String prefix = "[" + units + "]i?";
        String unit = "Bytes|Byte|B";
        String re = String.format("(%s+)\\s*((%s)?(%s)?)", digit, prefix, unit);
        Pattern pattern = Pattern.compile(re);
        Matcher matcher = pattern.matcher(arg0);
        if (matcher.matches()) {
            double val = Double.parseDouble(matcher.group(1));
            int power = 0;
            int factor = 1000;
            if (matcher.group(3) != null) {
                if (matcher.group(3).endsWith("i")) {
                    factor = 1024;
                }
                power = units.indexOf(matcher.group(3).substring(0, 1));
            }
            return new Double(val * Math.pow(factor, power)).longValue();
        }
        throw new ParseException(arg0, 0);
    }

    public static String humanReadableSize(Long bytes) {
        return SizeUtils.humanReadableBinarySize(bytes);
    }

    public static String humanReadableBinarySize(Long bytes) {
        return SizeUtils.humanReadableSize(bytes, false);
    }

    public static String humanReadableDecimalSize(Long bytes) {
        return SizeUtils.humanReadableSize(bytes, true);
    }

    private static String humanReadableSize(Long bytes, boolean decimal) {
        for (int i = 0; i < 10; ++i) {
            int base = decimal ? 1000 : 1024;
            Double s = Math.pow(base, i);
            if (!((double)bytes.longValue() < 500.0 * s)) continue;
            Double out = (double)bytes.longValue() * 1.0 / s;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            if (i == 0) {
                return df.format(out) + " B";
            }
            String unit = units.charAt(i) + (decimal ? "" : "i") + "B";
            return df.format(out) + " " + unit;
        }
        return bytes + " B";
    }
}

