/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.JobSMspd;

import java.util.ArrayList;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.streams.Stream;

public class ThreadExtractionOccFromSPD
implements Runnable {
    private ArrayList<String> chunk;
    private ArrayList<ArrayList<String>> informations;
    private ArrayList<String> errors;
    private String dataProvider;
    private String dataProviderUnfold;
    private String dataProviderExpand;
    String scope;

    public ThreadExtractionOccFromSPD(ArrayList<String> chunk, String dataProvider, String dataProviderExpand, String dataProviderUnfold, String scope) {
        this.chunk = chunk;
        for (String species : chunk) {
        }
        this.dataProvider = dataProvider;
        this.dataProviderExpand = dataProviderExpand;
        this.dataProviderUnfold = dataProviderUnfold;
        this.informations = new ArrayList();
        this.errors = new ArrayList();
        this.scope = scope;
    }

    @Override
    public void run() {
        AnalysisLogger.getLogger().debug((Object)("SCOPE *******: " + this.scope));
        ScopeProvider.instance.set(this.scope);
        Manager manager = null;
        try {
            manager = (Manager)AbstractPlugin.manager().build();
            for (String species : this.chunk) {
                if (species == null) continue;
                String query = new String();
                query = this.createQueryParameter(species);
                AnalysisLogger.getLogger().debug((Object)("QUERY *******: " + query));
                try {
                    Stream stream = manager.search(query);
                    int i = 0;
                    while (stream.hasNext()) {
                        ++i;
                        OccurrencePoint ti = (OccurrencePoint)stream.next();
                        this.informations.add(this.crateRowTable(ti));
                    }
                    if (i != 0) continue;
                    this.errors.add(species + " not found.");
                }
                catch (Exception e) {
                    this.errors.add("Exception on " + species + " :" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("An error occurred: " + e.getMessage()));
        }
    }

    private String createQueryParameter(String species) {
        String query = "SEARCH BY SN '" + species + "'";
        String where = new String();
        String expand = new String();
        String unfold = new String();
        where = this.dataProvider.equals("ALL") ? "" : " IN " + this.dataProvider;
        unfold = this.dataProviderUnfold.equals("NO OPTION") ? "" : " UNFOLD WITH " + this.dataProviderUnfold;
        query = query + unfold;
        AnalysisLogger.getLogger().debug((Object)("expand is : " + this.dataProviderExpand));
        if (this.dataProviderExpand.equals("ALL")) {
            expand = " EXPAND";
        } else {
            AnalysisLogger.getLogger().debug((Object)"inside else ");
            expand = this.dataProviderExpand.equals("NO OPTION") ? "" : " EXPAND WITH " + this.dataProviderExpand;
        }
        query = query + expand;
        query = query + where;
        query = query + " RETURN occurrence";
        return query;
    }

    private ArrayList<String> crateRowTable(OccurrencePoint p) {
        ArrayList<String> infoOcc = new ArrayList<String>();
        infoOcc.add(p.getScientificName());
        infoOcc.add(p.getAuthor());
        infoOcc.add(p.getCatalogueNumber());
        infoOcc.add(p.getCitation());
        infoOcc.add(p.getCollectionCode());
        infoOcc.add(p.getCoordinateUncertaintyInMeters());
        infoOcc.add(p.getCountry());
        infoOcc.add(p.getCredits());
        infoOcc.add(p.getFamily());
        infoOcc.add(p.getId());
        infoOcc.add(p.getInstitutionCode());
        infoOcc.add(p.getKingdom());
        infoOcc.add(p.getLocality());
        infoOcc.add(p.getProvider());
        infoOcc.add(Double.toString(p.getDecimalLatitude()));
        infoOcc.add(Double.toString(p.getDecimalLongitude()));
        infoOcc.add(Double.toString(p.getMaxDepth()));
        infoOcc.add(Double.toString(p.getMinDepth()));
        return infoOcc;
    }

    public ArrayList<ArrayList<String>> getInfo() {
        return this.informations;
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }
}

