/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geothermal;

import org.gcube.contentmanagement.graphtools.plotting.graphs.HistogramGraph;
import org.gcube.dataanalysis.geothermal.AbstractProcess;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public class EnergyHistogramPerYear
extends AbstractProcess {
    DefaultCategoryDataset datasetMWE = new DefaultCategoryDataset();
    DefaultCategoryDataset datasetMWT = new DefaultCategoryDataset();
    DefaultCategoryDataset datasetTJY = new DefaultCategoryDataset();

    @Override
    public String getDescription() {
        return "An algorithm reporting the energy produced per year by the countries contributing to EGIP";
    }

    @Override
    void initDatasets() {
    }

    @Override
    void fulfillDataset(String f_name, String f_area, double f_f1990_mwe, double f_f1995_mwt, double f_f1995_h_tjy, double f_f1995_mwe, double f_f2000_mwt, double f_f2000_h_tjy, double f_f2000_mwe, double f_f2005_mwt, double f_f2005_h_tjy, double f_f2005_mwe, double f_f2010_mwt, double f_f2010_h_tjy, double f_f2010_mwe, double f_f2013_mwe, int startYear, int endYear) {
        if (startYear <= 1990 && endYear >= 1990) {
            this.datasetMWE.addValue(f_f1990_mwe, (Comparable)((Object)"1990"), (Comparable)((Object)f_name));
        }
        if (startYear <= 1995 && endYear >= 1995) {
            this.datasetMWE.addValue(f_f1995_mwe, (Comparable)((Object)"1995"), (Comparable)((Object)f_name));
            this.datasetMWT.addValue(f_f1995_mwt, (Comparable)((Object)"1995"), (Comparable)((Object)f_name));
            this.datasetTJY.addValue(f_f1995_h_tjy, (Comparable)((Object)"1995"), (Comparable)((Object)f_name));
        }
        if (startYear <= 2000 && endYear >= 2000) {
            this.datasetMWE.addValue(f_f2000_mwe, (Comparable)((Object)"2000"), (Comparable)((Object)f_name));
            this.datasetMWT.addValue(f_f2000_mwt, (Comparable)((Object)"2000"), (Comparable)((Object)f_name));
            this.datasetTJY.addValue(f_f2000_h_tjy, (Comparable)((Object)"2000"), (Comparable)((Object)f_name));
        }
        if (startYear <= 2005 && endYear >= 2005) {
            this.datasetMWE.addValue(f_f2005_mwe, (Comparable)((Object)"2005"), (Comparable)((Object)f_name));
            this.datasetMWT.addValue(f_f2005_mwt, (Comparable)((Object)"2005"), (Comparable)((Object)f_name));
            this.datasetTJY.addValue(f_f2005_h_tjy, (Comparable)((Object)"2005"), (Comparable)((Object)f_name));
        }
        if (startYear <= 2010 && endYear >= 2010) {
            this.datasetMWE.addValue(f_f2010_mwe, (Comparable)((Object)"2010"), (Comparable)((Object)f_name));
            this.datasetMWT.addValue(f_f2010_mwt, (Comparable)((Object)"2010"), (Comparable)((Object)f_name));
            this.datasetTJY.addValue(f_f2010_h_tjy, (Comparable)((Object)"2010"), (Comparable)((Object)f_name));
        }
        if (startYear <= 2013 && endYear >= 2013) {
            this.datasetMWE.addValue(f_f2013_mwe, (Comparable)((Object)"2013"), (Comparable)((Object)f_name));
        }
    }

    @Override
    JFreeChart createChartForMWE() {
        if (this.datasetMWE == null) {
            return null;
        }
        return HistogramGraph.createStaticChart((Dataset)this.datasetMWE);
    }

    @Override
    JFreeChart createChartForMWT() {
        if (this.datasetMWT == null) {
            return null;
        }
        return HistogramGraph.createStaticChart((Dataset)this.datasetMWT);
    }

    @Override
    JFreeChart createChartForTJY() {
        if (this.datasetTJY == null) {
            return null;
        }
        return HistogramGraph.createStaticChart((Dataset)this.datasetTJY);
    }

    @Override
    void renderChartForMWE() {
        HistogramGraph tsg = new HistogramGraph("MWE");
        tsg.render((Dataset)this.datasetMWE);
    }

    @Override
    void renderChartForMWT() {
        HistogramGraph tsg2 = new HistogramGraph("MWT");
        tsg2.render((Dataset)this.datasetMWT);
    }

    @Override
    void renderChartForTJY() {
        HistogramGraph tsg3 = new HistogramGraph("TJY");
        tsg3.render((Dataset)this.datasetTJY);
    }
}

