/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.insertion;

import com.ibm.icu.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.geo.meta.NetCDFMetadata;
import org.gcube.dataanalysis.geo.meta.OGCFormatter;
import org.gcube.dataanalysis.geo.meta.features.FeaturesManager;
import org.gcube.dataanalysis.geo.utils.ThreddsDataExplorer;
import org.opengis.metadata.Metadata;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.units.DateRange;

public class ThreddsFetcher {
    private FeaturesManager featurer = new FeaturesManager();
    public static String NetCDFDateFormat = "time: E MMM dd HH:mm:ss zzz yyyy";
    public static String HumanDateFormat = "MM-dd-yy HH:mm";

    public ThreddsFetcher(String scope) {
        this.featurer.setScope(scope);
    }

    public void fetch(String threddsCatalogURL) throws Exception {
        List<String> filesURL = ThreddsDataExplorer.getFiles(threddsCatalogURL);
        for (String filename : filesURL) {
            String url = OGCFormatter.getOpenDapURL(threddsCatalogURL, filename);
            if (!ThreddsDataExplorer.isGridDataset(url)) continue;
            GridDataset gds = GridDataset.open((String)url);
            List gridTypes = gds.getGrids();
            for (GridDatatype gdt : gridTypes) {
                String description = gdt.getDescription();
                if (description == null || description.length() == 0) {
                    description = gdt.getFullName();
                }
                DateRange dr = gdt.getCoordinateSystem().getDateRange();
                SimpleDateFormat humanDF = new SimpleDateFormat(HumanDateFormat, Locale.ROOT);
                String hStartDate = null;
                String hEndDate = null;
                String duration = null;
                String resolution = gdt.getTimeDimension() == null ? null : "" + gdt.getTimeDimension().getLength();
                int numberOfDimensions = 2;
                if (gdt.getZDimension() != null && gdt.getZDimension().getLength() > 1) {
                    numberOfDimensions = 3;
                    AnalysisLogger.getLogger().debug((Object)("Length of Z Dimension: " + gdt.getZDimension().getLength()));
                } else {
                    AnalysisLogger.getLogger().debug((Object)"Bidimensional Layer ");
                }
                if (dr != null) {
                    hStartDate = dr.getStart() == null ? null : humanDF.format(dr.getStart().getDate());
                    hEndDate = dr.getEnd() == null ? null : humanDF.format(dr.getEnd().getDate());
                    duration = dr.getDuration() == null ? null : "" + dr.getDuration();
                }
                String generatedTitle = ThreddsFetcher.generateTitle(String.valueOf(gds.getTitle()) + ": " + gds.getDescription(), description, hStartDate, hEndDate, numberOfDimensions);
                CoordinateAxis xAxis = gdt.getCoordinateSystem().getXHorizAxis();
                CoordinateAxis yAxis = gdt.getCoordinateSystem().getYHorizAxis();
                AnalysisLogger.getLogger().debug((Object)("Bounds:" + xAxis.getMinValue() + "," + yAxis.getMinValue() + "," + xAxis.getMaxValue() + "," + yAxis.getMaxValue()));
                Metadata previousmeta = this.featurer.getGNInfobyUUIDorName(generatedTitle);
                if (previousmeta != null) {
                    AnalysisLogger.getLogger().debug((Object)"***WARNING: layer yet found on GeoNetwork***");
                    continue;
                }
                double resolutionX = Math.abs((xAxis.getMaxValue() - xAxis.getMinValue()) / (double)xAxis.getShape()[0]);
                double resolutionY = Math.abs((yAxis.getMaxValue() - yAxis.getMinValue()) / (double)yAxis.getShape()[0]);
                NetCDFMetadata metadataInserter = new NetCDFMetadata();
                metadataInserter.setGeonetworkUrl(this.featurer.getGeonetworkURLFromScope());
                metadataInserter.setGeonetworkUser(this.featurer.getGeonetworkUserFromScope());
                metadataInserter.setGeonetworkPwd(this.featurer.getGeonetworkPasswordFromScope());
                metadataInserter.setThreddsCatalogUrl(threddsCatalogURL);
                metadataInserter.setLayerUrl(url);
                metadataInserter.setLayerName(gdt.getFullName());
                metadataInserter.setSourceFileName(filename);
                metadataInserter.setTitle(generatedTitle);
                metadataInserter.setAbstractField(ThreddsFetcher.generateAbstractField(gdt.getFullName(), filename, description, gdt.getUnitsString().trim(), hStartDate, hEndDate, duration, resolution, numberOfDimensions, gds.getTitle(), gds.getDescription()));
                metadataInserter.setResolution(Math.max(resolutionX, resolutionY));
                double minX = ThreddsDataExplorer.getMinX(gdt.getCoordinateSystem());
                double maxX = ThreddsDataExplorer.getMaxX(gdt.getCoordinateSystem());
                double minY = ThreddsDataExplorer.getMinY(gdt.getCoordinateSystem());
                double maxY = ThreddsDataExplorer.getMaxY(gdt.getCoordinateSystem());
                if (gds.getTitle().toUpperCase().contains("WORLD OCEAN ATLAS")) {
                    AnalysisLogger.getLogger().debug((Object)"Managing WoA Layer");
                    minX -= 180.0;
                    maxX -= 180.0;
                }
                metadataInserter.setXLeftLow(minX);
                metadataInserter.setYLeftLow(minY);
                metadataInserter.setXRightUpper(maxX);
                metadataInserter.setYRightUpper(maxY);
                metadataInserter.setCustomTopics(filename, description, String.valueOf(numberOfDimensions) + "D", gds.getTitle(), gds.getDescription(), "unit:" + gdt.getUnitsString().trim());
                if (hStartDate != null) {
                    metadataInserter.setStartDate(dr.getStart().getDate());
                    metadataInserter.setEndDate(dr.getEnd().getDate());
                }
                AnalysisLogger.getLogger().debug((Object)("title: " + metadataInserter.getTitle()));
                AnalysisLogger.getLogger().debug((Object)("abstract: " + metadataInserter.getAbstractField()));
                try {
                    metadataInserter.insertMetaData();
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)("Error in inserting file: " + filename));
                }
            }
        }
    }

    public static String generateTitle(String filename, String description, String startDate, String endDate, int numberOfDimensions) {
        String dateString = "";
        if (startDate != null) {
            dateString = startDate.equals(endDate) ? " in [" + startDate + "]" : " from [" + startDate + "] to [" + endDate + "]";
        }
        description = String.valueOf(description) + " " + dateString + " (" + numberOfDimensions + "D) {" + filename + "}";
        return description.replaceAll("( )+", " ");
    }

    public static String generateAbstractField(String layername, String filename, String description, String unit, String startDate, String endDate, String duration, String timeInstants, int numberOfDimensions, String netcdftitle, String netcdfdescription) {
        String timeresolutionString = "";
        String durationString = "";
        if (timeInstants != null && timeInstants.length() > 0) {
            timeresolutionString = " Number of time instants: " + timeInstants + ".";
        }
        if (duration != null && duration.length() > 0) {
            durationString = " Time interval lenght: " + duration + ".";
        }
        String dateString = "";
        if (startDate != null) {
            dateString = " in the time range between [" + startDate + "] and [" + endDate + "].";
        }
        String unitString = "";
        if (unit != null && unit.length() > 0) {
            unitString = " (" + unit + ")";
        }
        String numberOfDimensionsString = "";
        if (numberOfDimensions > 0) {
            numberOfDimensionsString = " Number of Dimensions: " + numberOfDimensions + ".";
        }
        String netcdfinfo = "";
        if (netcdftitle != null) {
            netcdfinfo = " " + netcdftitle + ": " + netcdfdescription + ".";
        }
        return String.valueOf(layername) + ": " + description + unitString + dateString + durationString + timeresolutionString + numberOfDimensionsString + netcdfinfo + " Local file in iMarine: " + filename + ".";
    }

    public static void main(String[] args) throws Exception {
        AnalysisLogger.setLogger((String)("./cfg/" + AlgorithmConfiguration.defaultLoggerFile));
        ThreddsFetcher tf = new ThreddsFetcher(null);
        tf.fetch("http://thredds.research-infrastructures.eu/thredds/catalog/public/netcdf/catalog.xml");
    }
}

