/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.signals.PeriodicityDetector;
import org.gcube.dataanalysis.ecoengine.signals.SignalConverter;
import org.gcube.dataanalysis.ecoengine.signals.SignalProcessing;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.algorithms.XYExtraction;
import org.gcube.dataanalysis.geo.connectors.wfs.WFS;
import org.gcube.dataanalysis.geo.matrixmodel.RasterTable;
import org.gcube.dataanalysis.geo.matrixmodel.TimeSeriesExtractor;

public class TimeExtraction
extends XYExtraction {
    public static String x = "X";
    public static String y = "Y";
    public static String resolution = "Resolution";
    public static String samplingFrequency = "SamplingFreq";
    public static String minFrequency = "MinFrequency";
    public static String maxFrequency = "MaxFrequency";
    public static String expectedFrequencyError = "FrequencyError";
    public double xValue;
    public double yValue;
    public double resolutionValue;
    public int samplingFrequencyValue;
    public double minFrequencyValue;
    public double maxFrequencyValue;
    public double expectedFrequencyErrorValue;
    public PeriodicityDetector pd;
    public double[] signal;
    public double[] timeline;
    Image signalimage;
    Image spectrogramImage;

    @Override
    public String getDescription() {
        return "An algorithm to extract a time series of values associated to a geospatial features repository (e.g. NETCDF, ASC, GeoTiff files etc. ). The algorithm analyses the time series and automatically searches for hidden periodicities. It produces one chart of the time series, one table containing the time series values and possibly the spectrogram.";
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        List<StatisticalType> previnputs = super.getInputParameters();
        this.inputs = new ArrayList();
        this.inputs.add(previnputs.get(0));
        this.inputs.add(previnputs.get(5));
        this.inputs.add(previnputs.get(6));
        IOHelper.addDoubleInput((List)this.inputs, (String)x, (String)"X coordinate", (String)"0");
        IOHelper.addDoubleInput((List)this.inputs, (String)y, (String)"Y coordinate", (String)"0");
        this.inputs.add(previnputs.get(7));
        IOHelper.addDoubleInput((List)this.inputs, (String)resolution, (String)"Extraction point resolution", (String)"0.5");
        IOHelper.addIntegerInput((List)this.inputs, (String)samplingFrequency, (String)"Sampling frequency in Hz. Leave it to -1 if unknown or under 1", (String)"-1");
        IOHelper.addDoubleInput((List)this.inputs, (String)minFrequency, (String)"Minimum expected frequency in Hz. Can be decimal", (String)"-1");
        IOHelper.addDoubleInput((List)this.inputs, (String)maxFrequency, (String)"Maximum expected frequency in Hz. Can be decimal", (String)"-1");
        IOHelper.addDoubleInput((List)this.inputs, (String)expectedFrequencyError, (String)"Expected precision on periodicity detection in Hz or 1/samples. Can be decimal and depends on the signal length. Default is 0.1", (String)"0.1");
        DatabaseType.addDefaultDBPars((List)this.inputs);
        return this.inputs;
    }

    @Override
    protected void getParameters() {
        this.layerNameValue = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)layerName);
        AnalysisLogger.getLogger().debug((Object)("Extraction: Layer " + this.layerNameValue));
        this.zValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)z));
        this.xValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)x));
        this.yValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)y));
        this.resolutionValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)resolution));
        this.samplingFrequencyValue = Integer.parseInt(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)samplingFrequency));
        this.minFrequencyValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)minFrequency));
        this.maxFrequencyValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)maxFrequency));
        this.expectedFrequencyErrorValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)expectedFrequencyError));
        AnalysisLogger.getLogger().debug((Object)("Extraction: Z " + this.zValue));
        AnalysisLogger.getLogger().debug((Object)("Extraction: X " + this.xValue));
        AnalysisLogger.getLogger().debug((Object)("Extraction: Y " + this.yValue));
        AnalysisLogger.getLogger().debug((Object)("Extraction: Res " + this.resolutionValue));
        AnalysisLogger.getLogger().debug((Object)("Extraction: SamplingF " + samplingFrequency));
        AnalysisLogger.getLogger().debug((Object)("Extraction: minF " + this.minFrequencyValue));
        AnalysisLogger.getLogger().debug((Object)("Extraction: maxF " + this.maxFrequencyValue));
        AnalysisLogger.getLogger().debug((Object)("Extraction: expectedError " + this.expectedFrequencyErrorValue));
        this.tableNameValue = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)tableName);
        this.tableLabelValue = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)tableLabel);
        AnalysisLogger.getLogger().debug((Object)("Extraction: tableName " + this.tableNameValue));
        AnalysisLogger.getLogger().debug((Object)("Extraction: tableLabel " + this.tableLabelValue));
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("Extraction: Externally set scope " + scope));
        if (scope == null) {
            scope = ScopeProvider.instance.get();
            this.config.setGcubeScope(scope);
        }
    }

    @Override
    public void compute() throws Exception {
        try {
            try {
                this.status = 10.0f;
                AnalysisLogger.setLogger((String)(String.valueOf(this.config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
                this.getParameters();
                AnalysisLogger.getLogger().debug((Object)"Extracting Time Series from layer");
                TimeSeriesExtractor intersector = new TimeSeriesExtractor(this.config);
                long t0 = System.currentTimeMillis();
                this.zValue = intersector.correctZ(this.zValue, this.layerNameValue, this.resolutionValue);
                AnalysisLogger.getLogger().debug((Object)("TimeExtraction->Best Z for this reference layer: " + this.zValue));
                this.outputParameters.put("Matching Z value in the layer", "" + this.zValue);
                this.outputParameters.put("Min Z value in the Layer", "" + intersector.zmin);
                this.outputParameters.put("Max Z value in the Layer", "" + intersector.zmax);
                AnalysisLogger.getLogger().debug((Object)("Z allowed to be: " + this.zValue));
                this.signal = intersector.extractT(this.layerNameValue, this.xValue, this.yValue, this.zValue, this.resolutionValue);
                AnalysisLogger.getLogger().debug((Object)("ELAPSED TIME: " + (System.currentTimeMillis() - t0)));
                AnalysisLogger.getLogger().debug((Object)("Signal: " + this.signal.length));
                this.status = 30.0f;
                if (this.signal.length > 1) {
                    AnalysisLogger.getLogger().debug((Object)"Detecting Periodicity..");
                    this.pd = new PeriodicityDetector();
                    double F = -1.0;
                    F = this.samplingFrequencyValue > 0 && this.minFrequencyValue > 0.0 && this.maxFrequencyValue > 0.0 && this.expectedFrequencyErrorValue > 0.0 ? this.pd.detectFrequency(this.signal, this.samplingFrequencyValue, (float)this.minFrequencyValue, (float)this.maxFrequencyValue, (float)this.expectedFrequencyErrorValue, false) : this.pd.detectFrequency(this.signal, false);
                    AnalysisLogger.getLogger().debug((Object)("Detected Frequency:" + F + " indecision [" + this.pd.lowermeanF + " , " + this.pd.uppermeanF + "]"));
                    AnalysisLogger.getLogger().debug((Object)("Detected Period:" + this.pd.meanPeriod + " indecision [" + this.pd.lowermeanPeriod + " , " + this.pd.uppermeanPeriod + "]"));
                    AnalysisLogger.getLogger().debug((Object)("Detected Periodicity Strength:" + this.pd.periodicityStrength));
                    AnalysisLogger.getLogger().debug((Object)"Extractor: MatrixExtractor initialized");
                    String uom = "samples";
                    if (this.samplingFrequencyValue > 0) {
                        uom = "s";
                    }
                    String frequom = "1/samples";
                    if (this.samplingFrequencyValue > 0) {
                        frequom = "Hz";
                    }
                    if (this.pd.periodicityStrength > 0.0) {
                        this.outputParameters.put("Detected Periodicity", MathFunctions.roundDecimal((double)this.pd.meanPeriod, (int)2) + " (" + uom + ") " + " indecision [" + MathFunctions.roundDecimal((double)this.pd.lowermeanPeriod, (int)2) + " , " + MathFunctions.roundDecimal((double)this.pd.uppermeanPeriod, (int)2) + "]");
                        this.outputParameters.put("Periodicity Strength", MathFunctions.roundDecimal((double)this.pd.periodicityStrength, (int)2) + " (" + this.pd.getPeriodicityStregthInterpretation() + ")");
                        this.outputParameters.put("Detected Frequency", MathFunctions.roundDecimal((double)F, (int)2) + " (" + frequom + ") " + " indecision [" + MathFunctions.roundDecimal((double)this.pd.lowermeanF, (int)2) + " , " + MathFunctions.roundDecimal((double)this.pd.uppermeanF, (int)2) + "]");
                    } else {
                        this.outputParameters.put("Detected Periodicity", "No Periodicities");
                        this.outputParameters.put("Periodicity Strength", "-" + MathFunctions.roundDecimal((double)this.pd.periodicityStrength, (int)2) + " (" + this.pd.getPeriodicityStregthInterpretation() + ")");
                        this.outputParameters.put("Detected Frequency", "-");
                    }
                    this.outputParameters.put("Maximum Frequency in the Spectrogram", MathFunctions.roundDecimal((double)this.pd.maxFrequency, (int)2) + " (" + frequom + ") ");
                    this.outputParameters.put("Minimum Frequency in the Spectrogram", MathFunctions.roundDecimal((double)this.pd.minFrequency, (int)2) + " (" + frequom + ") ");
                } else {
                    AnalysisLogger.getLogger().debug((Object)"Extractor: Signal is only one point!");
                }
                this.status = 70.0f;
                AnalysisLogger.getLogger().debug((Object)"Extractor: Matrix Extracted");
                AnalysisLogger.getLogger().debug((Object)"Extractor: ****Rasterizing grid into table****");
                double[][] matrix = new double[][]{this.signal};
                HashMap<Double, Map<String, String>> polygonsFeatures = null;
                if (intersector.currentconnector instanceof WFS) {
                    polygonsFeatures = ((WFS)intersector.currentconnector).getPolygonsFeatures();
                }
                RasterTable raster = new RasterTable(this.xValue, this.xValue, this.yValue, this.yValue, this.zValue, this.resolutionValue, this.resolutionValue, matrix, polygonsFeatures, this.config);
                int signalRate = 1;
                if (this.samplingFrequencyValue > 0) {
                    signalRate = this.samplingFrequencyValue;
                }
                this.timeline = SignalConverter.signalTimeLine((int)this.signal.length, (double)signalRate);
                ArrayList<Tuple<Double>> coordinates = new ArrayList<Tuple<Double>>();
                int i = 0;
                while (i < this.timeline.length) {
                    coordinates.add((Tuple<Double>)new Tuple((Object[])new Double[]{this.xValue, this.yValue, this.zValue, this.timeline[i]}));
                    ++i;
                }
                raster.setTablename(this.tableNameValue);
                raster.setCoordinates(coordinates);
                raster.deleteTable();
                raster.dumpGeoTable();
                if (this.pd != null && this.pd.currentspectrum != null && this.pd.currentspectrum.length > 0) {
                    this.signalimage = SignalProcessing.renderSignalWithGenericTime((double[])this.signal, (double[])this.timeline, (String)"Signal");
                    this.spectrogramImage = SignalProcessing.renderSignalSpectrogram2((double[][])this.pd.currentspectrum);
                }
                AnalysisLogger.getLogger().debug((Object)("Extractor: Map was dumped in table: " + this.tableNameValue));
                this.status = 80.0f;
                AnalysisLogger.getLogger().debug((Object)("Extractor: Elapsed: Whole operation completed in " + (double)(System.currentTimeMillis() - t0) / 1000.0 + "s"));
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("Extractor: ERROR!: " + e.getLocalizedMessage()));
                throw e;
            }
        }
        finally {
            this.status = 100.0f;
        }
    }

    @Override
    public StatisticalType getOutput() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ArrayList<TableTemplates> templateHspec = new ArrayList<TableTemplates>();
        templateHspec.add(TableTemplates.GENERIC);
        OutputTable p = new OutputTable(templateHspec, this.tableLabelValue, this.tableNameValue, "Output table");
        map.put("OutputTable", p);
        if (this.pd != null && this.signal != null && this.signal.length > 0) {
            HashMap<String, Image> producedImages = new HashMap<String, Image>();
            if (this.signalimage != null) {
                producedImages.put("Time Series Visualization", this.signalimage);
            }
            if (this.spectrogramImage != null) {
                producedImages.put("Spectrogram", this.spectrogramImage);
            }
            PrimitiveType images = new PrimitiveType("Images", producedImages, PrimitiveTypes.IMAGES, "Signal Processing", "Visualization of the signal and spectrogram");
            for (String key : this.outputParameters.keySet()) {
                String value = (String)this.outputParameters.get(key);
                PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)value, PrimitiveTypes.STRING, key, key);
                map.put(key, val);
            }
            map.put("Images", images);
        } else {
            map.put("Note", new PrimitiveType(String.class.getName(), (Object)"The signal contains only one point. The charts will not be displayed.", PrimitiveTypes.STRING, "Note", "Note about the signal"));
        }
        PrimitiveType outputm = new PrimitiveType(HashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return outputm;
    }
}

