/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;

public class GdalConverter {
    static String gdalExecutorWin = "C:/Program Files (x86)/GDAL/gdal_translate";
    static String gdalExecutorLin = "/usr/bin/gdal_translate";

    public static void main1(String[] args) {
        System.out.println(GdalConverter.convertToGeoTiff("p_edulis_map.img"));
    }

    public static void main(String[] args) {
        System.out.println(GdalConverter.convertToGeoTiff(args[0]));
    }

    public static String convertToGeoTiff(String fullPathToFile) {
        String gdalConverter = "";
        if (fullPathToFile.endsWith("tiff")) {
            return fullPathToFile;
        }
        gdalConverter = System.getProperty("os.name").contains("Win") ? gdalExecutorWin : gdalExecutorLin;
        System.out.println("Executing transformation in " + System.getProperty("os.name") + "->" + gdalConverter);
        int pointIndex = fullPathToFile.lastIndexOf(".");
        if (pointIndex < 0) {
            pointIndex = fullPathToFile.length();
        }
        String geoTiffFile = String.valueOf(fullPathToFile.substring(0, pointIndex)) + ".tiff";
        String executionResult = GdalConverter.ExecuteGetLine(String.valueOf(gdalConverter) + " -of GTiff " + fullPathToFile + " " + geoTiffFile);
        if (executionResult.equalsIgnoreCase("error")) {
            return null;
        }
        return geoTiffFile;
    }

    public static String convertToASC(String fullPathToFile) {
        String gdalConverter = "";
        gdalConverter = System.getProperty("os.name").contains("Win") ? gdalExecutorWin : gdalExecutorLin;
        System.out.println("Executing transformation in " + System.getProperty("os.name") + "->" + gdalConverter);
        int pointIndex = fullPathToFile.lastIndexOf(".");
        if (pointIndex < 0) {
            pointIndex = fullPathToFile.length();
        }
        String ascTiffFile = String.valueOf(fullPathToFile.substring(0, pointIndex)) + ".asc";
        String executionResult = GdalConverter.ExecuteGetLine(String.valueOf(gdalConverter) + " -of AAIGrid " + fullPathToFile + " " + ascTiffFile);
        if (executionResult.equalsIgnoreCase("error")) {
            return null;
        }
        return ascTiffFile;
    }

    public static String ExecuteGetLine(String cmd) {
        Process process = null;
        String lastline = "";
        try {
            System.out.println("OSCommand-> Executing Control ->" + cmd);
            process = Runtime.getRuntime().exec(cmd);
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = br.readLine();
            System.out.println("OSCommand->  line->" + line);
            while (line != null) {
                try {
                    lastline = line;
                    System.out.println("OSCommand-> line->" + line);
                    line = br.readLine();
                }
                catch (EOFException e) {
                    System.out.println("OSCommand -> Process Finished with EOF");
                    break;
                }
                catch (Exception e) {
                    line = "ERROR";
                    break;
                }
            }
            System.out.println("OSCommand -> Process Finished");
        }
        catch (Throwable e) {
            System.out.println("OSCommand-> error ");
            e.printStackTrace();
            lastline = "ERROR";
        }
        process.destroy();
        System.out.println("OSCommand-> Process destroyed ");
        return lastline;
    }

    public static boolean FileCopy(String origin, String destination) {
        try {
            int c;
            File inputFile = new File(origin);
            System.out.println("OSCommand-> FileCopy-> " + inputFile.length() + " to " + inputFile.canRead());
            int counterrors = 0;
            while (inputFile.length() == 0L && counterrors < 10) {
                Thread.sleep(20L);
                ++counterrors;
            }
            File outputFile = new File(destination);
            FileReader in = new FileReader(inputFile);
            FileWriter out = new FileWriter(outputFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

