/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.connectors.wcs;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.transfer.common.TransferUtil;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.connectors.asc.ASC;
import org.gcube.dataanalysis.geo.interfaces.GISDataConnector;
import org.gcube.dataanalysis.geo.meta.OGCFormatter;
import org.gcube.dataanalysis.geo.utils.GdalConverter;
import org.gcube.dataanalysis.geo.utils.GeoTiffMetadata;
import org.gcube.dataanalysis.geo.utils.VectorOperations;

public class WCS
implements GISDataConnector {
    public String baseURL;
    public String coverage;
    public String crs = "EPSG:4326";
    public String boundingBox = "-180,-90,180,90";
    public String width = "640";
    public String height = "480";
    public String depth = null;
    public String format = "geotiff";
    public String time = null;
    public String responseCRS = "EPSG:4326";
    public String resx;
    public String resy;
    public String resz;
    public double zScale = 0.0;
    public String persistenceDir;
    public HashMap<String, String> parameters = new HashMap();

    public WCS(AlgorithmConfiguration config, String wcsURL) throws Exception {
        this.parseWCSURL(wcsURL);
        this.persistenceDir = config.getPersistencePath();
        this.retrieveZScale();
    }

    public void retrieveZScale() throws Exception {
        String uuid = null;
        try {
            String url = OGCFormatter.getWcsUrl(this.baseURL, this.coverage, this.crs, this.responseCRS, "-180,0,180,90", "1", "1", this.depth, this.format, this.resx, this.resy, this.resz, this.time, this.parameters);
            AnalysisLogger.getLogger().debug((Object)("Retrieving Z parameters: " + url));
            int urlCheck = HttpRequest.checkUrl((String)url, null, null);
            AnalysisLogger.getLogger().debug((Object)("Checking url: " + urlCheck));
            uuid = new File(this.persistenceDir, "geotiff" + UUID.randomUUID().toString().replace("-", "") + ".tiff").getAbsolutePath();
            TransferUtil downloadutil = new TransferUtil();
            downloadutil.setConnectiontimeout(120000);
            downloadutil.setTransferTimeout(120000);
            downloadutil.performTransfer(new URI(url), uuid);
            GeoTiffMetadata meta = new GeoTiffMetadata();
            meta.readAndDisplayMetadata(uuid);
            this.zScale = meta.zScale;
            AnalysisLogger.getLogger().debug((Object)("Retrieved Z Scale: " + this.zScale));
        }
        catch (Throwable throwable) {
            if (uuid != null) {
                AnalysisLogger.getLogger().debug((Object)("Deleting point-tiff file :" + uuid + " " + new File(uuid).delete()));
            }
            throw throwable;
        }
        if (uuid != null) {
            AnalysisLogger.getLogger().debug((Object)("Deleting point-tiff file :" + uuid + " " + new File(uuid).delete()));
        }
    }

    public void parseWCSURL(String wcsURL) {
        String[] elements;
        int questionIDX = wcsURL.indexOf("?");
        if (questionIDX < 0) {
            this.baseURL = wcsURL;
            return;
        }
        this.baseURL = wcsURL.substring(0, questionIDX);
        String toParse = wcsURL.substring(questionIDX + 1);
        String[] stringArray = elements = toParse.split("&");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            int eqIdx = element.indexOf("=");
            if (eqIdx >= 0) {
                String paramName = element.substring(0, eqIdx);
                String paramValue = element.substring(eqIdx + 1);
                this.associateParameter(paramName, paramValue);
            }
            ++n2;
        }
        AnalysisLogger.getLogger().debug((Object)"WCS Parsing finished");
    }

    private void associateParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("COVERAGE")) {
            this.coverage = value;
        } else if (parameter.equalsIgnoreCase("CRS")) {
            this.crs = value;
        } else if (parameter.equalsIgnoreCase("BBOX")) {
            this.boundingBox = value;
        } else if (parameter.equalsIgnoreCase("WIDTH")) {
            this.width = value;
        } else if (parameter.equalsIgnoreCase("HEIGHT")) {
            this.height = value;
        } else if (parameter.equalsIgnoreCase("DEPTH")) {
            this.depth = value;
        } else if (parameter.equalsIgnoreCase("FORMAT")) {
            this.format = value;
        } else if (parameter.equalsIgnoreCase("RESX")) {
            this.resx = value;
        } else if (parameter.equalsIgnoreCase("RESY")) {
            this.resy = value;
        } else if (parameter.equalsIgnoreCase("RESZ")) {
            this.resz = value;
        } else if (parameter.equalsIgnoreCase("TIME")) {
            this.time = value;
        } else if (parameter.equalsIgnoreCase("RESPONSE_CRS")) {
            this.responseCRS = value;
        } else if (!(parameter.equalsIgnoreCase("service") || parameter.equalsIgnoreCase("version") || parameter.equalsIgnoreCase("request"))) {
            this.parameters.put(parameter, value);
        }
    }

    @Override
    public List<Double> getFeaturesInTimeInstantAndArea(String layerURL, String layerName, int time, List<Tuple<Double>> coordinates3d, double BBxL, double BBxR, double BByL, double BByR) throws Exception {
        List<Double> list;
        String ascFile;
        block9: {
            if (time > 0) {
                throw new Exception("Time is currently not supported in WCS");
            }
            String uuid = null;
            ascFile = null;
            try {
                String resolutionx = this.resx;
                String resolutiony = this.resy;
                if (coordinates3d.size() > 1) {
                    double x1 = (Double)coordinates3d.get(0).getElements().get(0);
                    double x2 = (Double)coordinates3d.get(1).getElements().get(0);
                    resolutionx = "" + Math.abs(x2 - x1);
                    double y1 = (Double)coordinates3d.get(0).getElements().get(0);
                    double y2 = (Double)coordinates3d.get(1).getElements().get(0);
                    resolutiony = "" + Math.abs(y2 - y1);
                }
                AnalysisLogger.getLogger().debug((Object)("Resolution parameters: resx: " + resolutionx + " resy: " + resolutiony));
                String url = OGCFormatter.getWcsUrl(this.baseURL, this.coverage, this.crs, this.responseCRS, BBxL + "," + BByL + "," + BBxR + "," + BByR, this.width, this.height, this.depth, this.format, resolutionx, resolutiony, this.resz, "" + time, this.parameters);
                AnalysisLogger.getLogger().debug((Object)("Retrieving Z parameters: " + url));
                int urlCheck = HttpRequest.checkUrl((String)url, null, null);
                AnalysisLogger.getLogger().debug((Object)("Checking url: " + urlCheck));
                String randomFile = new File(this.persistenceDir, "geotiff" + UUID.randomUUID().toString().replace("-", "")).getAbsolutePath();
                uuid = String.valueOf(randomFile) + ".tiff";
                TransferUtil downloadutil = new TransferUtil();
                downloadutil.setConnectiontimeout(120000);
                downloadutil.setTransferTimeout(120000);
                downloadutil.performTransfer(new URI(url), uuid);
                AnalysisLogger.getLogger().debug((Object)("Converting to ASCII file: " + uuid));
                ascFile = GdalConverter.convertToASC(uuid);
                AnalysisLogger.getLogger().debug((Object)("Conversion to ASCII complete: " + ascFile));
                ASC asc = new ASC();
                List<Double> points = asc.getFeaturesInTimeInstantAndArea(ascFile, layerName, time, coordinates3d, BBxL, BBxR, BByL, BByR);
                AnalysisLogger.getLogger().debug((Object)("Retrieved: " + points.size() + " points"));
                list = points;
                if (uuid == null) break block9;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (uuid != null) {
                        AnalysisLogger.getLogger().debug((Object)("Deleting tiff:" + new File(uuid).delete()));
                        AnalysisLogger.getLogger().debug((Object)("Deleting tiff aux file:" + new File(uuid.replace(".tiff", ".prj")).delete()));
                    }
                    if (ascFile != null) {
                        AnalysisLogger.getLogger().debug((Object)("Deleting asc:" + new File(ascFile).delete()));
                        AnalysisLogger.getLogger().debug((Object)("Deleting asc aux file:" + new File(String.valueOf(ascFile) + ".aux.xml").delete()));
                    }
                    throw throwable;
                }
            }
            AnalysisLogger.getLogger().debug((Object)("Deleting tiff:" + new File(uuid).delete()));
            AnalysisLogger.getLogger().debug((Object)("Deleting tiff aux file:" + new File(uuid.replace(".tiff", ".prj")).delete()));
        }
        if (ascFile != null) {
            AnalysisLogger.getLogger().debug((Object)("Deleting asc:" + new File(ascFile).delete()));
            AnalysisLogger.getLogger().debug((Object)("Deleting asc aux file:" + new File(String.valueOf(ascFile) + ".aux.xml").delete()));
        }
        return list;
    }

    @Override
    public double getMinZ(String layerURL, String layerName) {
        return 0.0;
    }

    @Override
    public double getMaxZ(String layerURL, String layerName) {
        return 0.0;
    }

    public static void main(String[] args) throws Exception {
        String wcsUrl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver/wcs/wcs?service=wcs&version=1.0.0&request=GetCoverage&coverage=aquamaps:WorldClimBio2&CRS=EPSG:4326&bbox=-180,0,180,90&width=1&height=1&format=geotiff&RESPONSE_CRS=EPSG:4326";
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setGcubeScope("/d4science.research-infrastructures.eu/gCubeApps/BiodiversityLab");
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        WCS wcs = new WCS(config, wcsUrl);
        List<Tuple<Double>> triplets = VectorOperations.generateCoordinateTripletsInBoundingBox(-30.0, 30.0, -30.0, 30.0, 0.0, 0.5, 0.5);
        List<Double> points = wcs.getFeaturesInTimeInstantAndArea(wcsUrl, "", 0, triplets, -180.0, 180.0, -90.0, 90.0);
        AnalysisLogger.getLogger().debug((Object)("points:" + points));
    }
}

