/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.infrastructure;

import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkPublisher;
import org.gcube.spatial.data.geonetwork.GeoNetworkReader;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.configuration.ConfigurationManager;
import org.geotoolkit.metadata.iso.identification.DefaultDataIdentification;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Resolution;

public class GeoNetworkInspector {
    private String geonetworkUrl = "http://geoserver-dev2.d4science-ii.research-infrastructures.eu/geonetwork/";
    private String geonetworkUser = "admin";
    private String geonetworkPwd = "admin";
    private String scope = "/gcube/devsec";
    Configuration gnconfiguration;

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public static double getResolution(Metadata meta) {
        double res = 0.0;
        try {
            DefaultDataIdentification ddi = (DefaultDataIdentification)meta.getIdentificationInfo().iterator().next();
            for (Resolution r : ddi.getSpatialResolutions()) {
                Double rr = r.getDistance();
                if (rr == null) {
                    rr = r.getEquivalentScale().doubleValue();
                }
                if (rr == null || !(rr > res)) continue;
                res = rr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)"Could not get Data Identification");
        }
        AnalysisLogger.getLogger().debug((Object)("Calculated Resolution is:" + res));
        return res;
    }

    public String getGeoserverLink(Metadata meta) {
        String wcslink;
        String wfslink;
        String link = null;
        String geoserverString = "/geoserver/";
        String geoserverEndString = "/geoserver?";
        String wmslink = this.getWMSLink(meta);
        if (wmslink != null) {
            int idx = wmslink.indexOf(geoserverString);
            if (idx < 0) {
                idx = wmslink.indexOf(geoserverEndString);
            }
            if (idx > 0) {
                link = wmslink.substring(0, idx + geoserverString.length() - 1);
                return link;
            }
        }
        if ((wfslink = this.getWFSLink(meta)) != null) {
            int idx = wfslink.indexOf(geoserverString);
            if (idx < 0) {
                idx = wfslink.indexOf(geoserverEndString);
            }
            if (idx > 0) {
                link = wfslink.substring(0, idx + geoserverString.length() - 1);
                return link;
            }
        }
        if ((wcslink = this.getWCSLink(meta)) != null) {
            int idx = wcslink.indexOf(geoserverString);
            if (idx < 0) {
                idx = wcslink.indexOf(geoserverEndString);
            }
            if (idx > 0) {
                link = wcslink.substring(0, idx + geoserverString.length() - 1);
                return link;
            }
        }
        if (link == null) {
            System.out.println("NO GEOSERVER LINK WAS FOUND ACCORDING TO THE CRITERION");
        }
        return link;
    }

    private String searchInUrl(Metadata meta, String criterion) {
        String link = null;
        block4: for (DigitalTransferOptions option : meta.getDistributionInfo().getTransferOptions()) {
            block5: for (OnlineResource resource : option.getOnLines()) {
                String tlink = "";
                try {
                    tlink = resource.getLinkage().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tlink.toLowerCase().contains(criterion.toLowerCase())) {
                    link = tlink;
                    continue block4;
                }
                if (!tlink.toLowerCase().startsWith("http:")) continue;
                try {
                    URL obj = new URL(tlink);
                    URLConnection conn = obj.openConnection();
                    Map<String, List<String>> map = conn.getHeaderFields();
                    for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                        String value = entry.getValue().toString();
                        if (!value.toLowerCase().contains("filename=")) continue;
                        AnalysisLogger.getLogger().debug((Object)("Searching in http header: found " + value));
                        if (!value.toLowerCase().contains(criterion)) continue;
                        link = tlink;
                        continue block5;
                    }
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)("Malformed url for link: " + tlink));
                }
            }
        }
        if (link == null) {
            System.out.println("NO ONLINE LINK WAS FOUND ACCORDING TO THE CRITERION :" + criterion);
        }
        return link;
    }

    private String searchLayerNameInMeta(Metadata meta) {
        String innerlayername = null;
        block2: for (DigitalTransferOptions option : meta.getDistributionInfo().getTransferOptions()) {
            for (OnlineResource resource : option.getOnLines()) {
                String layername = resource.getName();
                String link = "";
                try {
                    link = resource.getLinkage().toString().toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (layername == null || !link.contains("wms")) continue;
                innerlayername = layername;
                continue block2;
            }
        }
        if (innerlayername == null) {
            System.out.println("NO LAYER NAME WAS FOUND IN TRANSFER OPTIONS");
        }
        return innerlayername;
    }

    public String getHttpLink(Metadata meta) {
        return this.searchInUrl(meta, "http");
    }

    public String getWFSLink(Metadata meta) {
        return this.searchInUrl(meta, "service=wfs");
    }

    public String getWMSLink(Metadata meta) {
        return this.searchInUrl(meta, "service=wms");
    }

    public String getWCSLink(Metadata meta) {
        return this.searchInUrl(meta, "service=wcs");
    }

    public String getGeoTiffLink(Metadata meta) {
        String url = this.searchInUrl(meta, ".tiff");
        if (url == null) {
            url = this.searchInUrl(meta, ".geotiff");
        }
        if (url == null) {
            url = this.searchInUrl(meta, ".tif");
        }
        if (url == null) {
            url = this.searchInUrl(meta, ".geotif");
        }
        return url;
    }

    public String getASCLink(Metadata meta) {
        return this.searchInUrl(meta, ".asc");
    }

    public String getOpenDapLink(Metadata meta) {
        String url = this.searchInUrl(meta, "/dodsC");
        return url;
    }

    public String getThreddsLink(Metadata meta) {
        return this.searchInUrl(meta, "catalog.xml");
    }

    public String getLayerName(Metadata meta) {
        AnalysisLogger.getLogger().debug((Object)"Retrieving Layer Name");
        String wmslink = this.getWMSLink(meta);
        String layer = null;
        if (wmslink != null) {
            String[] finders = new String[]{"layers=", "LAYERS=", "Layers="};
            AnalysisLogger.getLogger().debug((Object)"WMS layer found!");
            int idxfinder = -1;
            String[] stringArray = finders;
            int n = finders.length;
            int n2 = 0;
            while (n2 < n) {
                String finder = stringArray[n2];
                idxfinder = wmslink.indexOf(finder);
                if (idxfinder > -1) break;
                ++n2;
            }
            if (idxfinder > 0) {
                AnalysisLogger.getLogger().debug((Object)"Searching for Layer Name inside the WMS Link");
                wmslink = wmslink.substring(idxfinder);
                int andIdx = wmslink.indexOf("&");
                if (andIdx < 0) {
                    andIdx = wmslink.length();
                }
                layer = wmslink.substring(finders[0].length(), andIdx).trim();
            } else {
                AnalysisLogger.getLogger().debug((Object)"Searching for Layer Name inside the file");
                layer = this.searchLayerNameInMeta(meta);
            }
        } else {
            String wfslink = this.getWFSLink(meta);
            String[] finders = new String[]{"typename=", "TYPENAME=", "typeName=", "TypeName"};
            if (wfslink != null) {
                AnalysisLogger.getLogger().debug((Object)"WFS layer found!");
                int idxfinder = -1;
                String[] stringArray = finders;
                int n = finders.length;
                int n3 = 0;
                while (n3 < n) {
                    String finder = stringArray[n3];
                    idxfinder = wfslink.indexOf(finder);
                    if (idxfinder > -1) break;
                    ++n3;
                }
                if (idxfinder > 0) {
                    AnalysisLogger.getLogger().debug((Object)"Searching for Layer Name inside the WMS Link");
                    wfslink = wfslink.substring(idxfinder);
                    int andIdx = wfslink.indexOf("&");
                    if (andIdx < 0) {
                        andIdx = wfslink.length();
                    }
                    layer = wfslink.substring(finders[0].length(), andIdx).trim();
                } else {
                    AnalysisLogger.getLogger().debug((Object)"Searching for Layer Name inside the file");
                    layer = this.searchLayerNameInMeta(meta);
                }
            }
        }
        return layer;
    }

    public boolean isNetCDFFile(Metadata meta) {
        return this.getOpenDapLink(meta) != null;
    }

    public boolean isAscFile(Metadata meta) {
        String httplink = this.getASCLink(meta);
        return httplink != null;
    }

    public boolean isWFS(Metadata meta) {
        String httplink = this.getWFSLink(meta);
        return httplink != null;
    }

    public boolean isWCS(Metadata meta) {
        String httplink = this.getWCSLink(meta);
        return httplink != null;
    }

    public boolean isGeoTiff(Metadata meta) {
        String httplink = this.getGeoTiffLink(meta);
        return httplink != null;
    }

    public GeoNetworkReader initGeoNetworkReader() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Features Manager: configuring GeoNetwork");
        if (this.scope != null) {
            ScopeProvider.instance.set(this.scope);
        } else {
            AnalysisLogger.getLogger().debug((Object)"Features Manager: Using manual configuration of GeoNetwork");
            class CustomConfiguration
            implements Configuration {
                CustomConfiguration() {
                }

                public String getGeoNetworkEndpoint() {
                    return GeoNetworkInspector.this.geonetworkUrl;
                }

                public Map<LoginLevel, String> getGeoNetworkPasswords() {
                    HashMap<LoginLevel, String> map = new HashMap<LoginLevel, String>();
                    map.put(LoginLevel.DEFAULT, GeoNetworkInspector.this.geonetworkPwd);
                    return map;
                }

                public Map<LoginLevel, String> getGeoNetworkUsers() {
                    HashMap<LoginLevel, String> map = new HashMap<LoginLevel, String>();
                    map.put(LoginLevel.DEFAULT, GeoNetworkInspector.this.geonetworkUser);
                    return map;
                }

                public int getScopeGroup() {
                    return 0;
                }
            }
            ConfigurationManager.setConfiguration(CustomConfiguration.class);
        }
        AnalysisLogger.getLogger().debug((Object)"Initializing GeoNetwork");
        GeoNetworkPublisher gn = GeoNetwork.get();
        AnalysisLogger.getLogger().debug((Object)("Using the following Geonetwork: " + gn.getConfiguration().getGeoNetworkEndpoint() + " in scope " + this.scope));
        return gn;
    }

    public String getGeonetworkURLFromScope() throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        return gn.getConfiguration().getGeoNetworkEndpoint();
    }

    public String getGeonetworkUserFromScope() throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        return (String)gn.getConfiguration().getGeoNetworkUsers().get(LoginLevel.DEFAULT);
    }

    public String getGeonetworkPasswordFromScope() throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        return (String)gn.getConfiguration().getGeoNetworkPasswords().get(LoginLevel.DEFAULT);
    }

    private Metadata getGNInfobyTitle(String info) throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        gn.login(LoginLevel.DEFAULT);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.title, info);
        GNSearchResponse resp = gn.query(req);
        Metadata meta = null;
        if (resp.getCount() != 0) {
            for (GNSearchResponse.GNMetadata metadata : resp) {
                try {
                    meta = gn.getById(metadata.getUUID());
                    break;
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)"Error retrieving information for some metadata");
                }
            }
        }
        return meta;
    }

    public List<Metadata> getAllGNInfobyTitle(String info, String tolerance) throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        gn.login(LoginLevel.DEFAULT);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.title, info);
        req.addConfig(GNSearchRequest.Config.similarity, tolerance);
        GNSearchResponse resp = gn.query(req);
        Metadata meta = null;
        ArrayList<Metadata> metadatalist = new ArrayList<Metadata>();
        if (resp.getCount() != 0) {
            for (GNSearchResponse.GNMetadata metadata : resp) {
                try {
                    meta = gn.getById(metadata.getUUID());
                    metadatalist.add(meta);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)"Error retrieving information for some metadata");
                }
            }
        }
        return metadatalist;
    }

    public List<Metadata> getAllGNInfobyText(String info, String tolerance) throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        gn.login(LoginLevel.DEFAULT);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.any, info);
        req.addConfig(GNSearchRequest.Config.similarity, tolerance);
        GNSearchResponse resp = gn.query(req);
        Metadata meta = null;
        ArrayList<Metadata> metadatalist = new ArrayList<Metadata>();
        if (resp.getCount() != 0) {
            for (GNSearchResponse.GNMetadata metadata : resp) {
                try {
                    meta = gn.getById(metadata.getUUID());
                    metadatalist.add(meta);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)"Error retrieving information for some metadata");
                }
            }
        }
        return metadatalist;
    }

    private List<Metadata> getFastGNInfobyTitle(String info, String completeTitle, String tolerance) throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        gn.login(LoginLevel.DEFAULT);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.title, info);
        req.addConfig(GNSearchRequest.Config.similarity, tolerance);
        GNSearchResponse resp = gn.query(req);
        Metadata meta = null;
        ArrayList<Metadata> metadatalist = new ArrayList<Metadata>();
        if (resp.getCount() != 0) {
            AnalysisLogger.getLogger().debug((Object)"Retrieving information ...");
            for (GNSearchResponse.GNMetadata metadata : resp) {
                try {
                    meta = gn.getById(metadata.getUUID());
                    Identification id = (Identification)meta.getIdentificationInfo().iterator().next();
                    String title = id.getCitation().getTitle().toString();
                    if (!title.equalsIgnoreCase(completeTitle)) continue;
                    AnalysisLogger.getLogger().debug((Object)("Found UUID:" + metadata.getUUID()));
                    metadatalist.add(meta);
                    break;
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)"Error retrieving information for some metadata");
                }
            }
            AnalysisLogger.getLogger().debug((Object)"Information Successfully Retrieved");
        }
        return metadatalist;
    }

    private Metadata getGNInfobyUUID(String UUID2) throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        gn.login(LoginLevel.DEFAULT);
        Metadata meta = gn.getById(UUID2);
        AnalysisLogger.getLogger().debug((Object)("Layer with UUID: " + UUID2 + " successfully Retrieved!"));
        return meta;
    }

    public Metadata getGNInfobyUUIDorName(String layerUUIDorTitle) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("MapsComparator: Getting layer with UUID..." + layerUUIDorTitle));
        Metadata meta = null;
        try {
            meta = this.getGNInfobyUUID(layerUUIDorTitle);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"MapsComparator: Impossible to get layer as UUID");
        }
        if (meta == null) {
            AnalysisLogger.getLogger().debug((Object)("MapsComparator: NO UUID Available - Trying with NAME..." + layerUUIDorTitle));
            try {
                meta = this.checkForMetadatabyTitle(GeoNetworkInspector.treatTitleForGN(layerUUIDorTitle), layerUUIDorTitle);
            }
            catch (Exception e) {
                throw new Exception("Layer does not exist");
            }
        }
        return meta;
    }

    private Metadata checkForMetadatabyTitle(String searchString, String completetitle) throws Exception {
        return this.checkForMetadatabyTitle(searchString, completetitle, "");
    }

    private Metadata checkForMetadatabyTitle(String searchString, String completetitle, String filename) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Searching for: " + searchString));
        List<Metadata> mlist = this.getFastGNInfobyTitle(searchString, completetitle, "1");
        AnalysisLogger.getLogger().debug((Object)("Found:" + mlist.size() + " results"));
        Metadata mfound = null;
        for (Metadata m : mlist) {
            Identification id = (Identification)m.getIdentificationInfo().iterator().next();
            String title = id.getCitation().getTitle().toString();
            if (!completetitle.equalsIgnoreCase(title)) continue;
            mfound = m;
            break;
        }
        return mfound;
    }

    public String getGeonetworkUrl() {
        return this.geonetworkUrl;
    }

    public void setGeonetworkUrl(String geonetworkUrl) {
        this.geonetworkUrl = geonetworkUrl;
    }

    public String getGeonetworkUser() {
        return this.geonetworkUser;
    }

    public void setGeonetworkUser(String geonetworkUser) {
        this.geonetworkUser = geonetworkUser;
    }

    public String getGeonetworkPwd() {
        return this.geonetworkPwd;
    }

    public void setGeonetworkPwd(String geonetworkPwd) {
        this.geonetworkPwd = geonetworkPwd;
    }

    public static String treatTitleForGN(String origLayerTitle) {
        String layerTitle = origLayerTitle.toLowerCase();
        int idx = layerTitle.indexOf(" from [");
        String layerTitle2 = layerTitle;
        if (idx > 0) {
            layerTitle2 = layerTitle.toLowerCase().substring(0, idx).trim();
        } else {
            idx = layerTitle.indexOf(" in [");
            if (idx > 0) {
                layerTitle2 = layerTitle.toLowerCase().substring(0, idx).trim();
            } else {
                idx = layerTitle.indexOf("(");
                if (idx > 0) {
                    layerTitle2 = layerTitle.toLowerCase().substring(0, idx).trim();
                }
            }
        }
        layerTitle2 = layerTitle2.replaceAll("(\\(.*\\))", " ");
        layerTitle2 = layerTitle2.replace("_", " ").replace("-", " ").replace("(", " ").replace(")", " ");
        String punct = "[!\"#$%&'*+,./:;<=>?@\\^_`{|}~-]";
        layerTitle2 = layerTitle2.replaceAll("( |^)+[^A-Za-z]+(" + punct + ")*[^A-Za-z]*", " ").trim();
        return layerTitle2.replaceAll(punct, " ").replaceAll("( )+", " ");
    }

    public static void main1(String[] args) throws Exception {
        String title = "geopotential height";
        GeoNetworkInspector fm = new GeoNetworkInspector();
        Metadata meta = fm.getGNInfobyTitle(title);
        System.out.println("is file? " + fm.isNetCDFFile(meta));
        System.out.println("opendap: " + fm.getOpenDapLink(meta));
        System.out.println("wcs:" + fm.getWCSLink(meta));
        System.out.println("wms:" + fm.getWMSLink(meta));
        System.out.println("thredds:" + fm.getThreddsLink(meta));
    }

    public static void main(String[] args) throws Exception {
        System.out.println(GeoNetworkInspector.treatTitleForGN("sea/land/lake/ice field composite mask from"));
    }
}

