/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.batch;

import it.geosolutions.geonetwork.GNClient;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.geo.meta.GenericLayerMetadata;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.configuration.DefaultConfiguration;
import org.gcube.spatial.data.geonetwork.model.Account;
import org.gcube.spatial.data.geonetwork.model.ScopeConfiguration;
import org.gcube.spatial.data.geonetwork.model.faults.MissingConfigurationException;
import org.gcube.spatial.data.geonetwork.utils.UserUtils;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.identification.Identification;

public class OpenLayerToVREs {
    static String geonetworkurl = "http://geonetwork.d4science.org/geonetwork/";
    static String geonetworkUser = "admin";
    static String geonetworkPwd = "kee9GeeK";

    public static void main(String[] args) throws Exception {
        String targetScope = "/d4science.research-infrastructures.eu/gCubeApps";
        String title = "Oscar";
        OpenLayerToVREs.changeScope2(title, targetScope, targetScope);
    }

    public static void changeScope3(String searchTitle, String title, String startScope, String targetScope) throws Exception {
        ScopeProvider.instance.set("/gcube/devsec");
        GeoNetworkAdministration reader = GeoNetwork.get();
        reader.login(LoginLevel.ADMIN);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.any, searchTitle);
        req.addConfig(GNSearchRequest.Config.similarity, "1");
        GNSearchResponse resp = reader.query(req);
        Long id = 0L;
        Metadata meta = null;
        int N = resp.getCount();
        System.out.println("Found N layers: " + N);
        int i = 1;
        for (GNSearchResponse.GNMetadata metadata : resp) {
            System.out.println("Layer " + i + " of " + N);
            ++i;
            id = metadata.getId();
            System.out.println("ID " + id);
            System.out.println("Name " + metadata.getInfo().getName());
            meta = reader.getById(id.longValue());
            Identification idf = (Identification)meta.getIdentificationInfo().iterator().next();
            String otitle = idf.getCitation().getTitle().toString();
            System.out.println("Title " + otitle);
            if (!otitle.toLowerCase().contains(title.toLowerCase())) {
                System.out.println("Invalid layer");
                continue;
            }
            System.out.println("Inserting meta in prod " + otitle);
            GNClient client = new GNClient(geonetworkurl);
            client.login(geonetworkUser, geonetworkPwd);
            File tmetafile = GenericLayerMetadata.meta2File(meta);
            int scopePublicGroup = 23;
            client.insertMetadata(new GNInsertConfiguration("" + scopePublicGroup, "datasets", "_none_", Boolean.valueOf(true)), tmetafile);
            tmetafile.delete();
            System.out.println("Done with " + otitle);
            Thread.sleep(2000L);
        }
        System.out.println("All done");
    }

    public static void changeScope2(String title, String startScope, String targetScope) throws Exception {
        ScopeProvider.instance.set(startScope);
        GeoNetworkAdministration reader = GeoNetwork.get();
        reader.login(LoginLevel.SCOPE);
        DefaultConfiguration geonetworkCfg = (DefaultConfiguration)reader.getConfiguration();
        Map accounts = geonetworkCfg.getScopeConfiguration().getAccounts();
        Account account = (Account)accounts.get(Account.Type.SCOPE);
        String geonetworkScopeUser = account.getUser();
        String geonetworkScopePassword = account.getPassword();
        Integer scopePublicGroup = geonetworkCfg.getScopeConfiguration().getPublicGroup();
        System.out.println("GeoNetwork user " + geonetworkScopeUser);
        System.out.println("GeoNetwork password " + geonetworkScopePassword);
        System.out.println("GeoNetwork scope Public Group " + scopePublicGroup);
        System.out.println("GeoNetwork Admin user " + geonetworkCfg.getAdminAccount().getUser());
        System.out.println("GeoNetwork Admin password " + geonetworkCfg.getAdminAccount().getPassword());
        System.out.println("GeoNetwork scope Public Group " + scopePublicGroup);
        reader = GeoNetwork.get();
        reader.login(LoginLevel.ADMIN);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.any, title);
        req.addConfig(GNSearchRequest.Config.similarity, "1");
        GNSearchResponse resp = reader.query(req);
        Long id = 0L;
        Metadata meta = null;
        int N = resp.getCount();
        System.out.println("Found N layers: " + N);
        int i = 1;
        for (GNSearchResponse.GNMetadata metadata : resp) {
            System.out.println("Layer " + i + " of " + N);
            ++i;
            id = metadata.getId();
            System.out.println("ID " + id);
            System.out.println("Name " + metadata.getInfo().getName());
            meta = reader.getById(id.longValue());
            Identification idf = (Identification)meta.getIdentificationInfo().iterator().next();
            String otitle = idf.getCitation().getTitle().toString();
            System.out.println("Title " + otitle);
            if (!otitle.toLowerCase().contains(title.toLowerCase())) {
                System.out.println("Invalid layer");
                continue;
            }
            System.out.println("Publishing " + id);
            ScopeConfiguration targetConfiguration = null;
            targetScope = targetScope.substring(targetScope.lastIndexOf("/") + 1);
            System.out.println("target scope " + targetScope);
            for (ScopeConfiguration configuration : reader.getConfiguration().getExistingConfigurations()) {
                if (!configuration.getAssignedScope().equals(targetScope)) continue;
                targetConfiguration = configuration;
            }
            if (targetConfiguration == null) {
                throw new MissingConfigurationException("Scope " + targetScope + " has no configuration");
            }
            int targetUserId = UserUtils.getByName((Set)reader.getUsers(), (String)((Account)targetConfiguration.getAccounts().get(Account.Type.SCOPE)).getUser()).getId();
            int targetGroup = targetConfiguration.getDefaultGroup();
            System.out.println("ID " + id + " targetUserId " + targetUserId + " targetGroup " + targetGroup + " Public group " + scopePublicGroup);
            System.out.println("deleting meta " + id);
            GNClient client = new GNClient(geonetworkurl);
            client.login(geonetworkUser, geonetworkPwd);
            client.deleteMetadata(id.longValue());
            System.out.println("inserting meta");
            client = new GNClient(geonetworkurl);
            client.login(geonetworkScopeUser, geonetworkScopePassword);
            File tmetafile = GenericLayerMetadata.meta2File(meta);
            try {
                GeoNetworkAdministration readerScope = GeoNetwork.get();
                readerScope.login(LoginLevel.SCOPE);
                GNInsertConfiguration configuration = readerScope.getCurrentUserConfiguration("datasets", "_none_");
                ((DefaultMetadata)meta).setFileIdentifier(UUID.randomUUID().toString());
                readerScope.insertMetadata(configuration, meta);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Using standard client");
                long metaid = client.insertMetadata(new GNInsertConfiguration("" + scopePublicGroup, "datasets", "_none_", Boolean.valueOf(true)), tmetafile);
                System.out.println("Generated Metaid " + metaid);
            }
            tmetafile.delete();
            System.out.println("Done with " + otitle);
            Thread.sleep(2000L);
        }
        System.out.println("All done");
    }

    public static void changeScope(String title, String startScope, String targetScope) throws Exception {
        ScopeProvider.instance.set(startScope);
        GeoNetworkAdministration reader = GeoNetwork.get();
        reader.login(LoginLevel.ADMIN);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.any, title);
        req.addConfig(GNSearchRequest.Config.similarity, "1");
        GNSearchResponse resp = reader.query(req);
        Long id = 0L;
        Iterator i$ = resp.iterator();
        if (i$.hasNext()) {
            GNSearchResponse.GNMetadata metadata = (GNSearchResponse.GNMetadata)i$.next();
            id = metadata.getId();
            System.out.println("ID " + id);
            System.out.println("Name " + metadata.getInfo().getName());
            Metadata meta = reader.getById(id.longValue());
            Identification idf = (Identification)meta.getIdentificationInfo().iterator().next();
            String otitle = idf.getCitation().getTitle().toString();
            System.out.println("Title " + otitle);
        }
        System.out.println("Publishing " + id);
        ScopeConfiguration targetConfiguration = null;
        targetScope = "gCubeApps";
        for (ScopeConfiguration configuration : reader.getConfiguration().getExistingConfigurations()) {
            if (!configuration.getAssignedScope().equals(targetScope)) continue;
            targetConfiguration = configuration;
        }
        if (targetConfiguration == null) {
            throw new MissingConfigurationException("Scope " + targetScope + " has no configuration");
        }
        int targetUserId = UserUtils.getByName((Set)reader.getUsers(), (String)((Account)targetConfiguration.getAccounts().get(Account.Type.SCOPE)).getUser()).getId();
        int targetGroup = targetConfiguration.getDefaultGroup();
        System.out.println("ID " + id + " targetUserId " + targetUserId + " targetGroup " + targetGroup);
        List<Long> ids = Collections.singletonList(Long.valueOf(id));
        reader.assignOwnership(ids, Integer.valueOf(targetUserId), Integer.valueOf(targetGroup));
        System.out.println("Assigned " + id);
    }
}

