/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.matrixmodel;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.geo.interfaces.GISDataConnector;
import org.gcube.dataanalysis.geo.matrixmodel.MatrixExtractor;

public class ZExtractor
extends MatrixExtractor {
    public double zmin;
    public double zmax;

    public ZExtractor(AlgorithmConfiguration configuration) {
        super(configuration);
    }

    public double[] extractZ(String layerTitle, double x, double y, int timeIndex, double resolution) throws Exception {
        double[] signal = new double[maxzLength];
        if (layerTitle == null) {
            layerTitle = "";
        }
        GISDataConnector connector = this.getConnector(layerTitle, resolution);
        this.zmin = connector.getMinZ(this.layerURL, this.layerName);
        this.zmax = connector.getMaxZ(this.layerURL, this.layerName);
        AnalysisLogger.getLogger().debug((Object)("ZExtractor: minimum Z " + this.zmin + " maximum Z:" + this.zmax + " step: " + resolution));
        int zcounter = 0;
        if (resolution == 0.0) {
            resolution = 1.0;
        }
        double z = this.zmin;
        while (z <= this.zmax) {
            try {
                if (z % 100.0 == 0.0) {
                    AnalysisLogger.getLogger().debug((Object)("Matrix Extractor-> Extracting Z value " + z));
                }
                double[][] values = this.extractXYGridWithFixedTZ(layerTitle, timeIndex, x, x, y, y, z, resolution, resolution, true);
                signal[zcounter] = values[0][0];
                ++zcounter;
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)"Matrix Extractor-> No More Time Intervals!");
                break;
            }
            z += resolution;
        }
        AnalysisLogger.getLogger().debug((Object)("Matrix Extractor-> Signal Length:" + zcounter));
        double[] dsignal = new double[zcounter];
        int i = 0;
        while (i < zcounter) {
            dsignal[i] = signal[i];
            ++i;
            ++i;
        }
        return dsignal;
    }
}

