/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.matrixmodel;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.geo.matrixmodel.MatrixExtractor;

public class TimeSeriesExtractor
extends MatrixExtractor {
    public TimeSeriesExtractor(AlgorithmConfiguration configuration) {
        super(configuration);
    }

    public double[] extractT(String layerTitle, double x, double y, double z, double resolution) throws Exception {
        double[] signal = new double[maxSignalLength];
        int t = 0;
        this.log = false;
        try {
            do {
                if (t % 100 == 0) {
                    AnalysisLogger.getLogger().debug((Object)("Matrix Extractor-> Extracting Time Instant " + t));
                }
                double[][] values = this.extractXYGridWithFixedTZ(layerTitle, t, x, x, y, y, z, resolution, resolution, true);
                signal[t] = values[0][0];
            } while (++t != maxSignalLength);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("Matrix Extractor-> No More Time Intervals! " + e.getMessage()));
        }
        AnalysisLogger.getLogger().debug((Object)("Matrix Extractor-> Signal Length:" + t));
        double[] dsignal = new double[t];
        int i = 0;
        while (i < t) {
            dsignal[i] = signal[i];
            ++i;
            ++i;
        }
        this.log = true;
        return dsignal;
    }

    public double[] extractT(String layerTitle) throws Exception {
        return this.extractT(layerTitle, 0.0, 0.0, 0.0, 0.0);
    }
}

