/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import it.cnr.aquamaps.CSquare;
import it.cnr.aquamaps.CSquareParser;
import scala.collection.Iterator;
import scalala.tensor.Vector;

public class CSquareCodesConverter {
    double currentLat;
    double currentLong;
    double currentResolution;

    public static String convertHalfDegree(double x, double y) {
        if (x == 0.0) {
            x = 0.25;
        }
        if (y == 0.0) {
            y = 0.25;
        }
        String csquare = CSquare.centroidToCode((double)x, (double)y, (double)0.5);
        return csquare;
    }

    public static String convertAtResolution(double x, double y, double resolution) {
        if (resolution == 0.0) {
            resolution = 0.1;
        }
        if (x == 0.0) {
            x = resolution;
        }
        if (y == 0.0) {
            y = resolution;
        }
        String csquare = CSquare.centroidToCode((double)x, (double)y, (double)resolution);
        return csquare;
    }

    public void parse(String csquare) {
        CSquareParser parser = CSquare.parser();
        CSquare square = parser.parse(csquare);
        this.currentResolution = square.size();
        Vector coords = square.center();
        Iterator iterator = coords.valuesIterator();
        this.currentLong = Double.parseDouble("" + iterator.next());
        this.currentLat = Double.parseDouble("" + iterator.next());
    }

    public static void main(String[] args) {
        CSquareCodesConverter converter = new CSquareCodesConverter();
        String csquare = CSquareCodesConverter.convertAtResolution(55.5, 20.5, 0.5);
        System.out.println(csquare);
        converter.parse("1010:132:3");
        System.out.println("lat:" + converter.getCurrentLat());
        System.out.println("long:" + converter.getCurrentLong());
        System.out.println("res:" + converter.getCurrentResolution());
    }

    public double getCurrentLat() {
        return this.currentLat;
    }

    public void setCurrentLat(double currentLat) {
        this.currentLat = currentLat;
    }

    public double getCurrentLong() {
        return this.currentLong;
    }

    public void setCurrentLong(double currentLong) {
        this.currentLong = currentLong;
    }

    public double getCurrentResolution() {
        return this.currentResolution;
    }

    public void setCurrentResolution(double currentResolution) {
        this.currentResolution = currentResolution;
    }
}

