/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.batch;

import org.gcube.dataanalysis.geo.meta.GenericLayerMetadata;
import org.opengis.metadata.identification.TopicCategory;

public class OpenBioMetadataInsertDev {
    static String geonetworkurl = "http://geoserver-dev2.d4science-ii.research-infrastructures.eu/geonetwork/";
    static String user = "admin";
    static String password = "admin";

    public static void main(String[] args) throws Exception {
        OpenBioMetadataInsertDev.examplelayer("Rainfall OpenModeller", "rain_coolest.tiff");
        OpenBioMetadataInsertDev.examplelayer("Average Temperature OpenModeller", "temp_avg.tiff");
    }

    private static void examplelayer(String layername, String filename) throws Exception {
        GenericLayerMetadata metadataInserter = new GenericLayerMetadata();
        metadataInserter.setGeonetworkUrl(geonetworkurl);
        metadataInserter.setGeonetworkUser(user);
        metadataInserter.setGeonetworkPwd(password);
        metadataInserter.setTitle(layername);
        metadataInserter.setCategoryTypes("_" + TopicCategory.ENVIRONMENT.name() + "_");
        metadataInserter.setResolution(0.5);
        metadataInserter.setAbstractField("Example layer from OpenModeller. OpenModeller aims to provide a flexible, user friendly, cross-platform environment where the entire process of conducting a fundamental niche modeling experiment can be carried out. Hosted on the D4Science Thredds Catalog: http://thredds.d4science.org/thredds/catalog/public/netcdf/catalog.xml");
        metadataInserter.setCustomTopics("D4Science", "EUBrazilOpenBio", "OpenModeller", layername, filename, "Thredds");
        metadataInserter.setAuthor("D4Science");
        String[] urls = new String[]{"http://thredds.d4science.org/thredds/fileServer/public/netcdf/" + filename};
        String[] protocols = new String[]{"HTTP"};
        metadataInserter.customMetaDataInsert(urls, protocols);
    }
}

