/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;

public class ThreddsExplorer {
    public static String timePrefix = "time:";

    public static List<String> getFiles(String catalogURL) throws Exception {
        String xml = HttpRequest.sendGetRequest((String)catalogURL, null);
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression xPathExpression = xpath.compile("//child::*[local-name()='catalog']/child::*[local-name()='dataset']/child::*[local-name()='dataset']");
        InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        NodeList nodes = (NodeList)xPathExpression.evaluate(inputSource, XPathConstants.NODESET);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            if (name == null) continue;
            fileNames.add(name);
        }
        return fileNames;
    }

    public static boolean isGridDataset(String filename) {
        try {
            AnalysisLogger.getLogger().debug((Object)("Analyzing file " + filename));
            Formatter errlog = new Formatter();
            FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.GRID, (String)filename, null, (Formatter)errlog);
            if (fdataset == null) {
                AnalysisLogger.getLogger().debug((Object)"ThreddsDataExplorer-> NOT GRID");
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isPointDataset(String filename) {
        try {
            Formatter errlog = new Formatter();
            FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)filename, null, (Formatter)errlog);
            if (fdataset == null) {
                AnalysisLogger.getLogger().debug((Object)"ThreddsDataExplorer-> NOT POINT");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDataset(String filename) throws Exception {
        boolean isdataset = false;
        try {
            Formatter errlog = new Formatter();
            FeatureType[] fts = FeatureType.values();
            for (int i = 0; i < fts.length; ++i) {
                FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)fts[i], (String)filename, null, (Formatter)errlog);
                if (fdataset == null) continue;
                AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> " + fts[i] + " OK!"));
                isdataset = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isdataset;
    }
}

