/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.MAMath;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;

public class GridCoordinate2D {
    private static boolean debug = false;
    private static Logger log = LoggerFactory.getLogger(GridCoordinate2D.class);
    private CoordinateAxis2D latCoord;
    private CoordinateAxis2D lonCoord;
    private ArrayDouble.D2 latEdge;
    private ArrayDouble.D2 lonEdge;
    private MAMath.MinMax latMinMax;
    private MAMath.MinMax lonMinMax;
    int nrows;
    int ncols;

    public GridCoordinate2D(CoordinateAxis2D latCoord, CoordinateAxis2D lonCoord) {
        this.latCoord = latCoord;
        this.lonCoord = lonCoord;
        assert (latCoord.getRank() == 2);
        assert (lonCoord.getRank() == 2);
        int[] shape = latCoord.getShape();
        this.nrows = shape[0];
        this.ncols = shape[1];
    }

    private void findBounds() {
        if (this.lonMinMax != null) {
            return;
        }
        if (this.lonEdge == null && this.latEdge == null) {
            this.lonEdge = CoordinateAxis2D.makeXEdges((ArrayDouble.D2)this.lonCoord.getMidpoints());
            this.latEdge = CoordinateAxis2D.makeYEdges((ArrayDouble.D2)this.latCoord.getMidpoints());
            this.latMinMax = MAMath.getMinMax((Array)this.latEdge);
            this.lonMinMax = MAMath.getMinMax((Array)this.lonEdge);
        }
        if (debug) {
            System.out.printf("Bounds (%d %d): lat= (%f,%f) lon = (%f,%f) %n", this.nrows, this.ncols, this.latMinMax.min, this.latMinMax.max, this.lonMinMax.min, this.lonMinMax.max);
        }
    }

    public boolean findCoordElementForce(double wantLat, double wantLon, int[] rectIndex) {
        this.findBounds();
        if (wantLat < this.latMinMax.min) {
            return false;
        }
        if (wantLat > this.latMinMax.max) {
            return false;
        }
        if (wantLon < this.lonMinMax.min) {
            return false;
        }
        if (wantLon > this.lonMinMax.max) {
            return false;
        }
        boolean saveDebug = debug;
        debug = false;
        for (int row = 0; row < this.nrows; ++row) {
            int col = 0;
            while (col < this.ncols) {
                rectIndex[0] = row;
                rectIndex[1] = col++;
                if (!this.contains(wantLat, wantLon, rectIndex)) continue;
                debug = saveDebug;
                return true;
            }
        }
        return false;
    }

    public boolean findCoordElement(double wantLat, double wantLon, int[] rectIndex) {
        return this.findCoordElementNoForce(wantLat, wantLon, rectIndex);
    }

    public boolean findCoordElementNoForce(double wantLat, double wantLon, int[] rectIndex) {
        this.findBounds();
        if (wantLat < this.latMinMax.min) {
            return false;
        }
        if (wantLat > this.latMinMax.max) {
            return false;
        }
        if (wantLon < this.lonMinMax.min) {
            return false;
        }
        if (wantLon > this.lonMinMax.max) {
            return false;
        }
        double gradientLat = (this.latMinMax.max - this.latMinMax.min) / (double)this.nrows;
        double gradientLon = (this.lonMinMax.max - this.lonMinMax.min) / (double)this.ncols;
        double diffLat = wantLat - this.latMinMax.min;
        double diffLon = wantLon - this.lonMinMax.min;
        rectIndex[0] = (int)Math.round(diffLat / gradientLat);
        rectIndex[1] = (int)Math.round(diffLon / gradientLon);
        int count = 0;
        do {
            ++count;
            if (debug) {
                System.out.printf("%nIteration %d %n", count);
            }
            if (this.contains(wantLat, wantLon, rectIndex)) {
                return true;
            }
            if (this.jump2(wantLat, wantLon, rectIndex)) continue;
            return false;
        } while (count <= 10);
        return this.incr(wantLat, wantLon, rectIndex);
    }

    private boolean containsOld(double wantLat, double wantLon, int[] rectIndex) {
        rectIndex[0] = Math.max(Math.min(rectIndex[0], this.nrows - 1), 0);
        rectIndex[1] = Math.max(Math.min(rectIndex[1], this.ncols - 1), 0);
        int row = rectIndex[0];
        int col = rectIndex[1];
        if (debug) {
            System.out.printf(" (%d,%d) contains (%f,%f) in (lat=%f %f) (lon=%f %f) ?%n", rectIndex[0], rectIndex[1], wantLat, wantLon, this.latEdge.get(row, col), this.latEdge.get(row + 1, col), this.lonEdge.get(row, col), this.lonEdge.get(row, col + 1));
        }
        if (wantLat < this.latEdge.get(row, col)) {
            return false;
        }
        if (wantLat > this.latEdge.get(row + 1, col)) {
            return false;
        }
        if (wantLon < this.lonEdge.get(row, col)) {
            return false;
        }
        return !(wantLon > this.lonEdge.get(row, col + 1));
    }

    private boolean contains(double wantLat, double wantLon, int[] rectIndex) {
        rectIndex[0] = Math.max(Math.min(rectIndex[0], this.nrows - 1), 0);
        rectIndex[1] = Math.max(Math.min(rectIndex[1], this.ncols - 1), 0);
        int row = rectIndex[0];
        int col = rectIndex[1];
        double x1 = this.lonEdge.get(row, col);
        double y1 = this.latEdge.get(row, col);
        double x2 = this.lonEdge.get(row, col + 1);
        double y2 = this.latEdge.get(row, col + 1);
        double x3 = this.lonEdge.get(row + 1, col + 1);
        double y3 = this.latEdge.get(row + 1, col + 1);
        double x4 = this.lonEdge.get(row + 1, col);
        double y4 = this.latEdge.get(row + 1, col);
        return true;
    }

    private boolean detIsPositive(double x0, double y0, double x1, double y1, double x2, double y2) {
        double det = x1 * y2 - y1 * x2 - x0 * y2 + y0 * x2 + x0 * y1 - y0 * x1;
        if (det == 0.0) {
            System.out.printf("determinate = 0%n", new Object[0]);
        }
        return det > 0.0;
    }

    private boolean jumpOld(double wantLat, double wantLon, int[] rectIndex) {
        int row = Math.max(Math.min(rectIndex[0], this.nrows - 1), 0);
        int col = Math.max(Math.min(rectIndex[1], this.ncols - 1), 0);
        double gradientLat = this.latEdge.get(row + 1, col) - this.latEdge.get(row, col);
        double gradientLon = this.lonEdge.get(row, col + 1) - this.lonEdge.get(row, col);
        double diffLat = wantLat - this.latEdge.get(row, col);
        double diffLon = wantLon - this.lonEdge.get(row, col);
        int drow = (int)Math.round(diffLat / gradientLat);
        int dcol = (int)Math.round(diffLon / gradientLon);
        if (debug) {
            System.out.printf("   jump from %d %d (grad=%f %f) (diff=%f %f) (delta=%d %d)", row, col, gradientLat, gradientLon, diffLat, diffLon, drow, dcol);
        }
        if (drow == 0 && dcol == 0) {
            if (debug) {
                System.out.printf("%n   incr:", new Object[0]);
            }
            return this.incr(wantLat, wantLon, rectIndex);
        }
        rectIndex[0] = Math.max(Math.min(row + drow, this.nrows - 1), 0);
        rectIndex[1] = Math.max(Math.min(col + dcol, this.ncols - 1), 0);
        if (debug) {
            System.out.printf(" to (%d %d)%n", rectIndex[0], rectIndex[1]);
        }
        return row != rectIndex[0] || col != rectIndex[1];
    }

    private boolean jump2(double wantLat, double wantLon, int[] rectIndex) {
        int row = Math.max(Math.min(rectIndex[0], this.nrows - 1), 0);
        int col = Math.max(Math.min(rectIndex[1], this.ncols - 1), 0);
        double dlatdy = this.latEdge.get(row + 1, col) - this.latEdge.get(row, col);
        double dlatdx = this.latEdge.get(row, col + 1) - this.latEdge.get(row, col);
        double dlondx = this.lonEdge.get(row, col + 1) - this.lonEdge.get(row, col);
        double dlondy = this.lonEdge.get(row + 1, col) - this.lonEdge.get(row, col);
        double diffLat = wantLat - this.latEdge.get(row, col);
        double diffLon = wantLon - this.lonEdge.get(row, col);
        double dx = (diffLon - dlondy * diffLat / dlatdy) / (dlondx - dlatdx * dlondy / dlatdy);
        double dy = (diffLat - dlatdx * dx) / dlatdy;
        if (debug) {
            System.out.printf("   jump from %d %d (dlondx=%f dlondy=%f dlatdx=%f dlatdy=%f) (diffLat,Lon=%f %f) (deltalat,Lon=%f %f)", row, col, dlondx, dlondy, dlatdx, dlatdy, diffLat, diffLon, dy, dx);
        }
        int drow = (int)Math.round(dy);
        int dcol = (int)Math.round(dx);
        if (drow == 0 && dcol == 0) {
            if (debug) {
                System.out.printf("%n   incr:", new Object[0]);
            }
            return this.incr(wantLat, wantLon, rectIndex);
        }
        rectIndex[0] = Math.max(Math.min(row + drow, this.nrows - 1), 0);
        rectIndex[1] = Math.max(Math.min(col + dcol, this.ncols - 1), 0);
        if (debug) {
            System.out.printf(" to (%d %d)%n", rectIndex[0], rectIndex[1]);
        }
        return row != rectIndex[0] || col != rectIndex[1];
    }

    private boolean incr(double wantLat, double wantLon, int[] rectIndex) {
        int row = rectIndex[0];
        int col = rectIndex[1];
        double diffLat = wantLat - this.latEdge.get(row, col);
        double diffLon = wantLon - this.lonEdge.get(row, col);
        if (Math.abs(diffLat) > Math.abs(diffLon)) {
            rectIndex[0] = row + (diffLat > 0.0 ? 1 : -1);
            if (this.contains(wantLat, wantLon, rectIndex)) {
                return true;
            }
            rectIndex[1] = col + (diffLon > 0.0 ? 1 : -1);
            if (this.contains(wantLat, wantLon, rectIndex)) {
                return true;
            }
        } else {
            rectIndex[1] = col + (diffLon > 0.0 ? 1 : -1);
            if (this.contains(wantLat, wantLon, rectIndex)) {
                return true;
            }
            rectIndex[0] = row + (diffLat > 0.0 ? 1 : -1);
            if (this.contains(wantLat, wantLon, rectIndex)) {
                return true;
            }
        }
        rectIndex[0] = row;
        rectIndex[1] = col;
        return this.box9(wantLat, wantLon, rectIndex);
    }

    private boolean box9(double wantLat, double wantLon, int[] rectIndex) {
        int row = rectIndex[0];
        int minrow = Math.max(row - 1, 0);
        int maxrow = Math.min(row + 1, this.nrows);
        int col = rectIndex[1];
        int mincol = Math.max(col - 1, 0);
        int maxcol = Math.min(col + 1, this.ncols);
        if (debug) {
            System.out.printf("%n   box9:", new Object[0]);
        }
        for (int i = minrow; i <= maxrow; ++i) {
            int j = mincol;
            while (j <= maxcol) {
                rectIndex[0] = i;
                rectIndex[1] = j++;
                if (!this.contains(wantLat, wantLon, rectIndex)) continue;
                return true;
            }
        }
        return false;
    }

    public static void doOne(GridCoordinate2D g2d, double wantLat, double wantLon) {
        int[] result = new int[2];
        if (!g2d.findCoordElementForce(wantLat, wantLon, result)) {
            System.out.printf("Brute (%f %f) FAIL", wantLat, wantLon);
            return;
        }
        System.out.printf("Brute (%f %f) == (%d %d) %n", wantLat, wantLon, result[0], result[1]);
        if (g2d.findCoordElement(wantLat, wantLon, result)) {
            System.out.printf("(%f %f) == (%d %d) %n", wantLat, wantLon, result[0], result[1]);
        } else {
            System.out.printf("(%f %f) FAIL %n", wantLat, wantLon);
        }
        System.out.printf("----------------------------------------%n", new Object[0]);
    }

    public static void test1() throws IOException {
        String filename = "D:/work/asaScience/EGM200_3.ncml";
        GridDataset gds = GridDataset.open((String)filename);
        GeoGrid grid = gds.findGridByName("u_wind");
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis lonAxis = gcs.getXHorizAxis();
        assert (lonAxis instanceof CoordinateAxis2D);
        CoordinateAxis latAxis = gcs.getYHorizAxis();
        assert (latAxis instanceof CoordinateAxis2D);
        GridCoordinate2D g2d = new GridCoordinate2D((CoordinateAxis2D)latAxis, (CoordinateAxis2D)lonAxis);
        GridCoordinate2D.doOne(g2d, 35.0, -6.0);
        GridCoordinate2D.doOne(g2d, 34.667302, -5.008376);
        GridCoordinate2D.doOne(g2d, 34.667303, -6.39424);
        GridCoordinate2D.doOne(g2d, 36.6346, -5.0084);
        GridCoordinate2D.doOne(g2d, 36.6346, -6.39424);
        gds.close();
    }

    public static void test2() throws IOException {
        String filename = "C:/data/fmrc/apex_fmrc/Run_20091025_0000.nc";
        GridDataset gds = GridDataset.open((String)filename);
        GeoGrid grid = gds.findGridByName("temp");
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis lonAxis = gcs.getXHorizAxis();
        assert (lonAxis instanceof CoordinateAxis2D);
        CoordinateAxis latAxis = gcs.getYHorizAxis();
        assert (latAxis instanceof CoordinateAxis2D);
        GridCoordinate2D g2d = new GridCoordinate2D((CoordinateAxis2D)latAxis, (CoordinateAxis2D)lonAxis);
        GridCoordinate2D.doOne(g2d, 40.166959, -73.954234);
        gds.close();
    }

    public static void test3() throws IOException {
        String filename = "/data/testdata/cdmUnitTest/fmrc/rtofs/ofs.20091122/ofs_atl.t00z.F024.grb.grib2";
        GridDataset gds = GridDataset.open((String)filename);
        GeoGrid grid = gds.findGridByName("Sea_Surface_Height_Relative_to_Geoid");
        GridCoordSystem gcs = grid.getCoordinateSystem();
        CoordinateAxis lonAxis = gcs.getXHorizAxis();
        assert (lonAxis instanceof CoordinateAxis2D);
        CoordinateAxis latAxis = gcs.getYHorizAxis();
        assert (latAxis instanceof CoordinateAxis2D);
        GridCoordinate2D g2d = new GridCoordinate2D((CoordinateAxis2D)latAxis, (CoordinateAxis2D)lonAxis);
        GridCoordinate2D.doOne(g2d, -15.554099426977835, -0.7742870290336263);
        gds.close();
    }

    public static void main(String[] args) throws IOException {
        GridCoordinate2D.test3();
    }
}

